/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import java.util.Objects;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.business.internal.query.WorkspaceImageQuery;

public class DNodeQuery {
    private static final Dimension DEFAULT_NODE_DIMENSION = new Dimension(2, 2);
    private final DNode node;

    public DNodeQuery(DNode node) {
        this.node = Objects.requireNonNull(node);
    }

    public Dimension getDefaultDimension() {
        Dimension result = DEFAULT_NODE_DIMENSION.getCopy();
        if (this.node.getStyle() instanceof WorkspaceImage) {
            WorkspaceImageQuery imageQuery = new WorkspaceImageQuery((WorkspaceImage)this.node.getStyle());
            if (imageQuery.doesImageExist()) {
                if (this.node.getWidth() == null || Integer.valueOf(this.node.getWidth()) == -1) {
                    Dimension imageSize = imageQuery.getDefaultDimension();
                    result.setWidth(imageSize.width);
                    result.setHeight(imageSize.height);
                } else {
                    double newHeight = (double)this.node.getWidth().intValue() / imageQuery.getRatio();
                    result.setWidth(this.node.getWidth() * 10);
                    result.setHeight((int)(newHeight * 10.0));
                }
            }
        } else {
            if (this.node.getWidth() != null) {
                result.setWidth(this.node.getWidth().intValue());
            }
            if (this.node.getHeight() != null) {
                result.setHeight(this.node.getHeight().intValue());
            }
            if (result.width != -1) {
                result.setWidth(result.width * 10);
            }
            if (result.height != -1) {
                result.setHeight(result.height * 10);
            }
        }
        return result;
    }
}

