/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

class AssociationClassProperties {
    private final @NonNull List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds;
    private final Property[][] properties;

    public AssociationClassProperties(@NonNull List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds) {
        this.umlMemberEnds = umlMemberEnds;
        int size = umlMemberEnds.size();
        this.properties = new Property[size + 1][size];
        int i = 0;
        while (i < size) {
            this.properties[i] = new Property[size];
            ++i;
        }
    }

    public Property get(@Nullable org.eclipse.uml2.uml.Property umlFromProperty, @Nullable org.eclipse.uml2.uml.Property umlToProperty) {
        int fromIndex = this.getIndex(umlFromProperty);
        int toIndex = this.getIndex(umlToProperty);
        assert (fromIndex != toIndex);
        return this.properties[fromIndex][toIndex > fromIndex ? toIndex - 1 : toIndex];
    }

    private int getIndex(@Nullable org.eclipse.uml2.uml.Property umlProperty) {
        if (umlProperty == null) {
            return 0;
        }
        int index = this.umlMemberEnds.indexOf(umlProperty);
        assert (index >= 0);
        return index + 1;
    }

    public @NonNull Map<@NonNull org.eclipse.uml2.uml.Property, @NonNull org.eclipse.uml2.uml.Property> getPropertyToRedefinedPropertyMapping(@NonNull AssociationClassProperties asRedefinedAssociationClassProperties) {
        org.eclipse.uml2.uml.Property oldProperty;
        ArrayList<@NonNull org.eclipse.uml2.uml.Property> redefiningMemberEnds = new ArrayList<org.eclipse.uml2.uml.Property>(this.umlMemberEnds);
        ArrayList<@NonNull org.eclipse.uml2.uml.Property> redefinedMemberEnds = new ArrayList<org.eclipse.uml2.uml.Property>(asRedefinedAssociationClassProperties.umlMemberEnds);
        HashMap<@NonNull org.eclipse.uml2.uml.Property, @NonNull org.eclipse.uml2.uml.Property> propertyToRedefinedPropertyMapping = new HashMap<org.eclipse.uml2.uml.Property, org.eclipse.uml2.uml.Property>();
        block0: for (org.eclipse.uml2.uml.Property redefiningProperty : redefiningMemberEnds) {
            for (org.eclipse.uml2.uml.Property redefinedProperty : redefiningProperty.getRedefinedProperties()) {
                if (redefinedProperty == null || !redefinedMemberEnds.contains(redefinedProperty)) continue;
                oldProperty = propertyToRedefinedPropertyMapping.put(redefiningProperty, redefinedProperty);
                assert (oldProperty == null);
                continue block0;
            }
        }
        redefiningMemberEnds.removeAll(propertyToRedefinedPropertyMapping.keySet());
        redefinedMemberEnds.removeAll(propertyToRedefinedPropertyMapping.values());
        if (redefiningMemberEnds.size() > 1) {
            block2: for (org.eclipse.uml2.uml.Property redefiningProperty : redefiningMemberEnds) {
                for (org.eclipse.uml2.uml.Property subsettedProperty : redefiningProperty.getSubsettedProperties()) {
                    if (subsettedProperty == null || !redefinedMemberEnds.contains(subsettedProperty)) continue;
                    oldProperty = propertyToRedefinedPropertyMapping.put(redefiningProperty, subsettedProperty);
                    assert (oldProperty == null);
                    continue block2;
                }
            }
            redefiningMemberEnds.removeAll(propertyToRedefinedPropertyMapping.keySet());
            redefinedMemberEnds.removeAll(propertyToRedefinedPropertyMapping.values());
            if (redefiningMemberEnds.size() > 1) {
                block4: for (org.eclipse.uml2.uml.Property redefiningProperty : redefiningMemberEnds) {
                    String name = redefiningProperty.getName();
                    for (org.eclipse.uml2.uml.Property redefinedProperty : redefinedMemberEnds) {
                        if (!ClassUtil.safeEquals((Object)name, (Object)redefinedProperty.getName())) continue;
                        org.eclipse.uml2.uml.Property oldProperty2 = propertyToRedefinedPropertyMapping.put(redefiningProperty, redefinedProperty);
                        assert (oldProperty2 == null);
                        continue block4;
                    }
                }
                redefiningMemberEnds.removeAll(propertyToRedefinedPropertyMapping.keySet());
                redefinedMemberEnds.removeAll(propertyToRedefinedPropertyMapping.values());
            }
        }
        if (redefiningMemberEnds.size() == 1 && redefinedMemberEnds.size() == 1) {
            org.eclipse.uml2.uml.Property oldProperty3 = propertyToRedefinedPropertyMapping.put((org.eclipse.uml2.uml.Property)redefiningMemberEnds.remove(0), (org.eclipse.uml2.uml.Property)redefinedMemberEnds.remove(0));
            assert (oldProperty3 == null);
        }
        assert (redefiningMemberEnds.size() == 0);
        return propertyToRedefinedPropertyMapping;
    }

    public void put(@Nullable org.eclipse.uml2.uml.Property umlFromProperty, @Nullable org.eclipse.uml2.uml.Property umlToProperty, @NonNull Property asFrom2ToProperty) {
        int fromIndex = this.getIndex(umlFromProperty);
        int toIndex = this.getIndex(umlToProperty);
        assert (fromIndex != toIndex);
        this.properties[fromIndex][toIndex > fromIndex ? toIndex - 1 : toIndex] = asFrom2ToProperty;
    }
}

