/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.workbench.AbstractFilteredTree;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.search.SearchHistoryPopupDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.TaskHistoryDropDown;
import org.eclipse.mylyn.internal.tasks.ui.TaskScalingHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TaskWorkingSetFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RepositoryElementActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskWorkingSetAction;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.UiLegendDialog;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskListFilteredTree
extends AbstractFilteredTree {
    public static final String LABEL_SEARCH = Messages.TaskListFilteredTree_Search_repository_for_key_or_summary_;
    private TaskScalingHyperlink workingSetLink;
    private TaskScalingHyperlink activeTaskLink;
    private WorkweekProgressBar taskProgressBar;
    private int totalTasks;
    private int completeTime;
    private int completeTasks;
    private int incompleteTime;
    private IWorkingSet currentWorkingSet;
    private MenuManager activeTaskMenuManager;
    private TaskListToolTip taskListToolTip;
    private ITaskListChangeListener changeListener;
    private TaskListChangeAdapter taskProgressBarChangeListener;
    private TaskActivityAdapter taskProgressBarActivityListener;
    private IPropertyChangeListener taskProgressBarWorkingSetListener;
    private TaskWorkingSetFilter workingSetFilter;
    private final IWorkbenchWindow window;
    private SelectionProviderAdapter activeTaskSelectionProvider;
    private RepositoryElementActionGroup actionGroup;
    private StructuredSelection activeSelection;
    private final AbstractSearchHandler searchHandler;
    private Composite searchComposite;

    public TaskListFilteredTree(Composite parent, int treeStyle, AbstractSearchHandler searchHandler, IWorkbenchWindow window) {
        super(parent, treeStyle, searchHandler.createFilter());
        this.searchHandler = searchHandler;
        this.initSearchComposite();
        this.hookContextMenu();
        this.window = window;
        this.indicateActiveTaskWorkingSet();
        this.addDisposeListener(e -> {
            if (this.changeListener != null) {
                TasksUiInternal.getTaskList().removeChangeListener(this.changeListener);
            }
            if (this.taskProgressBarChangeListener != null) {
                TasksUiInternal.getTaskList().removeChangeListener((ITaskListChangeListener)this.taskProgressBarChangeListener);
            }
            if (this.taskProgressBarActivityListener != null) {
                TasksUi.getTaskActivityManager().removeActivityListener((ITaskActivityListener)this.taskProgressBarActivityListener);
            }
            if (this.taskProgressBarWorkingSetListener != null) {
                PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.taskProgressBarWorkingSetListener);
            }
            this.actionGroup.setSelectionProvider(null);
            this.activeTaskMenuManager.dispose();
            if (this.taskListToolTip != null) {
                this.taskListToolTip.dispose();
            }
        });
    }

    private void hookContextMenu() {
        this.actionGroup = new RepositoryElementActionGroup();
        this.activeTaskMenuManager = new MenuManager("#PopupMenu");
        this.activeTaskMenuManager.setRemoveAllWhenShown(true);
        this.activeTaskMenuManager.addMenuListener(manager -> this.actionGroup.fillContextMenu(manager));
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)new TreeColumnLayout());
        return super.doCreateTreeViewer(container, style);
    }

    protected Composite createProgressComposite(Composite container) {
        Composite progressComposite = new Composite(container, 0);
        GridLayout progressLayout = new GridLayout(1, false);
        progressLayout.marginWidth = 4;
        progressLayout.marginHeight = 0;
        progressLayout.marginBottom = 0;
        progressLayout.horizontalSpacing = 0;
        progressLayout.verticalSpacing = 0;
        progressComposite.setLayout((Layout)progressLayout);
        progressComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.taskProgressBar = new WorkweekProgressBar(progressComposite);
        this.taskProgressBar.setLayoutData(new GridData(4, 4, true, true));
        this.updateTaskProgressBar();
        this.taskProgressBarChangeListener = new TaskListChangeAdapter(){

            @Override
            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    if (!(taskContainerDelta.getElement() instanceof ITask)) continue;
                    TaskListFilteredTree.this.updateTaskProgressBar();
                    break;
                }
            }
        };
        TasksUiInternal.getTaskList().addChangeListener((ITaskListChangeListener)this.taskProgressBarChangeListener);
        this.taskProgressBarActivityListener = new TaskActivityAdapter(){

            public void activityReset() {
                TaskListFilteredTree.this.updateTaskProgressBar();
            }
        };
        TasksUiPlugin.getTaskActivityManager().addActivityListener((ITaskActivityListener)this.taskProgressBarActivityListener);
        this.taskProgressBarWorkingSetListener = event -> {
            String property = event.getProperty();
            if ("workingSetContentChange".equals(property) || "workingSetRemove".equals(property)) {
                this.updateTaskProgressBar();
            }
        };
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.taskProgressBarWorkingSetListener);
        return progressComposite;
    }

    protected Composite createSearchComposite(Composite container) {
        this.searchComposite = new Composite(container, 0);
        GridLayout searchLayout = new GridLayout(2, false);
        searchLayout.marginHeight = 0;
        searchLayout.marginWidth = 0;
        this.searchComposite.setLayout((Layout)searchLayout);
        this.searchComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        return this.searchComposite;
    }

    private void initSearchComposite() {
        this.searchHandler.createSearchComposite(this.searchComposite);
        this.searchHandler.adaptTextSearchControl(this.getTextSearchControl().getTextControl());
        this.searchHandler.addFilterChangeListener(() -> this.getRefreshPolicy().filterChanged());
        if (SearchUtil.supportsTaskSearch()) {
            final TaskScalingHyperlink searchLink = new TaskScalingHyperlink(this.searchComposite, 16384);
            searchLink.setText(LABEL_SEARCH);
            searchLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    SearchUtil.openSearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }

                public void linkEntered(HyperlinkEvent e) {
                    searchLink.setUnderlined(true);
                }

                public void linkExited(HyperlinkEvent e) {
                    searchLink.setUnderlined(false);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateTaskProgressBar() {
        if (this.taskProgressBar.isDisposed()) {
            return;
        }
        Set tasksThisWeek = TasksUiPlugin.getTaskActivityManager().getScheduledForADayThisWeek();
        if (this.workingSetFilter != null) {
            Iterator it = tasksThisWeek.iterator();
            while (it.hasNext()) {
                ITask task = (ITask)it.next();
                if (this.workingSetFilter.select(task)) continue;
                it.remove();
            }
        }
        this.totalTasks = tasksThisWeek.size();
        this.completeTime = 0;
        this.completeTasks = 0;
        this.incompleteTime = 0;
        for (ITask task : tasksThisWeek) {
            void abstractTask;
            ITask iTask = task;
            if (!(iTask instanceof AbstractTask)) continue;
            AbstractTask cfr_ignored_0 = (AbstractTask)iTask;
            AbstractTask cfr_ignored_1 = (AbstractTask)iTask;
            if (task.isCompleted()) {
                ++this.completeTasks;
                if (abstractTask.getEstimatedTimeHours() > 0) {
                    this.completeTime += abstractTask.getEstimatedTimeHours();
                    continue;
                }
                ++this.completeTime;
                continue;
            }
            if (abstractTask.getEstimatedTimeHours() > 0) {
                this.incompleteTime += abstractTask.getEstimatedTimeHours();
                continue;
            }
            ++this.incompleteTime;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (PlatformUI.isWorkbenchRunning() && !this.taskProgressBar.isDisposed()) {
                this.taskProgressBar.reset(this.completeTime, this.completeTime + this.incompleteTime);
                this.taskProgressBar.setToolTipText(Messages.TaskListFilteredTree_Workweek_Progress + "\n" + MessageFormat.format(Messages.TaskListFilteredTree_Estimated_hours, this.completeTime, this.completeTime + this.incompleteTime) + "\n" + MessageFormat.format(Messages.TaskListFilteredTree_Scheduled_tasks, this.completeTasks, this.totalTasks));
            }
        });
    }

    protected Composite createActiveWorkingSetComposite(Composite container) {
        final ImageHyperlink workingSetButton = new ImageHyperlink(container, 0x800000);
        workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
        workingSetButton.setToolTipText(Messages.TaskListFilteredTree_Select_Working_Set);
        this.workingSetLink = new TaskScalingHyperlink(container, 16384);
        this.workingSetLink.setText(TaskWorkingSetAction.LABEL_SETS_NONE);
        this.workingSetLink.setUnderlined(false);
        final TaskWorkingSetAction workingSetAction = new TaskWorkingSetAction();
        workingSetButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                workingSetAction.getMenu((Control)workingSetButton).setVisible(true);
            }

            public void linkEntered(HyperlinkEvent e) {
                workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent e) {
                workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.workingSetLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TaskListFilteredTree.this.currentWorkingSet != null) {
                    workingSetAction.run(TaskListFilteredTree.this.currentWorkingSet);
                } else {
                    workingSetAction.run();
                }
            }
        });
        return this.workingSetLink;
    }

    protected Composite createActiveTaskComposite(Composite container) {
        final ImageHyperlink activeTaskButton = new ImageHyperlink(container, 16384);
        activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
        activeTaskButton.setToolTipText(Messages.TaskListFilteredTree_Select_Active_Task);
        this.activeTaskLink = new TaskScalingHyperlink(container, 16384);
        this.changeListener = new TaskListChangeAdapter(){

            @Override
            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    AbstractTask changedTask;
                    if (!(taskContainerDelta.getElement() instanceof ITask) || !(changedTask = (AbstractTask)taskContainerDelta.getElement()).isActive() || !Platform.isRunning() || PlatformUI.getWorkbench() == null) continue;
                    if (Display.getCurrent() == null) {
                        if (PlatformUI.getWorkbench().getDisplay() == null || PlatformUI.getWorkbench().getDisplay().isDisposed()) continue;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> TaskListFilteredTree.this.indicateActiveTask((ITask)changedTask));
                        continue;
                    }
                    TaskListFilteredTree.this.indicateActiveTask((ITask)changedTask);
                }
            }
        };
        TasksUiInternal.getTaskList().addChangeListener(this.changeListener);
        this.activeTaskLink.setText(Messages.TaskListFilteredTree_Activate);
        this.activeTaskLink.setToolTipText("");
        this.taskListToolTip = new TaskListToolTip((Control)this.activeTaskLink);
        ITask activeTask = TasksUi.getTaskActivityManager().getActiveTask();
        if (activeTask != null) {
            this.indicateActiveTask(activeTask);
        }
        activeTaskButton.addHyperlinkListener(new IHyperlinkListener(){
            private Menu dropDownMenu;

            public void linkActivated(HyperlinkEvent event) {
                if (this.dropDownMenu != null) {
                    this.dropDownMenu.dispose();
                }
                TaskHistoryDropDown taskHistory = new TaskHistoryDropDown();
                taskHistory.setScopedToWorkingSet(true);
                this.dropDownMenu = new Menu((Control)activeTaskButton);
                taskHistory.fill(this.dropDownMenu, 0);
                this.dropDownMenu.setVisible(true);
            }

            public void linkEntered(HyperlinkEvent event) {
                activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent event) {
                activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.activeTaskLink.addMenuDetectListener(e -> {
            if (this.activeTaskSelectionProvider != null && this.activeSelection != null && !this.activeSelection.isEmpty()) {
                this.activeTaskLink.setFocus();
                this.activeTaskSelectionProvider.setSelection((ISelection)this.activeSelection);
                Menu activeTaskMenu = this.activeTaskMenuManager.createContextMenu((Control)container);
                activeTaskMenu.setVisible(true);
            }
        });
        this.activeTaskLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    ITask activeTask = TasksUi.getTaskActivityManager().getActiveTask();
                    if (activeTask == null) {
                        ActivateTaskDialogAction activateAction = new ActivateTaskDialogAction();
                        activateAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        activateAction.run(null);
                    } else {
                        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)activeTask);
                    }
                }
            }
        });
        return this.activeTaskLink;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.getFilterString() != null && !this.getFilterString().trim().equals("")) {
            this.setShowSearch(true);
        } else {
            this.setShowSearch(false);
        }
    }

    public void indicateActiveTaskWorkingSet() {
        if (this.window == null || this.workingSetLink == null || this.filterComposite == null || this.filterComposite.isDisposed()) {
            return;
        }
        Set<IWorkingSet> activeSets = TaskWorkingSetUpdater.getActiveWorkingSets(this.window);
        if (activeSets == null) {
            return;
        }
        if (activeSets.size() == 0) {
            this.workingSetLink.setText(TaskWorkingSetAction.LABEL_SETS_NONE);
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = null;
        } else if (activeSets.size() > 1) {
            this.workingSetLink.setText(Messages.TaskListFilteredTree__multiple_);
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = null;
        } else {
            Object[] array = activeSets.toArray();
            IWorkingSet workingSet = (IWorkingSet)array[0];
            this.workingSetLink.setText(workingSet.getLabel());
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = workingSet;
        }
        this.relayoutFilterControls();
    }

    public void indicateActiveTask(ITask task) {
        if (Display.getCurrent() != null) {
            if (this.filterComposite.isDisposed()) {
                return;
            }
            this.activeTaskLink.setTask(task);
            this.activeSelection = new StructuredSelection((Object)task);
            this.relayoutFilterControls();
        }
    }

    private void relayoutFilterControls() {
        this.filterComposite.layout();
    }

    public String getActiveTaskLabelText() {
        return this.activeTaskLink.getText();
    }

    public void indicateNoActiveTask() {
        if (this.filterComposite.isDisposed()) {
            return;
        }
        this.activeTaskLink.setTask(null);
        this.activeTaskLink.setText(Messages.TaskListFilteredTree_Activate);
        this.activeTaskLink.setToolTipText("");
        this.activeSelection = StructuredSelection.EMPTY;
        this.relayoutFilterControls();
    }

    public void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    protected String getFilterString() {
        String text = super.getFilterString();
        return text != null ? text.trim() : null;
    }

    public TaskWorkingSetFilter getWorkingSetFilter() {
        return this.workingSetFilter;
    }

    public void setWorkingSetFilter(TaskWorkingSetFilter workingSetFilter) {
        this.workingSetFilter = workingSetFilter;
    }

    public MenuManager getActiveTaskMenuManager() {
        return this.activeTaskMenuManager;
    }

    public SelectionProviderAdapter getActiveTaskSelectionProvider() {
        return this.activeTaskSelectionProvider;
    }

    public void setActiveTaskSelectionProvider(SelectionProviderAdapter activeTaskSelectionProvider) {
        this.activeTaskSelectionProvider = activeTaskSelectionProvider;
        this.actionGroup.setSelectionProvider((ISelectionProvider)activeTaskSelectionProvider);
    }

    protected SearchHistoryPopupDialog getHistoryPopupDialog() {
        return null;
    }

    protected Composite createAdditionalControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        ImageHyperlink showUILegend = new ImageHyperlink(container, 0);
        showUILegend.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.QUESTION));
        showUILegend.setToolTipText(Messages.TaskListFilteredTree_Show_Tasks_UI_Legend);
        showUILegend.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendDialog uiLegendDialog = new UiLegendDialog(WorkbenchUtil.getShell());
                uiLegendDialog.open();
            }
        });
        return container;
    }
}

