/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class TaskEditorOutlineNodeLabelProvider
extends LabelProvider {
    private static final String[] IMAGE_EXTENSIONS = new String[]{"jpg", "gif", "png", "tiff", "tif", "bmp"};

    /*
     * WARNING - void declaration
     */
    public Image getImage(Object element) {
        Object object = element;
        if (object instanceof TaskEditorOutlineNode) {
            void node;
            TaskEditorOutlineNode taskEditorOutlineNode = (TaskEditorOutlineNode)object;
            TaskEditorOutlineNode cfr_ignored_0 = (TaskEditorOutlineNode)object;
            if (TaskEditorOutlineNode.LABEL_COMMENTS.equals(node.getLabel()) || TaskEditorOutlineNode.LABEL_NEW_COMMENT.equals(node.getLabel())) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.COMMENT);
            }
            if (TaskEditorOutlineNode.LABEL_DESCRIPTION.equals(node.getLabel())) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_NOTES);
            }
            if (node.getTaskComment() != null) {
                IRepositoryPerson author = node.getTaskComment().getAuthor();
                TaskAttribute taskAttribute = node.getData();
                String repositoryUrl = taskAttribute.getTaskData().getRepositoryUrl();
                String connectorKind = null;
                TaskRepository taskRepository = null;
                if (repositoryUrl != null && (connectorKind = taskAttribute.getTaskData().getConnectorKind()) != null) {
                    taskRepository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
                }
                if (taskRepository != null && author != null && author.matchesUsername(taskRepository.getUserName())) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME);
                }
                return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON);
            }
            if (node.getTaskAttachment() != null) {
                int dotIndex;
                ITaskAttachment attachment = node.getTaskAttachment();
                if (AttachmentUtil.isContext(attachment)) {
                    return CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_TRANSFER);
                }
                if (attachment.isPatch()) {
                    return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_ATTACHMENT_PATCH);
                }
                String filename = attachment.getFileName();
                if (filename != null && (dotIndex = filename.lastIndexOf(46)) != -1) {
                    String fileType = filename.substring(dotIndex + 1);
                    String[] stringArray = IMAGE_EXTENSIONS;
                    int n = IMAGE_EXTENSIONS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element2 = stringArray[n2];
                        if (element2.equalsIgnoreCase(fileType)) {
                            return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                        }
                        ++n2;
                    }
                }
                return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
            }
            if (node.getParent() == null) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK);
            }
            if (TaskEditorOutlineNode.LABEL_RELATED_TASKS.equals(node.getLabel()) || TaskEditorOutlineNode.LABEL_ATTRIBUTES.equals(node.getLabel())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object element) {
        Object object = element;
        if (object instanceof TaskEditorOutlineNode) {
            void node;
            TaskEditorOutlineNode taskEditorOutlineNode = (TaskEditorOutlineNode)object;
            TaskEditorOutlineNode cfr_ignored_0 = (TaskEditorOutlineNode)object;
            if (TaskEditorOutlineNode.LABEL_COMMENTS.equals(node.getLabel()) || TaskEditorOutlineNode.LABEL_NEW_COMMENT.equals(node.getLabel()) || TaskEditorOutlineNode.LABEL_DESCRIPTION.equals(node.getLabel())) {
                return node.getLabel();
            }
            if (node.getData() != null && node.getTaskAttachment() == null && node.getTaskComment() == null) {
                TaskAttribute taskAttribute = node.getData();
                Object label = taskAttribute.getTaskData().getAttributeMapper().getLabel(taskAttribute);
                if (!((String)label).endsWith(":")) {
                    label = (String)label + ":";
                }
                return (String)label + " " + taskAttribute.getTaskData().getAttributeMapper().getValueLabel(taskAttribute);
            }
            return node.getLabel();
        }
        return super.getText(element);
    }
}

