/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.workbench.WorkbenchActionSupport;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskEditorActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskPlanningEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class TaskEditorActionContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private TaskEditor editor;
    private final WorkbenchActionSupport actionSupport = new WorkbenchActionSupport();
    private final SelectionProviderAdapterExtension selectionProvider;
    private final TaskEditorActionGroup actionGroup;

    public TaskEditorActionContributor() {
        this.actionSupport.setCallback((WorkbenchActionSupport.WorkbenchActionCallback)new EditorPageCallback());
        this.selectionProvider = new SelectionProviderAdapterExtension();
        this.actionGroup = new TaskEditorActionGroup(this.actionSupport);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        IFormPage page = this.getActivePage();
        boolean addClipboard = page instanceof TaskPlanningEditor || page instanceof AbstractTaskEditorPage;
        this.contextMenuAboutToShow(mng, addClipboard);
    }

    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        this.actionGroup.fillContextMenu(manager, this.editor, addClipboard);
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void dispose() {
        this.actionGroup.setSelectionProvider(null);
    }

    public void forceActionsEnabled() {
        this.actionSupport.forceEditActionsEnabled();
    }

    private IFormPage getActivePage() {
        return this.editor != null ? this.editor.getActivePageInstance() : null;
    }

    public TaskEditor getEditor() {
        return this.editor;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.actionSupport.install(bars);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.actionGroup.getSynchronizeEditorAction());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.actionSupport.selectionChanged(event);
        this.actionGroup.getNewTaskFromSelectionAction().selectionChanged(event.getSelection());
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (this.editor != null) {
            this.editor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        }
        if (activeEditor instanceof TaskEditor) {
            this.editor = (TaskEditor)activeEditor;
            this.editor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
            this.actionGroup.getSynchronizeEditorAction().selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.editor));
            this.updateSelectableActions(this.selectionProvider.getSelection());
        } else {
            this.actionGroup.getSynchronizeEditorAction().selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.editor = null;
        }
    }

    public void setActivePage(IEditorPart activePage) {
        this.updateSelectableActions(this.selectionProvider.getSelection());
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.actionSupport.updateActions(selection);
            this.actionGroup.getNewTaskFromSelectionAction().selectionChanged(selection);
        }
    }

    private class EditorPageCallback
    extends WorkbenchActionSupport.WorkbenchActionCallback {
        private EditorPageCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public boolean canPerformAction(String actionId, Control control) {
            WorkbenchActionSupport.WorkbenchActionCallback callback;
            IFormPage activePage = TaskEditorActionContributor.this.getActivePage();
            IFormPage iFormPage = activePage;
            if (iFormPage instanceof AbstractTaskEditorPage) {
                void page;
                AbstractTaskEditorPage abstractTaskEditorPage = (AbstractTaskEditorPage)iFormPage;
                AbstractTaskEditorPage cfr_ignored_0 = (AbstractTaskEditorPage)iFormPage;
                return page.canPerformAction(actionId);
            }
            if (activePage != null && (callback = (WorkbenchActionSupport.WorkbenchActionCallback)activePage.getAdapter(WorkbenchActionSupport.WorkbenchActionCallback.class)) != null) {
                return callback.canPerformAction(actionId, control);
            }
            return super.canPerformAction(actionId, control);
        }

        /*
         * WARNING - void declaration
         */
        public void doAction(String actionId, Control control) {
            WorkbenchActionSupport.WorkbenchActionCallback callback;
            IFormPage activePage = TaskEditorActionContributor.this.getActivePage();
            IFormPage iFormPage = activePage;
            if (iFormPage instanceof AbstractTaskEditorPage) {
                void page;
                AbstractTaskEditorPage abstractTaskEditorPage = (AbstractTaskEditorPage)iFormPage;
                AbstractTaskEditorPage cfr_ignored_0 = (AbstractTaskEditorPage)iFormPage;
                page.doAction(actionId);
                return;
            }
            if (activePage != null && (callback = (WorkbenchActionSupport.WorkbenchActionCallback)activePage.getAdapter(WorkbenchActionSupport.WorkbenchActionCallback.class)) != null) {
                callback.doAction(actionId, control);
                return;
            }
            super.doAction(actionId, control);
        }

        public Control getFocusControl() {
            IFormPage page = TaskEditorActionContributor.this.getActivePage();
            return page != null ? EditorUtil.getFocusControl(page) : null;
        }

        public ISelection getSelection() {
            return TaskEditorActionContributor.this.selectionProvider.getSelection();
        }
    }

    private final class SelectionProviderAdapterExtension
    extends SelectionProviderAdapter
    implements ISelectionChangedListener {
        private SelectionProviderAdapterExtension() {
        }

        public ISelection getSelection() {
            if (TaskEditorActionContributor.this.editor != null && TaskEditorActionContributor.this.editor.getSite().getSelectionProvider() != null) {
                return TaskEditorActionContributor.this.editor.getSite().getSelectionProvider().getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            super.selectionChanged(event);
        }
    }
}

