/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.view.BuildModelContentAdapter;
import org.eclipse.mylyn.internal.builds.ui.view.Messages;

public class BuildContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object input;
    private BuildModel model;
    private final Adapter modelListener = new BuildModelContentAdapter(){

        @Override
        protected void doNotifyChanged(Notification msg) {
            BuildContentProvider.this.refresh();
        }

        @Override
        protected boolean observing(Notifier notifier) {
            return notifier instanceof IBuildServer || notifier instanceof IBuildModel;
        }
    };
    private boolean nestPlansEnabled;
    private Presentation presentation;
    private boolean selectedOnly;
    private Viewer viewer;

    public BuildContentProvider() {
        this.setNestPlansEnabled(true);
        this.setPresentation(Presentation.BY_SERVER);
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IBuildServer) {
            return this.getPlans(parentElement, this.model.getPlans((IBuildServer)parentElement)).toArray();
        }
        if (parentElement instanceof IBuildPlan) {
            return this.getPlans(parentElement, ((IBuildPlan)parentElement).getChildren()).toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IBuildServer) {
            return this.getPlans(inputElement, this.model.getPlans((IBuildServer)inputElement)).toArray();
        }
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        IBuildModel model = this.getModel(inputElement);
        if (model != null) {
            return switch (this.presentation) {
                case Presentation.BY_SERVER -> model.getServers().toArray();
                case Presentation.BY_PLAN -> model.getPlans().toArray();
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return EMPTY_ARRAY;
    }

    private IBuildModel getModel(Object inputElement) {
        if (inputElement instanceof IBuildModel) {
            return (IBuildModel)inputElement;
        }
        if (inputElement == this.input) {
            return this.model;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getParent(Object element) {
        if (element instanceof IBuildServer) {
            return this.input;
        }
        Object object = element;
        if (object instanceof IBuildPlan) {
            void plan;
            IBuildPlan iBuildPlan = (IBuildPlan)object;
            IBuildPlan cfr_ignored_0 = (IBuildPlan)object;
            if (plan.getParent() != null) {
                return plan.getParent();
            }
            return plan.getServer();
        }
        return null;
    }

    private List<IBuildPlan> getPlans(Object parent, List<IBuildPlan> plans) {
        ArrayList<IBuildPlan> children = new ArrayList<IBuildPlan>(plans.size());
        for (IBuildPlan plan : plans) {
            if (this.isSelectedOnly() && !plan.isSelected() || this.isNestPlansEnabled() && plan.getParent() != null && plan.getParent() != parent) continue;
            children.add(plan);
        }
        return children;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.model != null) {
            this.model.eAdapters().remove((Object)this.modelListener);
        }
        this.model = newInput instanceof BuildModel ? (BuildModel)newInput : BuildsUiInternal.getModel();
        this.model.eAdapters().add((Object)this.modelListener);
        this.input = newInput;
    }

    public final boolean isNestPlansEnabled() {
        return this.nestPlansEnabled;
    }

    public final boolean isSelectedOnly() {
        return this.selectedOnly;
    }

    public final void setNestPlansEnabled(boolean nestPlansEnabled) {
        this.nestPlansEnabled = nestPlansEnabled;
    }

    public void setPresentation(Presentation presentation) {
        Assert.isNotNull((Object)((Object)presentation));
        this.presentation = presentation;
        this.refresh();
    }

    public final void setSelectedOnly(boolean selectedOnly) {
        this.selectedOnly = selectedOnly;
    }

    protected void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public static enum Presentation {
        BY_SERVER,
        BY_PLAN;


        public String toString() {
            return switch (this) {
                case BY_SERVER -> Messages.BuildContentProvider_servers;
                case BY_PLAN -> Messages.BuildContentProvider_plans;
                default -> throw new IllegalStateException();
            };
        }
    }
}

