/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.builds.core.IChange;
import org.eclipse.mylyn.builds.core.IChangeArtifact;
import org.eclipse.mylyn.builds.core.IUser;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class ChangesLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    final StyledString.Styler NO_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };
    private final CommonImageManger imageManager = new CommonImageManger();

    public void dispose() {
        this.imageManager.dispose();
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    public Image getImage(Object element) {
        if (element instanceof IChange) {
            return CommonImages.getImage((ImageDescriptor)BuildImages.CHANGE_SET);
        }
        Object object = element;
        if (object instanceof IChangeArtifact) {
            void changeArtifact;
            IChangeArtifact iChangeArtifact = (IChangeArtifact)object;
            IChangeArtifact cfr_ignored_0 = (IChangeArtifact)object;
            return this.imageManager.getFileImage(changeArtifact.getFile());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text != null) {
            StyledString styledString = new StyledString(text);
            if (element instanceof IChange) {
                IUser author = ((IChange)element).getAuthor();
                if (author != null && author.getId() != null) {
                    styledString.append("  " + author.getId(), StyledString.DECORATIONS_STYLER);
                }
            } else {
                Object object = element;
                if (object instanceof IChangeArtifact) {
                    void artifact;
                    IChangeArtifact author = (IChangeArtifact)object;
                    IChangeArtifact cfr_ignored_0 = (IChangeArtifact)object;
                    StringBuilder sb = new StringBuilder();
                    if (artifact.getRevision() != null) {
                        sb.append("  " + artifact.getRevision());
                    }
                    styledString.append(sb.toString(), StyledString.DECORATIONS_STYLER);
                }
            }
            return styledString;
        }
        return new StyledString();
    }

    public String getText(Object element) {
        if (element instanceof IChange) {
            return this.trim(((IChange)element).getMessage());
        }
        if (element instanceof IChangeArtifact) {
            return ((IChangeArtifact)element).getFile();
        }
        return super.getText(element);
    }

    private String trim(String message) {
        if (message == null) {
            return null;
        }
        int i = message.indexOf("\n");
        if (i != -1) {
            return message.substring(0, i);
        }
        return message;
    }
}

