/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.registry;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.infra.common.core.internal.extensions.AbstractRegistry;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.ui.internal.registry.DiscovererUI;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class DiscovererUIRegistry
extends AbstractRegistry {
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.infra.discovery.ui";
    private static final String EXTENSION_POINT_NAME = "discoverer";
    private static final String DISCOVERER_ELEMENT = "discoverer";
    private static final String ID_ATTRIBUTE = "discovererID";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String ICON_ATTRIBUTE = "icon";
    private static DiscovererUIRegistry instance = null;
    private final Map<String, DiscovererUI> discovererUI = new HashMap<String, DiscovererUI>();

    public static DiscovererUIRegistry getInstance() {
        if (instance == null) {
            instance = new DiscovererUIRegistry();
        }
        return instance;
    }

    public DiscovererUIRegistry() {
        this.initialize();
    }

    public DiscovererUI getDiscovererUI(String name) {
        return this.discovererUI.get(name);
    }

    public String getExtensionPointName() {
        return "discoverer";
    }

    public String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase("discoverer")) {
            this.readDiscovererElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readDiscovererElement(IConfigurationElement configurationElement) {
        String discovererLabel;
        String discovererID = configurationElement.getAttribute(ID_ATTRIBUTE);
        if (discovererID == null) {
            this.logMissingAttribute(configurationElement, ID_ATTRIBUTE);
            return;
        }
        if (IDiscoveryManager.INSTANCE.getDiscovererDescription(discovererID) == null) {
            this.logError(configurationElement, "attribute discovererID=\"" + discovererID + "\" doesn't refer to an existing discoverer.");
        }
        if ((discovererLabel = configurationElement.getAttribute(LABEL_ATTRIBUTE)) == null) {
            this.logMissingAttribute(configurationElement, LABEL_ATTRIBUTE);
            return;
        }
        String discovererPath = configurationElement.getAttribute(PATH_ATTRIBUTE);
        String discovererIcon = configurationElement.getAttribute(ICON_ATTRIBUTE);
        Image image = null;
        if (discovererIcon != null) {
            Bundle bundle = Platform.getBundle((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier());
            URL url = bundle.getResource(discovererIcon);
            if (url == null) {
                this.logError(configurationElement, "icon attribute does not refer to an existing file");
                return;
            }
            image = ImageDescriptor.createFromURL((URL)url).createImage(false);
            if (image == null) {
                this.logError(configurationElement, "Could not create an image from the icon attribute: " + discovererIcon);
            }
        }
        this.discovererUI.put(discovererID, new DiscovererUI(discovererID, discovererLabel, discovererPath, image));
    }
}

