/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.operations.ChangeFocusOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class FocusTraversalPolicy
extends AbstractPolicy {
    private IViewer viewer;
    private FocusModel focusModel;

    @Override
    protected ITransactionalOperation createOperation() {
        return new ChangeFocusOperation(this.viewer, null);
    }

    protected IContentPart<? extends Node> findInnerMostContentPart(IContentPart<? extends Node> part) {
        ObservableList<IVisualPart<Node>> children = part.getChildrenUnmodifiable();
        block0: while (!children.isEmpty()) {
            int i = children.size() - 1;
            while (i >= 0) {
                IVisualPart child = (IVisualPart)children.get(i);
                if (child instanceof IContentPart) {
                    part = (IContentPart)child;
                    children = part.getChildrenUnmodifiable();
                    continue block0;
                }
                --i;
            }
        }
        return part;
    }

    protected IContentPart<? extends Node> findNextContentPart(IContentPart<? extends Node> current) {
        ObservableList<IVisualPart<Node>> children = current.getChildrenUnmodifiable();
        if (!children.isEmpty()) {
            for (IVisualPart child : children) {
                if (!(child instanceof IContentPart)) continue;
                return (IContentPart)child;
            }
        }
        IVisualPart<Node> parent = current.getParent();
        while (parent instanceof IContentPart || parent instanceof IRootPart) {
            children = parent instanceof IContentPart ? parent.getChildrenUnmodifiable() : ((IRootPart)parent).getContentPartChildren();
            int index = children.indexOf(current) + 1;
            while (index < children.size()) {
                IVisualPart part = (IVisualPart)children.get(index);
                if (part instanceof IContentPart) {
                    return (IContentPart)part;
                }
                ++index;
            }
            if (parent instanceof IContentPart) {
                current = (IContentPart)parent;
                parent = current.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    protected IContentPart<? extends Node> findPreviousContentPart(IContentPart<? extends Node> current) {
        IVisualPart<Node> parent = current.getParent();
        if (parent instanceof IContentPart || parent instanceof IRootPart) {
            Object children = parent instanceof IContentPart ? parent.getChildrenUnmodifiable() : ((IRootPart)parent).getContentPartChildren();
            int index = children.indexOf(current) - 1;
            while (index >= 0) {
                IVisualPart part = (IVisualPart)children.get(index);
                if (part instanceof IContentPart) {
                    return this.findInnerMostContentPart((IContentPart)part);
                }
                --index;
            }
            if (parent instanceof IContentPart) {
                return (IContentPart)parent;
            }
        }
        return null;
    }

    public IContentPart<? extends Node> focusNext() {
        return this.traverse(false);
    }

    public IContentPart<? extends Node> focusPrevious() {
        return this.traverse(true);
    }

    protected ChangeFocusOperation getChangeFocusOperation() {
        return (ChangeFocusOperation)this.getOperation();
    }

    @Override
    public void init() {
        this.viewer = this.getHost().getRoot().getViewer();
        this.focusModel = (FocusModel)((Object)this.viewer.getAdapter((TypeToken)new TypeToken<FocusModel>(){}));
        super.init();
    }

    protected IContentPart<? extends Node> traverse(boolean backwards) {
        List<IContentPart<Node>> children;
        IContentPart<? extends Node> current = this.focusModel.getFocus();
        IContentPart<Object> next = null;
        if (current == null && (children = this.viewer.getRootPart().getContentPartChildren()) != null && !children.isEmpty()) {
            next = backwards ? this.findInnerMostContentPart(children.get(children.size() - 1)) : children.get(0);
        }
        if (current != null || next != null && !next.isFocusable()) {
            if (next == null) {
                next = current;
            }
            if (backwards) {
                while ((next = this.findPreviousContentPart(next)) != null && !next.isFocusable()) {
                }
            } else {
                while ((next = this.findNextContentPart(next)) != null && !next.isFocusable()) {
                }
            }
        }
        if (next == null || next.isFocusable()) {
            this.getChangeFocusOperation().setNewFocused(next);
        }
        return next;
    }
}

