/**
 */
package org.eclipse.gef.dot.internal.language.fontname.impl;

import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.gef.dot.internal.language.fontname.FontName;
import org.eclipse.gef.dot.internal.language.fontname.FontnameFactory;
import org.eclipse.gef.dot.internal.language.fontname.FontnamePackage;
import org.eclipse.gef.dot.internal.language.fontname.Gravity;
import org.eclipse.gef.dot.internal.language.fontname.GravityOption;
import org.eclipse.gef.dot.internal.language.fontname.PangoFontName;
import org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias;
import org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName;
import org.eclipse.gef.dot.internal.language.fontname.Stretch;
import org.eclipse.gef.dot.internal.language.fontname.StretchOption;
import org.eclipse.gef.dot.internal.language.fontname.Style;
import org.eclipse.gef.dot.internal.language.fontname.StyleOption;
import org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement;
import org.eclipse.gef.dot.internal.language.fontname.Variant;
import org.eclipse.gef.dot.internal.language.fontname.VariantOption;
import org.eclipse.gef.dot.internal.language.fontname.Weight;
import org.eclipse.gef.dot.internal.language.fontname.WeightOption;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class FontnamePackageImpl extends EPackageImpl implements FontnamePackage
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fontNameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass postScriptFontNameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pangoFontNameEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass styleOptionsElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass styleOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass variantOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass weightOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stretchOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass gravityOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum styleEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum variantEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum weightEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum stretchEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum gravityEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType postScriptFontAliasEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType listEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.gef.dot.internal.language.fontname.FontnamePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private FontnamePackageImpl()
	{
		super(eNS_URI, FontnameFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link FontnamePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static FontnamePackage init()
	{
		if (isInited) return (FontnamePackage)EPackage.Registry.INSTANCE.getEPackage(FontnamePackage.eNS_URI);

		// Obtain or create and register package
		Object registeredFontnamePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		FontnamePackageImpl theFontnamePackage = registeredFontnamePackage instanceof FontnamePackageImpl ? (FontnamePackageImpl)registeredFontnamePackage : new FontnamePackageImpl();

		isInited = true;

		// Create package meta-data objects
		theFontnamePackage.createPackageContents();

		// Initialize created meta-data
		theFontnamePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theFontnamePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(FontnamePackage.eNS_URI, theFontnamePackage);
		return theFontnamePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFontName()
	{
		return fontNameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPostScriptFontName()
	{
		return postScriptFontNameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPostScriptFontName_Alias()
	{
		return (EAttribute)postScriptFontNameEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPangoFontName()
	{
		return pangoFontNameEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPangoFontName_StyleOptionsList()
	{
		return (EReference)pangoFontNameEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPangoFontName_Families()
	{
		return (EAttribute)pangoFontNameEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPangoFontName_FinalFamily()
	{
		return (EAttribute)pangoFontNameEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStyleOptionsElement()
	{
		return styleOptionsElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStyleOption()
	{
		return styleOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStyleOption_Style()
	{
		return (EAttribute)styleOptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVariantOption()
	{
		return variantOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVariantOption_Variant()
	{
		return (EAttribute)variantOptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getWeightOption()
	{
		return weightOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getWeightOption_Weight()
	{
		return (EAttribute)weightOptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStretchOption()
	{
		return stretchOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStretchOption_Stretch()
	{
		return (EAttribute)stretchOptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGravityOption()
	{
		return gravityOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getGravityOption_Gravity()
	{
		return (EAttribute)gravityOptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getStyle()
	{
		return styleEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getVariant()
	{
		return variantEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getWeight()
	{
		return weightEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getStretch()
	{
		return stretchEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getGravity()
	{
		return gravityEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getPostScriptFontAlias()
	{
		return postScriptFontAliasEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getList()
	{
		return listEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FontnameFactory getFontnameFactory()
	{
		return (FontnameFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		fontNameEClass = createEClass(FONT_NAME);

		postScriptFontNameEClass = createEClass(POST_SCRIPT_FONT_NAME);
		createEAttribute(postScriptFontNameEClass, POST_SCRIPT_FONT_NAME__ALIAS);

		pangoFontNameEClass = createEClass(PANGO_FONT_NAME);
		createEReference(pangoFontNameEClass, PANGO_FONT_NAME__STYLE_OPTIONS_LIST);
		createEAttribute(pangoFontNameEClass, PANGO_FONT_NAME__FAMILIES);
		createEAttribute(pangoFontNameEClass, PANGO_FONT_NAME__FINAL_FAMILY);

		styleOptionsElementEClass = createEClass(STYLE_OPTIONS_ELEMENT);

		styleOptionEClass = createEClass(STYLE_OPTION);
		createEAttribute(styleOptionEClass, STYLE_OPTION__STYLE);

		variantOptionEClass = createEClass(VARIANT_OPTION);
		createEAttribute(variantOptionEClass, VARIANT_OPTION__VARIANT);

		weightOptionEClass = createEClass(WEIGHT_OPTION);
		createEAttribute(weightOptionEClass, WEIGHT_OPTION__WEIGHT);

		stretchOptionEClass = createEClass(STRETCH_OPTION);
		createEAttribute(stretchOptionEClass, STRETCH_OPTION__STRETCH);

		gravityOptionEClass = createEClass(GRAVITY_OPTION);
		createEAttribute(gravityOptionEClass, GRAVITY_OPTION__GRAVITY);

		// Create enums
		styleEEnum = createEEnum(STYLE);
		variantEEnum = createEEnum(VARIANT);
		weightEEnum = createEEnum(WEIGHT);
		stretchEEnum = createEEnum(STRETCH);
		gravityEEnum = createEEnum(GRAVITY);

		// Create data types
		postScriptFontAliasEDataType = createEDataType(POST_SCRIPT_FONT_ALIAS);
		listEDataType = createEDataType(LIST);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters
		addETypeParameter(listEDataType, "T");

		// Set bounds for type parameters

		// Add supertypes to classes
		postScriptFontNameEClass.getESuperTypes().add(this.getFontName());
		pangoFontNameEClass.getESuperTypes().add(this.getFontName());
		styleOptionEClass.getESuperTypes().add(this.getStyleOptionsElement());
		variantOptionEClass.getESuperTypes().add(this.getStyleOptionsElement());
		weightOptionEClass.getESuperTypes().add(this.getStyleOptionsElement());
		stretchOptionEClass.getESuperTypes().add(this.getStyleOptionsElement());
		gravityOptionEClass.getESuperTypes().add(this.getStyleOptionsElement());

		// Initialize classes and features; add operations and parameters
		initEClass(fontNameEClass, FontName.class, "FontName", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(fontNameEClass, this.getWeight(), "getWeight", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(fontNameEClass, this.getStyle(), "getStyle", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(fontNameEClass, this.getVariant(), "getVariant", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(fontNameEClass, this.getStretch(), "getStretch", 0, 1, IS_UNIQUE, IS_ORDERED);

		addEOperation(fontNameEClass, this.getGravity(), "getGravity", 0, 1, IS_UNIQUE, IS_ORDERED);

		EOperation op = addEOperation(fontNameEClass, null, "getFontFamilies", 0, 1, IS_UNIQUE, IS_ORDERED);
		EGenericType g1 = createEGenericType(this.getList());
		EGenericType g2 = createEGenericType(ecorePackage.getEString());
		g1.getETypeArguments().add(g2);
		initEOperation(op, g1);

		initEClass(postScriptFontNameEClass, PostScriptFontName.class, "PostScriptFontName", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPostScriptFontName_Alias(), this.getPostScriptFontAlias(), "alias", null, 0, 1, PostScriptFontName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pangoFontNameEClass, PangoFontName.class, "PangoFontName", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPangoFontName_StyleOptionsList(), this.getStyleOptionsElement(), null, "styleOptionsList", null, 0, -1, PangoFontName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPangoFontName_Families(), ecorePackage.getEString(), "families", null, 0, -1, PangoFontName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPangoFontName_FinalFamily(), ecorePackage.getEString(), "finalFamily", null, 0, -1, PangoFontName.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(styleOptionsElementEClass, StyleOptionsElement.class, "StyleOptionsElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(styleOptionEClass, StyleOption.class, "StyleOption", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStyleOption_Style(), this.getStyle(), "style", null, 0, 1, StyleOption.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(variantOptionEClass, VariantOption.class, "VariantOption", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVariantOption_Variant(), this.getVariant(), "variant", null, 0, 1, VariantOption.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(weightOptionEClass, WeightOption.class, "WeightOption", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getWeightOption_Weight(), this.getWeight(), "weight", null, 0, 1, WeightOption.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stretchOptionEClass, StretchOption.class, "StretchOption", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStretchOption_Stretch(), this.getStretch(), "stretch", null, 0, 1, StretchOption.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(gravityOptionEClass, GravityOption.class, "GravityOption", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGravityOption_Gravity(), this.getGravity(), "gravity", null, 0, 1, GravityOption.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(styleEEnum, Style.class, "Style");
		addEEnumLiteral(styleEEnum, Style.NORMAL);
		addEEnumLiteral(styleEEnum, Style.OBLIQUE);
		addEEnumLiteral(styleEEnum, Style.ITALIC);

		initEEnum(variantEEnum, Variant.class, "Variant");
		addEEnumLiteral(variantEEnum, Variant.NORMAL);
		addEEnumLiteral(variantEEnum, Variant.SMALL_CAPS);

		initEEnum(weightEEnum, Weight.class, "Weight");
		addEEnumLiteral(weightEEnum, Weight.NORMAL);
		addEEnumLiteral(weightEEnum, Weight.THIN);
		addEEnumLiteral(weightEEnum, Weight.ULTRALIGHT);
		addEEnumLiteral(weightEEnum, Weight.LIGHT);
		addEEnumLiteral(weightEEnum, Weight.SEMILIGHT);
		addEEnumLiteral(weightEEnum, Weight.BOOK);
		addEEnumLiteral(weightEEnum, Weight.MEDIUM);
		addEEnumLiteral(weightEEnum, Weight.SEMIBOLD);
		addEEnumLiteral(weightEEnum, Weight.BOLD);
		addEEnumLiteral(weightEEnum, Weight.ULTRABOLD);
		addEEnumLiteral(weightEEnum, Weight.HEAVY);
		addEEnumLiteral(weightEEnum, Weight.ULTRAHEAVY);

		initEEnum(stretchEEnum, Stretch.class, "Stretch");
		addEEnumLiteral(stretchEEnum, Stretch.NORMAL);
		addEEnumLiteral(stretchEEnum, Stretch.ULTRA_CONDENSED);
		addEEnumLiteral(stretchEEnum, Stretch.EXTRA_CONDENSED);
		addEEnumLiteral(stretchEEnum, Stretch.CONDENSED);
		addEEnumLiteral(stretchEEnum, Stretch.SEMI_CONDENSED);
		addEEnumLiteral(stretchEEnum, Stretch.SEMI_EXPANDED);
		addEEnumLiteral(stretchEEnum, Stretch.EXPANDED);
		addEEnumLiteral(stretchEEnum, Stretch.EXTRA_EXPANDED);
		addEEnumLiteral(stretchEEnum, Stretch.ULTRA_EXPANDED);

		initEEnum(gravityEEnum, Gravity.class, "Gravity");
		addEEnumLiteral(gravityEEnum, Gravity.SOUTH);
		addEEnumLiteral(gravityEEnum, Gravity.NORTH);
		addEEnumLiteral(gravityEEnum, Gravity.EAST);
		addEEnumLiteral(gravityEEnum, Gravity.WEST);

		// Initialize data types
		initEDataType(postScriptFontAliasEDataType, PostScriptFontAlias.class, "PostScriptFontAlias", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(listEDataType, List.class, "List", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //FontnamePackageImpl
