/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr;

import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SearchConditionHelper;

public class CaseSearchWhenContentElement {
    private ValueExpressionCaseSearch sqlCaseSearchWhenClause;
    private ValueExpressionCaseSearchContent content;
    private Predicate searchPred;
    private int clauseNumber;
    private boolean firstClause;
    private Object left;
    private Object right;
    private Object result;
    private String operator = "";
    private String andOr = "";
    private SearchConditionHelper searchConHelper;
    private SQLQueryObject sqlStatement;
    ExpressionHelper eHelper = new ExpressionHelper();

    public CaseSearchWhenContentElement(SQLDomainModel domainModel, SQLQueryObject sqlStmt, ValueExpressionCaseSearch caseSearchClause, ValueExpressionCaseSearchContent content, Predicate predicate, int clauseNumber, boolean firstClause) {
        this.sqlStatement = sqlStmt;
        this.sqlCaseSearchWhenClause = caseSearchClause;
        this.content = content;
        this.searchPred = predicate;
        this.clauseNumber = clauseNumber;
        this.firstClause = firstClause;
        this.searchConHelper = new SearchConditionHelper(domainModel);
    }

    public boolean getFirstClause() {
        return this.firstClause;
    }

    public int getClauseNumber() {
        return this.clauseNumber;
    }

    public Predicate getPredicate() {
        return this.searchPred;
    }

    public ValueExpressionCaseSearch getSQLCaseSearchWhenClause() {
        return this.sqlCaseSearchWhenClause;
    }

    public ValueExpressionCaseSearchContent getSQLCaseSearchWhenContent(int i) {
        return (ValueExpressionCaseSearchContent)this.sqlCaseSearchWhenClause.getSearchContentList().get(i);
    }

    public void setOperator(String op) {
        this.operator = op;
        if (this.searchPred == null) {
            this.createSearchCondition();
        } else {
            this.updateOperator();
        }
    }

    public void setLeftExpression(Object leftObj) {
        this.left = leftObj;
        if (this.searchPred == null) {
            this.createSearchCondition();
        } else {
            this.updateLeft();
        }
    }

    public void setRightExpression(Object rightObj) {
        this.right = rightObj;
        if (this.searchPred == null) {
            this.createSearchCondition();
        } else {
            this.updateRight();
        }
    }

    public void setAndOr(Object andOrObj) {
        this.andOr = (String)andOrObj;
        if (this.searchPred == null) {
            this.createSearchCondition();
        }
        if (this.firstClause) {
            if (this.searchPred.getCombinedRight() == null && this.searchPred.getCombinedLeft() == null) {
                if (this.content.getSearchCondition() == null) {
                    this.searchPred = SearchConditionHelper.buildEmptyPredicate();
                    this.content.setSearchCondition((QuerySearchCondition)this.searchPred);
                } else {
                    QuerySearchCondition newCond = this.searchConHelper.buildSearchCondition(null, this.content.getSearchCondition(), null, null, "");
                    this.content.setSearchCondition(newCond);
                }
                if (this.content.getSearchCondition() instanceof SearchConditionCombined) {
                    SearchConditionCombined scc = (SearchConditionCombined)this.content.getSearchCondition();
                    scc.setCombinedOperator(SearchConditionCombinedOperator.get((String)this.andOr));
                }
            } else {
                this.updateAndOr();
            }
        } else if (this.searchPred.getCombinedRight() == null && this.searchPred.getCombinedLeft() == null) {
            if (this.content.getSearchCondition() == null) {
                this.searchPred = SearchConditionHelper.buildEmptyPredicate();
                this.content.setSearchCondition((QuerySearchCondition)this.searchPred);
            } else {
                QuerySearchCondition newCond = this.searchConHelper.buildSearchCondition(null, this.content.getSearchCondition(), null, null, "");
                this.content.setSearchCondition(newCond);
            }
            if (this.content.getSearchCondition() instanceof SearchConditionCombined) {
                SearchConditionCombined scc = (SearchConditionCombined)this.content.getSearchCondition();
                scc.setCombinedOperator(SearchConditionCombinedOperator.get((String)this.andOr));
            }
        } else {
            this.updateAndOr();
        }
    }

    public void setResultExpression(Object resultObj) {
        this.result = resultObj;
        this.initializeSearchContent();
        if (this.searchPred == null) {
            this.createSearchCondition();
            this.content.setValueExpr((QueryValueExpression)this.result);
        } else {
            this.updateResult();
        }
    }

    private void initializeSearchContent() {
        if (this.content == null) {
            SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
            this.content = factory.createValueExpressionCaseSearchContent();
            this.content.setSearchCondition(null);
            this.content.setValueExpr(null);
            this.sqlCaseSearchWhenClause.getSearchContentList().add((Object)this.content);
        }
    }

    public void createSearchCondition() {
        if (this.searchPred == null) {
            Predicate newPred;
            String rightStr = "";
            this.initializeSearchContent();
            if (this.right != null) {
                if (this.right instanceof QueryValueExpression) {
                    rightStr = ((QueryValueExpression)this.right).getSQL();
                } else if (this.right instanceof String) {
                    rightStr = (String)this.right;
                }
            }
            if ((newPred = this.searchConHelper.buildNewPredicate(this.sqlStatement, (QueryValueExpression)this.left, rightStr, this.operator)) != null) {
                this.searchPred = newPred;
                this.content.setSearchCondition((QuerySearchCondition)newPred);
            }
        }
    }

    protected void updateLeft() {
        if (!(this.left instanceof QueryValueExpression)) {
            QueryValueExpression expr = ExpressionHelper.createExpression(this.left);
            if (expr != null) {
                this.searchConHelper.setLeftInPredicate(this.searchPred, expr);
            }
        } else {
            this.searchConHelper.setLeftInPredicate(this.searchPred, (QueryValueExpression)this.left);
        }
    }

    protected void updateOperator() {
        this.searchConHelper.setOperatorInPredicate(this.sqlStatement, this.content.getSearchCondition(), this.searchPred, this.operator.trim());
        if (!this.isValueNeeded()) {
            this.right = null;
            this.updateRight();
        }
    }

    private boolean isValueNeeded() {
        return !this.operator.equals("IS NULL") && !this.operator.equals("IS NOT NULL");
    }

    protected void updateRight() {
        String newRight = "";
        String orgRight = "";
        QueryValueExpression orgLeft = null;
        QueryValueExpression newLeft = null;
        Predicate newPredicate = null;
        if (this.right instanceof QueryValueExpression) {
            orgRight = ((QueryValueExpression)this.right).getSQL();
        } else if (this.right instanceof String) {
            orgRight = (String)this.right;
        }
        orgLeft = this.left instanceof QueryValueExpression ? (QueryValueExpression)this.left : ExpressionHelper.createExpression(this.left);
        if (this.right != null && (newPredicate = this.searchConHelper.buildNewPredicate(this.sqlStatement, orgLeft, orgRight, this.operator)) == null) {
            newLeft = this.searchConHelper.getDefaultLeft(this.operator);
            newPredicate = this.searchConHelper.buildNewPredicate(this.sqlStatement, newLeft, orgRight, this.operator);
        }
        if (newPredicate == null) {
            newRight = this.searchConHelper.getDefaultRight(this.operator);
            newPredicate = this.searchConHelper.buildNewPredicate(this.sqlStatement, orgLeft, newRight, this.operator);
        }
        if (newPredicate == null) {
            newPredicate = this.searchConHelper.buildNewPredicate(this.sqlStatement, newLeft, newRight, this.operator);
        }
        if (newPredicate != null) {
            QuerySearchCondition newCon = SearchConditionHelper.replacePredicate(this.content.getSearchCondition(), this.searchPred, newPredicate);
            this.content.setSearchCondition(newCon);
            this.searchPred = newPredicate;
        }
    }

    protected void updateAndOr() {
        QuerySearchCondition newCon = this.searchConHelper.setAndOrInSearchCondition(this.sqlStatement, this.content.getSearchCondition(), this.searchPred, this.andOr);
        this.content.setSearchCondition(newCon);
    }

    protected void updateResult() {
        if (!(this.result instanceof QueryValueExpression)) {
            QueryValueExpression expr = ExpressionHelper.createExpression(this.result);
            if (expr != null) {
                this.content.setValueExpr(expr);
            }
        } else {
            this.content.setValueExpr((QueryValueExpression)this.result);
        }
    }

    public Object getLeft() {
        if (this.searchPred != null) {
            return this.searchConHelper.getLeftFromPredicate(this.searchPred);
        }
        return null;
    }

    protected String getOperator() {
        return this.searchConHelper.getPredicateOperator(this.searchPred);
    }

    public Object getRight() {
        if (this.searchPred != null) {
            return this.searchConHelper.getRightFromPredicate(this.searchPred);
        }
        return null;
    }

    protected String getAndOr() {
        String value = "";
        if (this.searchPred.getCombinedLeft() != null) {
            value = this.searchPred.getCombinedLeft().getCombinedOperator().toString();
        } else {
            SearchConditionCombined target;
            SearchConditionCombined scg = this.searchPred.getCombinedRight();
            if (scg != null && (target = scg.getCombinedLeft()) != null) {
                value = target.getCombinedOperator().toString();
            }
        }
        return value;
    }

    public Object getResult() {
        if (this.content != null) {
            return this.content.getValueExpr();
        }
        return null;
    }

    public void deleteSearchCondition() {
        if (this.content != null) {
            this.sqlCaseSearchWhenClause.getSearchContentList().remove((Object)this.content);
            this.content = null;
            if (this.sqlCaseSearchWhenClause.getSearchContentList().size() == 0) {
                this.initializeSearchContent();
            }
        }
    }

    public String getColumnText(int columnIndex) {
        if (columnIndex == 0) {
            if (this.firstClause) {
                return "WHEN";
            }
            return "....";
        }
        if (columnIndex == 1) {
            if (this.searchPred != null) {
                this.left = this.getLeft();
            }
            if (this.left != null) {
                if (this.left instanceof QueryValueExpression) {
                    return ((QueryValueExpression)this.left).getSQL();
                }
                return this.left.toString();
            }
        } else {
            if (columnIndex == 2) {
                if (this.searchPred != null) {
                    this.operator = this.getOperator();
                }
                return this.operator;
            }
            if (columnIndex == 3) {
                if (this.searchPred != null) {
                    this.right = this.getRight();
                }
                if (this.right != null) {
                    if (this.right instanceof QueryValueExpression) {
                        return ((QueryValueExpression)this.right).getSQL();
                    }
                    return this.right.toString();
                }
            } else {
                if (columnIndex == 4) {
                    if (this.searchPred != null) {
                        this.andOr = this.getAndOr();
                    }
                    return this.andOr;
                }
                if (columnIndex == 5) {
                    if (this.searchPred != null) {
                        this.result = this.getResult();
                    }
                    if (this.result != null) {
                        if (this.firstClause) {
                            if (this.result instanceof QueryValueExpression) {
                                return ((QueryValueExpression)this.result).getSQL();
                            }
                            return this.result.toString();
                        }
                        return "....";
                    }
                }
            }
        }
        return "";
    }
}

