/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.reflect.Method;
import java.util.EnumSet;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="5.1")
public enum JRE {
    JAVA_8,
    JAVA_9,
    JAVA_10,
    JAVA_11,
    JAVA_12,
    JAVA_13,
    JAVA_14,
    JAVA_15,
    JAVA_16,
    JAVA_17,
    JAVA_18,
    OTHER;

    private static final Logger logger;
    private static final JRE CURRENT_VERSION;

    private static JRE determineCurrentVersion() {
        String javaVersion = System.getProperty("java.version");
        boolean javaVersionIsBlank = StringUtils.isBlank((String)javaVersion);
        if (javaVersionIsBlank) {
            logger.debug(() -> "JVM system property 'java.version' is undefined. It is therefore not possible to detect Java 8.");
        }
        if (!javaVersionIsBlank && javaVersion.startsWith("1.8")) {
            return JAVA_8;
        }
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object version = ReflectionUtils.invokeMethod((Method)versionMethod, null, (Object[])new Object[0]);
            Method majorMethod = version.getClass().getMethod("major", new Class[0]);
            int major = (Integer)ReflectionUtils.invokeMethod((Method)majorMethod, (Object)version, (Object[])new Object[0]);
            switch (major) {
                case 9: {
                    return JAVA_9;
                }
                case 10: {
                    return JAVA_10;
                }
                case 11: {
                    return JAVA_11;
                }
                case 12: {
                    return JAVA_12;
                }
                case 13: {
                    return JAVA_13;
                }
                case 14: {
                    return JAVA_14;
                }
                case 15: {
                    return JAVA_15;
                }
                case 16: {
                    return JAVA_16;
                }
                case 17: {
                    return JAVA_17;
                }
                case 18: {
                    return JAVA_18;
                }
            }
            return OTHER;
        }
        catch (Exception ex) {
            logger.debug((Throwable)ex, () -> "Failed to determine the current JRE version via java.lang.Runtime.Version.");
            return null;
        }
    }

    public boolean isCurrentVersion() {
        return this == CURRENT_VERSION;
    }

    @API(status=API.Status.STABLE, since="5.7")
    public static JRE currentVersion() {
        return CURRENT_VERSION;
    }

    static boolean isCurrentVersionWithinRange(JRE min, JRE max) {
        return EnumSet.range(min, max).contains((Object)CURRENT_VERSION);
    }

    static {
        logger = LoggerFactory.getLogger(JRE.class);
        CURRENT_VERSION = JRE.determineCurrentVersion();
    }
}

