/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;
import org.eclipse.wst.xml.ui.internal.wizards.NewModelWizard;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLTemplatesWizardPage;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class NewXMLWizard
extends NewModelWizard {
    protected static final int CREATE_FROM_GRAMMAR = 0;
    protected static final int CREATE_FROM_SCRATCH = 1;
    protected static final String[] createFromRadioButtonLabel = new String[]{XMLWizardsMessages._UI_RADIO_XML_FROM_DTD_OR_SCHEMA, XMLWizardsMessages._UI_RADIO_XML_FROM_SCRATCH};
    protected static final String[] filePageFilterExtensions = new String[]{".xml"};
    protected static String[] browseGrammarFilterExtensions = new String[]{".xsd", ".dtd", ".ent", ".mod"};
    protected static final int OPTIONAL_ELEMENT_DEPTH_LIMIT_DEFAULT_VALUE = 2;
    protected static final long XML_EDITOR_FILE_SIZE_LIMIT = 0x1900000L;
    protected NewModelWizard.NewFilePage newFilePage;
    protected NewModelWizard.StartPage startPage;
    private NewModelWizard.StartPage fCreateXMLFromWizardPage;
    protected SelectGrammarFilePage selectGrammarFilePage;
    protected SelectRootElementPage selectRootElementPage;
    protected String cmDocumentErrorMessage;
    protected NewXMLGenerator generator;
    private NewXMLTemplatesWizardPage fNewXMLTemplatesWizardPage;

    public NewXMLWizard() {
        this.setWindowTitle(XMLWizardsMessages._UI_WIZARD_CREATE_NEW_TITLE);
        ImageDescriptor descriptor = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/generatexml_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
        this.generator = new NewXMLGenerator();
    }

    public NewXMLWizard(IFile file, CMDocument cmDocument) {
        this();
        this.generator.setGrammarURI(URIHelper.getPlatformURI((IResource)file));
        this.generator.setCMDocument(cmDocument);
    }

    public static void showDialog(Shell shell, IFile file, IStructuredSelection structuredSelection) {
        String[] errorInfo = new String[2];
        CMDocument cmDocument = NewXMLGenerator.createCMDocument(URIHelper.getPlatformURI((IResource)file), errorInfo);
        if (errorInfo[0] == null) {
            NewXMLWizard wizard = new NewXMLWizard(file, cmDocument);
            wizard.init(PlatformUI.getWorkbench(), structuredSelection);
            wizard.setNeedsProgressMonitor(true);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.getShell().setText(XMLWizardsMessages._UI_DIALOG_NEW_TITLE);
            dialog.setBlockOnOpen(true);
            dialog.open();
        } else {
            MessageDialog.openInformation((Shell)shell, (String)errorInfo[0], (String)errorInfo[1]);
        }
    }

    public void addPages() {
        String grammarURI = this.generator.getGrammarURI();
        this.newFilePage = new NewModelWizard.NewFilePage(this, this.fSelection);
        this.newFilePage.setTitle(XMLWizardsMessages._UI_WIZARD_CREATE_XML_FILE_HEADING);
        this.newFilePage.setDescription(XMLWizardsMessages._UI_WIZARD_CREATE_XML_FILE_EXPL);
        this.newFilePage.defaultName = grammarURI != null ? URIHelper.removeFileExtension((String)URIHelper.getLastSegment((String)grammarURI)) : "NewFile";
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String ext = preference.getString("defaultExtension");
        this.newFilePage.defaultFileExtension = "." + ext;
        this.newFilePage.filterExtensions = filePageFilterExtensions;
        this.addPage((IWizardPage)this.newFilePage);
        if (grammarURI == null) {
            this.fCreateXMLFromWizardPage = new NewModelWizard.StartPage(this, "StartPage", createFromRadioButtonLabel, new String[]{"org.eclipse.wst.sse.ui.preferences.xml.templates"}, XMLWizardsMessages.NewXMLTemplatesWizardPage_6){

                @Override
                public void createControl(Composite parent) {
                    super.createControl(parent);
                }

                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    this.getRadioButtonAtIndex(NewXMLWizard.this.getCreateMode()).setSelection(true);
                    this.getRadioButtonAtIndex(NewXMLWizard.this.getCreateMode()).setFocus();
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.fCreateXMLFromWizardPage.getRadioButtonAtIndex(0), "org.eclipse.wst.xml.ui.xmlc0102");
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewXMLWizard.this.fCreateXMLFromWizardPage.getRadioButtonAtIndex(1), "org.eclipse.wst.xml.ui.xmlc0103");
                }
            };
            this.fCreateXMLFromWizardPage.setTitle(XMLWizardsMessages._UI_WIZARD_CREATE_XML_HEADING);
            this.fCreateXMLFromWizardPage.setDescription(XMLWizardsMessages._UI_WIZARD_CREATE_XML_EXPL);
            this.addPage((IWizardPage)this.fCreateXMLFromWizardPage);
        }
        this.selectGrammarFilePage = new SelectGrammarFilePage();
        this.addPage((IWizardPage)this.selectGrammarFilePage);
        this.selectRootElementPage = new SelectRootElementPage();
        this.selectRootElementPage.setTitle(XMLWizardsMessages._UI_WIZARD_SELECT_ROOT_HEADING);
        this.selectRootElementPage.setDescription(XMLWizardsMessages._UI_WIZARD_SELECT_ROOT_EXPL);
        this.addPage((IWizardPage)this.selectRootElementPage);
        this.fNewXMLTemplatesWizardPage = new NewXMLTemplatesWizardPage();
        this.addPage((IWizardPage)this.fNewXMLTemplatesWizardPage);
    }

    public IWizardPage getStartingPage() {
        Object result = null;
        result = this.startPage != null ? this.startPage : this.newFilePage;
        return result;
    }

    public int getCreateMode() {
        int selectedIndex;
        String grammarURI = this.generator.getGrammarURI();
        int result = 1;
        if (grammarURI != null) {
            result = 0;
        } else if (this.fCreateXMLFromWizardPage != null && (selectedIndex = this.fCreateXMLFromWizardPage.getSelectedRadioButtonIndex()) != -1) {
            result = selectedIndex;
        }
        return result;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        Object nextPage = null;
        if (currentPage == this.startPage) {
            nextPage = this.newFilePage;
        } else if (currentPage == this.newFilePage) {
            nextPage = this.generator.getGrammarURI() == null ? this.fCreateXMLFromWizardPage : this.selectRootElementPage;
        } else if (currentPage == this.fCreateXMLFromWizardPage) {
            int createMode = this.getCreateMode();
            nextPage = createMode == 1 ? this.fNewXMLTemplatesWizardPage : (this.generator.getGrammarURI() == null ? this.selectGrammarFilePage : this.selectRootElementPage);
        } else if (currentPage == this.selectGrammarFilePage) {
            nextPage = this.selectRootElementPage;
        }
        return nextPage;
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.newFilePage && this.generator.getGrammarURI() == null || this.fCreateXMLFromWizardPage != null && this.fCreateXMLFromWizardPage.getSelectedRadioButtonIndex() == 1 || currentPage == this.selectRootElementPage) {
            result = currentPage.isPageComplete();
        }
        return result;
    }

    @Override
    public boolean performFinish() {
        boolean result = super.performFinish();
        this.fNewXMLTemplatesWizardPage.saveLastSavedPreferences();
        String fileName = null;
        try {
            String[] namespaceErrors = this.generator.getNamespaceInfoErrors();
            if (namespaceErrors != null) {
                String title = namespaceErrors[0];
                String message = namespaceErrors[1];
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
            }
            if (result) {
                IFile newFile;
                fileName = this.newFilePage.getFileName();
                if (new Path(fileName).getFileExtension() == null) {
                    this.newFilePage.setFileName(fileName.concat(this.newFilePage.defaultFileExtension));
                }
                if (!(newFile = this.newFilePage.createNewFile()).isLinked()) {
                    final String xmlFileName = newFile.getLocation().toOSString();
                    final String grammarFileName = fileName;
                    if (this.getContainer().getCurrentPage() == this.selectRootElementPage) {
                        int limit = this.selectRootElementPage.getOptionalElementDepthLimit();
                        this.generator.setOptionalElementDepthLimit(limit);
                        this.setNeedsProgressMonitor(true);
                        this.getContainer().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                                progressMonitor.beginTask(XMLWizardsMessages._UI_WIZARD_GENERATING_XML_DOCUMENT, -1);
                                try {
                                    NewXMLWizard.this.generator.createXMLDocument(newFile, xmlFileName);
                                }
                                catch (Exception exception) {
                                    Logger.logException("Exception completing New XML wizard " + grammarFileName, exception);
                                }
                                progressMonitor.done();
                            }
                        });
                    } else {
                        String templateString = this.fNewXMLTemplatesWizardPage.getTemplateString();
                        this.generator.createTemplateXMLDocument(newFile, templateString);
                    }
                    newFile.refreshLocal(1, null);
                }
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                BasicNewResourceWizard.selectAndReveal((IResource)newFile, (IWorkbenchWindow)workbenchWindow);
                this.openEditor(newFile);
            }
        }
        catch (Exception e) {
            Logger.logException("Exception completing New XML wizard " + fileName, e);
        }
        return result;
    }

    public void openEditor(IFile file) {
        long length = 0L;
        IPath location = file.getLocation();
        if (location != null) {
            File localFile = location.toFile();
            length = localFile.length();
        }
        if (length < 0x1900000L) {
            String editorId = null;
            try {
                IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getLocation().toOSString(), file.getContentDescription().getContentType());
                if (editor != null) {
                    editorId = editor.getId();
                }
            }
            catch (CoreException coreException) {
                return;
            }
            IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
                }
            }
            catch (PartInitException partInitException) {
                return;
            }
        }
    }

    protected String getDefaultSystemId() {
        String relativePath = "platform:/resource/" + this.newFilePage.getContainerFullPath().toString() + "/dummy";
        return URIHelper.getRelativeURI((String)this.generator.getGrammarURI(), (String)relativePath);
    }

    public static GridLayout createOptionsPanelLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    public class DTDOptionsPanel
    extends Composite
    implements ModifyListener {
        protected Group group;
        protected Text systemIdField;
        protected Text publicIdField;
        protected SelectRootElementPage parentPage;

        public DTDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.parentPage = parentPage;
            this.setLayoutData(new GridData(768));
            this.setLayout((Layout)NewXMLWizard.createOptionsPanelLayout());
            Group group = new Group((Composite)this, 0);
            group.setText(XMLWizardsMessages._UI_LABEL_DOCTYPE_INFORMATION);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            Label publicIdLabel = new Label((Composite)group, 0);
            publicIdLabel.setText(XMLWizardsMessages._UI_LABEL_PUBLIC_ID);
            this.publicIdField = new Text((Composite)group, 2052);
            this.publicIdField.setLayoutData((Object)new GridData(768));
            this.publicIdField.addModifyListener((ModifyListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.publicIdField, "org.eclipse.wst.xml.ui.xmlc0210");
            Label systemIdLabel = new Label((Composite)group, 0);
            systemIdLabel.setText(XMLWizardsMessages._UI_LABEL_SYSTEM_ID);
            this.systemIdField = new Text((Composite)group, 2052);
            this.systemIdField.setLayoutData((Object)new GridData(768));
            this.systemIdField.addModifyListener((ModifyListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.systemIdField, "org.eclipse.wst.xml.ui.xmlc0220");
        }

        public void update() {
            String thePublicId = null;
            String theSystemId = null;
            ICatalogEntry xmlCatalogEntry = NewXMLWizard.this.generator.getXMLCatalogEntry();
            if (xmlCatalogEntry != null) {
                if (xmlCatalogEntry.getEntryType() == 2) {
                    thePublicId = xmlCatalogEntry.getKey();
                    theSystemId = xmlCatalogEntry.getAttributeValue("webURL");
                    if (theSystemId == null) {
                        theSystemId = NewXMLWizard.this.generator.getGrammarURI().startsWith("http:") ? NewXMLWizard.this.generator.getGrammarURI() : URIHelper.getLastSegment((String)NewXMLWizard.this.generator.getGrammarURI());
                    }
                } else {
                    theSystemId = xmlCatalogEntry.getKey();
                }
            } else {
                theSystemId = NewXMLWizard.this.getDefaultSystemId();
            }
            this.publicIdField.setText(thePublicId != null ? thePublicId : "");
            this.systemIdField.setText(theSystemId != null ? theSystemId : "");
        }

        public void modifyText(ModifyEvent e) {
            NewXMLWizard.this.generator.setSystemId(this.systemIdField.getText());
            NewXMLWizard.this.generator.setPublicId(this.publicIdField.getText());
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return null;
        }
    }

    class SelectGrammarFilePage
    extends WizardPage {
        protected SelectFileOrXMLCatalogIdPanel panel;

        SelectGrammarFilePage() {
            super("SelectGrammarFilePage");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.xmlc0500");
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)composite);
            this.panel = new SelectFileOrXMLCatalogIdPanel(composite);
            this.panel.setLayoutData(new GridData(1808));
            SelectFileOrXMLCatalogIdPanel.Listener listener = new SelectFileOrXMLCatalogIdPanel.Listener(){

                @Override
                public void completionStateChanged() {
                    SelectGrammarFilePage.this.updateErrorMessage();
                }
            };
            this.panel.setListener(listener);
            Dialog.applyDialogFont((Control)parent);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (NewXMLWizard.this.getCreateMode() == 0) {
                    this.setTitle(XMLWizardsMessages._UI_WIZARD_SELECT_GRAMMAR_FILE_TITLE);
                    this.setDescription(XMLWizardsMessages._UI_WIZARD_SELECT_GRAMMAR_FILE_DESC);
                    this.panel.setFilterExtensions(browseGrammarFilterExtensions);
                }
                NewXMLWizard.this.generator.setGrammarURI(null);
                NewXMLWizard.this.generator.setCMDocument(null);
                NewXMLWizard.this.cmDocumentErrorMessage = null;
            }
            this.panel.setVisibleHelper(visible);
        }

        public String getURI() {
            IFile file;
            String uri = this.panel.getXMLCatalogURI();
            if (uri == null && (file = this.panel.getFile()) != null) {
                uri = URIHelper.getPlatformURI((IResource)file);
            }
            return uri;
        }

        public boolean isPageComplete() {
            return this.getURI() != null && this.getErrorMessage() == null;
        }

        public String getXMLCatalogId() {
            return this.panel.getXMLCatalogId();
        }

        public ICatalogEntry getXMLCatalogEntry() {
            return this.panel.getXMLCatalogEntry();
        }

        public String computeErrorMessage() {
            String errorMessage = null;
            String uri = this.getURI();
            if (uri != null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
                errorMessage = XMLWizardsMessages._UI_LABEL_ERROR_CATALOG_ENTRY_INVALID;
            }
            return errorMessage;
        }

        public void updateErrorMessage() {
            String errorMessage = this.computeErrorMessage();
            this.setErrorMessage(errorMessage);
            this.setPageComplete(this.isPageComplete());
        }
    }

    class SelectRootElementPage
    extends WizardPage
    implements SelectionListener {
        protected Combo combo;
        protected Button[] radioButton;
        protected PageBook pageBook;
        protected XSDOptionsPanel xsdOptionsPanel;
        protected DTDOptionsPanel dtdOptionsPanel;
        protected Text limitOptionalElementDepthTextControl;
        protected Button limitOptionalElementDepthCheckButtonControl;

        SelectRootElementPage() {
            super("SelectRootElementPage");
        }

        public void createControl(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)containerGroup, "org.eclipse.wst.xml.ui.xmlc0410");
            containerGroup.setLayout((Layout)new GridLayout());
            containerGroup.setLayoutData((Object)new GridData(768));
            this.setControl((Control)containerGroup);
            Label containerLabel = new Label(containerGroup, 0);
            containerLabel.setText(XMLWizardsMessages._UI_LABEL_ROOT_ELEMENT);
            this.combo = new Combo(containerGroup, 12);
            this.combo.setLayoutData((Object)new GridData(768));
            this.combo.addSelectionListener((SelectionListener)this);
            Group group = new Group(containerGroup, 0);
            group.setText(XMLWizardsMessages._UI_WIZARD_CONTENT_OPTIONS);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.radioButton = new Button[4];
            this.radioButton[0] = new Button((Composite)group, 32);
            this.radioButton[0].setText(XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ATTRIBUTES);
            this.radioButton[0].setLayoutData((Object)new GridData(768));
            this.radioButton[0].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[0], "org.eclipse.wst.xml.ui.xmlc0441");
            this.radioButton[1] = new Button((Composite)group, 32);
            this.radioButton[1].setText(XMLWizardsMessages._UI_WIZARD_CREATE_OPTIONAL_ELEMENTS);
            this.radioButton[1].setLayoutData((Object)new GridData(768));
            this.radioButton[1].setSelection(false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[1], "org.eclipse.wst.xml.ui.xmlc0442");
            this.radioButton[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean enabled = SelectRootElementPage.this.radioButton[1].getSelection();
                    SelectRootElementPage.this.limitOptionalElementDepthCheckButtonControl.setEnabled(enabled);
                    enabled = enabled && SelectRootElementPage.this.limitOptionalElementDepthCheckButtonControl.getSelection();
                    SelectRootElementPage.this.limitOptionalElementDepthTextControl.setEnabled(enabled);
                }
            });
            Composite composite = new Composite((Composite)group, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 2;
            gridLayout.marginLeft = 20;
            composite.setLayout((Layout)gridLayout);
            this.limitOptionalElementDepthCheckButtonControl = new Button(composite, 32);
            this.limitOptionalElementDepthCheckButtonControl.setText(XMLWizardsMessages._UI_WIZARD_LIMIT_OPTIONAL_ELEMENT_DEPTH);
            this.limitOptionalElementDepthCheckButtonControl.setEnabled(false);
            this.limitOptionalElementDepthCheckButtonControl.setSelection(true);
            this.limitOptionalElementDepthCheckButtonControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean enabled = SelectRootElementPage.this.limitOptionalElementDepthCheckButtonControl.getSelection();
                    SelectRootElementPage.this.limitOptionalElementDepthTextControl.setEnabled(enabled);
                }
            });
            this.limitOptionalElementDepthTextControl = new Text(composite, 2048);
            this.limitOptionalElementDepthTextControl.setText(Integer.toString(2));
            this.limitOptionalElementDepthTextControl.setEnabled(false);
            GridData gridaData = new GridData();
            gridaData.widthHint = 25;
            this.limitOptionalElementDepthTextControl.setLayoutData((Object)gridaData);
            this.limitOptionalElementDepthTextControl.addListener(25, new Listener(){

                public void handleEvent(Event event) {
                    String string = event.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if ('0' > chars[i] || chars[i] > '9') {
                            event.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.radioButton[2] = new Button((Composite)group, 32);
            this.radioButton[2].setText(XMLWizardsMessages._UI_WIZARD_CREATE_FIRST_CHOICE);
            this.radioButton[2].setLayoutData((Object)new GridData(768));
            this.radioButton[2].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[2], "org.eclipse.wst.xml.ui.xmlc0443");
            this.radioButton[3] = new Button((Composite)group, 32);
            this.radioButton[3].setText(XMLWizardsMessages._UI_WIZARD_FILL_ELEMENTS_AND_ATTRIBUTES);
            this.radioButton[3].setLayoutData((Object)new GridData(768));
            this.radioButton[3].setSelection(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.radioButton[3], "org.eclipse.wst.xml.ui.xmlc0444");
            this.pageBook = new PageBook(containerGroup, 0);
            this.pageBook.setLayoutData((Object)new GridData(1808));
            this.xsdOptionsPanel = new XSDOptionsPanel(this, (Composite)this.pageBook);
            this.dtdOptionsPanel = new DTDOptionsPanel(this, (Composite)this.pageBook);
            this.pageBook.showPage((Control)this.xsdOptionsPanel);
        }

        public void widgetSelected(SelectionEvent event) {
            int index = this.combo.getSelectionIndex();
            String rootElementName = index != -1 ? this.combo.getItem(index) : null;
            NewXMLWizard.this.generator.setRootElementName(rootElementName);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                try {
                    if (NewXMLWizard.this.generator.getGrammarURI() == null) {
                        NewXMLWizard.this.generator.setGrammarURI(NewXMLWizard.this.selectGrammarFilePage.getURI());
                        NewXMLWizard.this.generator.setXMLCatalogEntry(NewXMLWizard.this.selectGrammarFilePage.getXMLCatalogEntry());
                    }
                    Assert.isNotNull((Object)NewXMLWizard.this.generator.getGrammarURI());
                    if (NewXMLWizard.this.generator.getCMDocument() == null) {
                        final String[] errorInfo = new String[2];
                        final CMDocument[] cmdocs = new CMDocument[1];
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                cmdocs[0] = NewXMLGenerator.createCMDocument(((SelectRootElementPage)SelectRootElementPage.this).NewXMLWizard.this.generator.getGrammarURI(), errorInfo);
                            }
                        };
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
                        NewXMLWizard.this.generator.setCMDocument(cmdocs[0]);
                        NewXMLWizard.this.cmDocumentErrorMessage = errorInfo[1];
                    }
                    this.combo.removeAll();
                    if (NewXMLWizard.this.generator.getCMDocument() != null && NewXMLWizard.this.cmDocumentErrorMessage == null) {
                        CMNamedNodeMap nameNodeMap = NewXMLWizard.this.generator.getCMDocument().getElements();
                        ArrayList<String> nameNodeList = new ArrayList<String>();
                        int i = 0;
                        while (i < nameNodeMap.getLength()) {
                            CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.item(i);
                            Object value = cmElementDeclaration.getProperty("Abstract");
                            if (value != Boolean.TRUE) {
                                nameNodeList.add(cmElementDeclaration.getElementName());
                            }
                            ++i;
                        }
                        String[] nameNodeArray = nameNodeList.toArray(new String[nameNodeList.size()]);
                        if (nameNodeArray.length > 0) {
                            Arrays.sort(nameNodeArray, Collator.getInstance());
                        }
                        String defaultRootName = (String)NewXMLWizard.this.generator.getCMDocument().getProperty("http://org.eclipse.wst/cm/properties/defaultRootName");
                        int defaultRootIndex = -1;
                        int i2 = 0;
                        while (i2 < nameNodeArray.length) {
                            String elementName = nameNodeArray[i2];
                            this.combo.add(elementName);
                            if (defaultRootName != null && defaultRootName.equals(elementName)) {
                                defaultRootIndex = i2;
                            }
                            ++i2;
                        }
                        if (nameNodeArray.length > 0) {
                            defaultRootIndex = defaultRootIndex != -1 ? defaultRootIndex : 0;
                            this.combo.select(defaultRootIndex);
                            NewXMLWizard.this.generator.setRootElementName(this.combo.getItem(defaultRootIndex));
                        }
                    }
                    if (NewXMLWizard.this.generator.getGrammarURI().endsWith("xsd")) {
                        this.pageBook.showPage((Control)this.xsdOptionsPanel);
                        NewXMLWizard.this.generator.setDefaultSystemId(NewXMLWizard.this.getDefaultSystemId());
                        NewXMLWizard.this.generator.createNamespaceInfoList();
                        int i = 0;
                        while (i < NewXMLWizard.this.generator.namespaceInfoList.size()) {
                            NamespaceInfo nsinfo = NewXMLWizard.this.generator.namespaceInfoList.get(i);
                            if ((nsinfo.prefix == null || nsinfo.prefix.trim().length() == 0) && nsinfo.uri != null && nsinfo.uri.trim().length() != 0) {
                                nsinfo.prefix = this.getDefaultPrefix(NewXMLWizard.this.generator.namespaceInfoList);
                            }
                            ++i;
                        }
                        this.xsdOptionsPanel.setNamespaceInfoList(NewXMLWizard.this.generator.namespaceInfoList);
                    } else if (NewXMLWizard.this.generator.getGrammarURI().endsWith("dtd")) {
                        this.pageBook.showPage((Control)this.dtdOptionsPanel);
                        this.dtdOptionsPanel.update();
                    }
                }
                catch (Exception exception) {}
                this.updateErrorMessage();
            }
        }

        private String getDefaultPrefix(List<NamespaceInfo> nsInfoList) {
            String defaultPrefix = "p";
            if (nsInfoList == null) {
                return defaultPrefix;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < nsInfoList.size()) {
                NamespaceInfo nsinfo = nsInfoList.get(i);
                if (nsinfo.prefix != null) {
                    v.addElement(nsinfo.prefix);
                }
                ++i;
            }
            if (v.contains(defaultPrefix)) {
                String s = defaultPrefix;
                int j = 0;
                while (v.contains(s)) {
                    s = String.valueOf(defaultPrefix) + Integer.toString(j);
                    ++j;
                }
                return s;
            }
            return defaultPrefix;
        }

        public int getOptionalElementDepthLimit() {
            int depth = -1;
            if (this.radioButton[1].getSelection() && this.limitOptionalElementDepthCheckButtonControl.getSelection()) {
                try {
                    depth = Integer.parseInt(this.limitOptionalElementDepthTextControl.getText());
                }
                catch (Exception exception) {}
            }
            return depth;
        }

        public boolean isPageComplete() {
            boolean complete;
            boolean bl = complete = NewXMLWizard.this.generator.getRootElementName() != null && NewXMLWizard.this.generator.getRootElementName().length() > 0 && this.getErrorMessage() == null;
            if (complete) {
                int buildPolicy = 0;
                if (this.radioButton[0].getSelection()) {
                    buildPolicy |= 1;
                }
                if (this.radioButton[1].getSelection()) {
                    buildPolicy |= 2;
                }
                if (this.radioButton[2].getSelection()) {
                    buildPolicy = buildPolicy | 4 | 0x10;
                }
                if (this.radioButton[3].getSelection()) {
                    buildPolicy |= 8;
                }
                NewXMLWizard.this.generator.setBuildPolicy(buildPolicy);
            }
            return complete;
        }

        public String computeErrorMessage() {
            String errorMessage = null;
            if (NewXMLWizard.this.cmDocumentErrorMessage != null) {
                errorMessage = NewXMLWizard.this.cmDocumentErrorMessage;
            } else if (NewXMLWizard.this.generator.getRootElementName() == null || NewXMLWizard.this.generator.getRootElementName().length() == 0) {
                errorMessage = XMLWizardsMessages._ERROR_ROOT_ELEMENT_MUST_BE_SPECIFIED;
            }
            return errorMessage;
        }

        public void updateErrorMessage() {
            String errorMessage = this.computeErrorMessage();
            if (errorMessage == null) {
                if (this.xsdOptionsPanel.isVisible()) {
                    errorMessage = this.xsdOptionsPanel.computeErrorMessage();
                } else if (this.dtdOptionsPanel.isVisible()) {
                    errorMessage = this.dtdOptionsPanel.computeErrorMessage();
                }
            }
            this.setErrorMessage(errorMessage);
            this.setPageComplete(this.isPageComplete());
        }
    }

    class XSDOptionsPanel
    extends Composite {
        protected String errorMessage;
        protected SelectRootElementPage parentPage;
        protected CommonEditNamespacesDialog editNamespaces;
        private IPath currentPath;

        public XSDOptionsPanel(SelectRootElementPage parentPage, Composite parent) {
            super(parent, 0);
            this.errorMessage = null;
            this.currentPath = null;
            this.parentPage = parentPage;
            this.setLayout((Layout)NewXMLWizard.createOptionsPanelLayout());
            this.setLayoutData(new GridData(1808));
        }

        private CommonEditNamespacesDialog getEditNamespaces() {
            if (this.editNamespaces == null) {
                Composite co = new Composite((Composite)this, 0);
                co.setLayout((Layout)new GridLayout());
                String tableTitle = XMLWizardsMessages._UI_LABEL_NAMESPACE_INFORMATION;
                this.editNamespaces = new CommonEditNamespacesDialog(co, null, tableTitle, true, true);
                this.layout();
            }
            return this.editNamespaces;
        }

        public void setNamespaceInfoList(List list) {
            IPath newPath;
            CommonEditNamespacesDialog editDialog = this.getEditNamespaces();
            if (NewXMLWizard.this.newFilePage != null && (newPath = NewXMLWizard.this.newFilePage.getContainerFullPath()) != null && !newPath.equals((Object)this.currentPath)) {
                String resourceURI = "platform:/resource" + newPath.toString() + "/dummy";
                String resolvedPath = URIHelper.normalize((String)resourceURI, null, null);
                resolvedPath = URIHelper.removeProtocol((String)resolvedPath);
                this.currentPath = new Path(resolvedPath);
                editDialog.setResourcePath(this.currentPath);
            }
            editDialog.setNamespaceInfoList(list);
            editDialog.updateErrorMessage(list);
        }

        public void updateErrorMessage(List namespaceInfoList) {
            NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
            this.errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
            this.parentPage.updateErrorMessage();
        }

        public String computeErrorMessage() {
            return this.errorMessage;
        }
    }
}

