/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.internal.rhino.RhinoDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.LocationImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.MirrorImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;

public class ScriptReferenceImpl
extends MirrorImpl
implements ScriptReference {
    private final Long scriptId;
    private String sourcePath = null;
    private URI sourceuri = null;
    private final String source;
    private final Boolean generated;
    private final List lineLocations = new ArrayList();
    private final List functionLocations = new ArrayList();
    private Map sourceProperties = null;

    public ScriptReferenceImpl(VirtualMachineImpl vm, Map jsonScript) {
        super(vm);
        this.scriptId = ((Number)jsonScript.get("scriptId")).longValue();
        this.sourcePath = (String)jsonScript.get("location");
        this.sourceProperties = (Map)jsonScript.get("properties");
        this.source = (String)jsonScript.get("source");
        this.generated = (Boolean)jsonScript.get("generated");
        List lines = (List)jsonScript.get("lines");
        for (Number lineNumber : lines) {
            LocationImpl location = new LocationImpl(vm, null, lineNumber.intValue(), this);
            this.lineLocations.add(location);
        }
        List functions = (List)jsonScript.get("functions");
        for (String functionName : functions) {
            LocationImpl location = new LocationImpl(vm, functionName, 0, this);
            this.functionLocations.add(location);
        }
    }

    public List allFunctionLocations() {
        return Collections.unmodifiableList(this.functionLocations);
    }

    public List allLineLocations() {
        return Collections.unmodifiableList(this.lineLocations);
    }

    public Location functionLocation(String functionName) {
        for (Location location : this.functionLocations) {
            if (!location.functionName().equals(functionName)) continue;
            return location;
        }
        return null;
    }

    public Location lineLocation(int lineNumber) {
        for (Location location : this.lineLocations) {
            if (location.lineNumber() != lineNumber) continue;
            return location;
        }
        return null;
    }

    public String source() {
        return this.source;
    }

    public Long getScriptId() {
        return this.scriptId;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public synchronized URI sourceURI() {
        if (this.sourceuri == null) {
            try {
                if (this.sourceProperties != null) {
                    Path path = new Path((String)this.sourceProperties.get("Bundle-SymbolicName"));
                    path = path.append((String)this.sourceProperties.get("path"));
                    path = path.append((String)this.sourceProperties.get("name"));
                    this.sourceuri = URIUtil.fromString((String)path.toString());
                } else if (this.sourcePath != null) {
                    try {
                        this.sourceuri = new URI(this.sourcePath);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.sourceuri = URIUtil.fromString((String)this.sourcePath);
                    }
                } else {
                    this.sourceuri = RhinoDebugPlugin.fileURI((IPath)new Path("script"));
                }
            }
            catch (URISyntaxException urise) {
                RhinoDebugPlugin.log(urise);
            }
        }
        return this.sourceuri;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ScriptReferenceImpl: ");
        buffer.append("[sourceuri - ").append(this.sourceURI()).append("]\n");
        buffer.append("Line locations: \n");
        ArrayList list = new ArrayList(this.allLineLocations());
        Collections.sort(list, LocationImpl.getLocationComparator());
        for (Location loc : list) {
            buffer.append("\t").append(loc.toString()).append("\n");
        }
        buffer.append("Function locations: \n");
        list = new ArrayList(this.allFunctionLocations());
        Collections.sort(list, LocationImpl.getLocationComparator());
        for (Location loc : list) {
            buffer.append("\t").append(loc.toString()).append("\n");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

