/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;

public class JsInspectExpression
extends PlatformObject
implements IErrorReportingExpression,
IDebugEventSetListener {
    private final EvaluateContext evaluateContext;
    private final JsValue value;
    private final String errorMessage;
    private final String expression;

    public JsInspectExpression(EvaluateContext evaluateContext, String expression, JsValue value, String errorMessage) {
        this.evaluateContext = evaluateContext;
        this.expression = expression;
        this.value = value;
        this.errorMessage = errorMessage;
    }

    public String[] getErrorMessages() {
        String[] stringArray;
        if (this.errorMessage == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.errorMessage;
        }
        return stringArray;
    }

    public boolean hasErrors() {
        return this.errorMessage != null;
    }

    public void dispose() {
    }

    public IDebugTarget getDebugTarget() {
        IValue value = this.getValue();
        if (value != null) {
            return value.getDebugTarget();
        }
        return null;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public IValue getValue() {
        return this.value != null ? Value.create((EvaluateContext)this.evaluateContext, (JsValue)this.value, (ExpressionTracker.Node)ExpressionTracker.createExpressionNode((String)this.expression)) : null;
    }

    public ILaunch getLaunch() {
        return this.getValue().getLaunch();
    }

    public String getModelIdentifier() {
        return "org.eclipse.wst.jsdt.chromium.debug";
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 8: {
                    if (!event.getSource().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().getExpressionManager().removeExpression((IExpression)this);
                    break;
                }
                case 2: {
                    IDebugElement source;
                    if (event.getDetail() == 128 || !(event.getSource() instanceof IDebugElement) || !(source = (IDebugElement)event.getSource()).getDebugTarget().equals(this.getDebugTarget())) break;
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 16, 512)});
                }
            }
            ++n2;
        }
    }
}

