/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.draw2d.EventManager;
import org.eclipse.wb.internal.draw2d.RefreshManager;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.draw2d.scroll.HorizontalScrollModel;
import org.eclipse.wb.internal.draw2d.scroll.ScrollModel;
import org.eclipse.wb.internal.draw2d.scroll.VerticalScrollModel;

public class FigureCanvas
extends Canvas {
    private RootFigure m_rootFigure;
    private final Dimension m_rootPreferredSize = new Dimension();
    private ScrollModel m_horizontalModel;
    private ScrollModel m_verticalModel;
    private Image m_bufferedImage;
    private boolean m_drawCached;

    public FigureCanvas(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000);
        this.initScrolling();
        this.hookControlEvents();
        this.createRootFigure();
    }

    private void initScrolling() {
        this.m_horizontalModel = new HorizontalScrollModel(this);
        this.m_verticalModel = new VerticalScrollModel(this);
    }

    private void createRootFigure() {
        this.m_rootFigure = new RootFigure(this, new RefreshManager(this));
        this.m_rootFigure.setBackground(this.getBackground());
        this.m_rootFigure.setForeground(this.getForeground());
        this.m_rootFigure.setFont(this.getFont());
        this.setDefaultEventManager();
    }

    protected void setDefaultEventManager() {
        this.m_rootFigure.setEventManager(new EventManager(this));
    }

    private void disposeBufferedImage() {
        if (this.m_bufferedImage != null) {
            this.m_bufferedImage.dispose();
            this.m_bufferedImage = null;
        }
    }

    public ScrollModel getHorizontalScrollModel() {
        return this.m_horizontalModel;
    }

    public ScrollModel getVerticalScrollModel() {
        return this.m_verticalModel;
    }

    public RootFigure getRootFigure() {
        return this.m_rootFigure;
    }

    public void setDrawCached(boolean value) {
        this.m_drawCached = value;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Dimension size = this.m_rootFigure.getPreferredSize().getUnioned(wHint, hHint);
        return new Point(size.width, size.height);
    }

    private void hookControlEvents() {
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                FigureCanvas.this.disposeBufferedImage();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FigureCanvas.this.handleResize();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                FigureCanvas.this.handlePaint(event.gc, event.x, event.y, event.width, event.height);
            }
        });
    }

    private void handleResize() {
        this.disposeBufferedImage();
        this.configureScrollingAndRedraw();
    }

    private void handlePaint(GC paintGC, int x, int y, int width, int height) {
        if (this.m_drawCached) {
            if (this.m_bufferedImage == null) {
                paintGC.fillRectangle(x, y, width, height);
            } else {
                paintGC.drawImage(this.m_bufferedImage, 0, 0);
            }
            return;
        }
        if (this.m_bufferedImage == null) {
            Point size = this.getSize();
            this.m_bufferedImage = new Image(null, size.x, size.y);
        }
        GC bufferedGC = new GC((Drawable)this.m_bufferedImage);
        try {
            bufferedGC.setClipping(x, y, width, height);
            bufferedGC.setBackground(paintGC.getBackground());
            bufferedGC.setForeground(paintGC.getForeground());
            bufferedGC.setFont(paintGC.getFont());
            bufferedGC.setLineStyle(paintGC.getLineStyle());
            bufferedGC.setLineWidth(paintGC.getLineWidth());
            bufferedGC.setXORMode(paintGC.getXORMode());
            Graphics graphics = new Graphics(bufferedGC);
            graphics.translate(-this.m_horizontalModel.getSelection(), -this.m_verticalModel.getSelection());
            this.m_rootFigure.paint(graphics);
        }
        finally {
            bufferedGC.dispose();
        }
        paintGC.drawImage(this.m_bufferedImage, 0, 0);
    }

    private void configureScrollingAndRedraw() {
        this.m_rootPreferredSize.setSize(this.m_rootFigure.getPreferredSize());
        Rectangle clientArea = this.getClientArea();
        this.m_rootFigure.setBounds(new org.eclipse.wb.draw2d.geometry.Rectangle(clientArea).setLocation(0, 0));
        this.m_horizontalModel.configure(clientArea.width, this.m_rootPreferredSize.width);
        this.m_verticalModel.configure(clientArea.height, this.m_rootPreferredSize.height);
        this.redraw();
    }

    public void handleRefresh(int x, int y, int width, int height) {
        if (this.m_rootPreferredSize.equals(this.m_rootFigure.getPreferredSize())) {
            Point size = this.getSize();
            org.eclipse.wb.draw2d.geometry.Rectangle paintArea = new org.eclipse.wb.draw2d.geometry.Rectangle(0, 0, size.x, size.y);
            paintArea.intersect(new org.eclipse.wb.draw2d.geometry.Rectangle(x, y, width, height));
            this.redraw(paintArea.x, paintArea.y, paintArea.width, paintArea.height, true);
        } else {
            this.configureScrollingAndRedraw();
        }
    }
}

