/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.validation;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationValidator;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IIssueCallback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;

public class ObservableValuePatternValidator
extends PatternAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.addon.databinding.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.viatra.addon.databinding.general";
    public static final String EXPRESSION_MISMATCH_ISSUE_CODE = "org.eclipse.viatra.addon.databinding.expressionmismatch";
    private static final PatternAnnotationParameter NAME_PARAMETER = new PatternAnnotationParameter("name", "string", "The name of the observable value.", false, false);
    private static final PatternAnnotationParameter EXPRESSION_PARAMETER = new PatternAnnotationParameter("expression", "string", "This expression defines the attribute of a pattern parameter for which the IObservableValue will be created.  Only one of the expression and labelExpression properties must be set.", false, false);
    private static final PatternAnnotationParameter LABEL_EXPRESSION_PARAMETER = new PatternAnnotationParameter("labelExpression", "string", "A label expression definition that can contain references to match parameters inside $ symbols. Only one of the expression and labelExpression properties must be set.", false, false);
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public ObservableValuePatternValidator() {
        super("ObservableValue", "Defines observable values for the pattern's parameters; the code generator will create accessors for such values to use in databinding contexts.", new PatternAnnotationParameter[]{NAME_PARAMETER, EXPRESSION_PARAMETER, LABEL_EXPRESSION_PARAMETER});
    }

    public Optional<IPatternAnnotationAdditionalValidator> getAdditionalValidator() {
        return Optional.of(this);
    }

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        String value;
        if (annotation.getParameters().isEmpty()) {
            return;
        }
        Pattern pattern = (Pattern)annotation.eContainer();
        ValueReference ref = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"expression");
        ValueReference labelRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"labelExpression");
        if (ref == null && labelRef == null) {
            validator.error("Specify either the parameter 'expression' or 'labelExpression'", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__PARAMETERS, EXPRESSION_MISMATCH_ISSUE_CODE, new String[0]);
        }
        if (ref != null && labelRef != null) {
            validator.error("Specify only one of the parameter 'expression' or 'labelExpression'", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__PARAMETERS, EXPRESSION_MISMATCH_ISSUE_CODE, new String[0]);
        }
        if (ref instanceof StringValue) {
            value = ((StringValue)ref).getValue();
            if (value.contains("$")) {
                validator.warning("The expressions are not required to be escaped using $ characters.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            }
            this.expressionValidator.validateModelExpression(value, pattern, ref, validator);
        }
        if (labelRef instanceof StringValue) {
            value = ((StringValue)labelRef).getValue();
            if (!value.contains("$")) {
                validator.warning("The label expressions should contain escaped references using $ characters.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, GENERAL_ISSUE_CODE, new String[0]);
            }
            this.expressionValidator.validateStringExpression(value, pattern, labelRef, validator);
        }
    }
}

