/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupable;

public class StepGroupable
implements IStepGroupable {
    private String secondaryId = null;
    private boolean disabled = false;
    private boolean hidden = false;
    private boolean removable = true;
    private boolean singleton = false;
    private boolean savePoint = false;
    private boolean optional = false;
    private final List<String> dependencies = new ArrayList<String>();
    private IExecutableExtension extension;

    public StepGroupable(IExecutableExtension extension) {
        this(extension, null);
    }

    public StepGroupable(IExecutableExtension extension, String secondaryId) {
        this.setExtension(extension);
        this.setSecondaryId(secondaryId);
    }

    @Override
    public IExecutableExtension getExtension() {
        return this.extension;
    }

    public void setExtension(IExecutableExtension extension) {
        Assert.isNotNull((Object)extension);
        this.extension = extension;
    }

    @Override
    public String getSecondaryId() {
        return this.secondaryId;
    }

    public void setSecondaryId(String secondaryId) {
        this.secondaryId = secondaryId;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        Assert.isTrue((!this.disabled ? 1 : 0) != 0);
        this.disabled = disabled;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        Assert.isTrue((!this.hidden ? 1 : 0) != 0);
        this.hidden = hidden;
    }

    @Override
    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        Assert.isTrue((boolean)this.removable);
        this.removable = removable;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        Assert.isTrue((!this.singleton ? 1 : 0) != 0);
        this.singleton = singleton;
    }

    @Override
    public String[] getDependencies() {
        return this.dependencies.toArray(new String[this.dependencies.size()]);
    }

    public void setDependencies(String[] dependencies) {
        Assert.isNotNull((Object)dependencies);
        this.dependencies.clear();
        this.dependencies.addAll(Arrays.asList(dependencies));
    }

    public void setIsSavePoint(boolean isSavePoint) {
        this.savePoint = isSavePoint;
    }

    @Override
    public boolean isSavePoint() {
        return this.savePoint;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" (" + this.getExtension().getLabel() + ")");
        buffer.append(": ");
        buffer.append("id = " + this.getExtension().getId());
        buffer.append(", secondaryId = " + this.getSecondaryId());
        return buffer.toString();
    }
}

