/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.text;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.TextHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.keyboard.KeyboardFactory;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;

public abstract class AbstractText
extends AbstractControl<Text>
implements org.eclipse.reddeer.swt.api.Text {
    private static final Logger log = Logger.getLogger(AbstractText.class);

    protected AbstractText(ReferencedComposite refComposite, int index, Matcher<?> ... matchers) {
        super(Text.class, refComposite, index, matchers);
    }

    protected AbstractText(Text widget) {
        super(widget);
    }

    @Override
    public void setText(String str) {
        log.info("Text set to: " + str);
        TextHandler.getInstance().setText((Text)this.swtWidget, str);
    }

    @Override
    public String getText() {
        String text = TextHandler.getInstance().getText((Text)this.swtWidget);
        return text;
    }

    @Override
    public String getMessage() {
        return TextHandler.getInstance().getMessage((Text)this.swtWidget);
    }

    @Override
    public void setFocus() {
        log.debug("Set focus to Text");
        ControlHandler.getInstance().setFocus((Control)this.swtWidget);
    }

    @Override
    public void typeText(String text) {
        log.info("Type text " + text);
        this.setText("");
        this.setFocus();
        this.forceFocus();
        KeyboardFactory.getKeyboard().type(text);
    }

    private void forceFocus() {
        log.debug("Force focus to receive keyboard events");
        ControlHandler.getInstance().forceFocus((Control)this.swtWidget);
    }

    @Override
    public boolean isReadOnly() {
        return TextHandler.getInstance().isReadOnly((Text)this.swtWidget);
    }
}

