/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.matcher;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.AbstractWidgetWithTextMatcher;
import org.eclipse.reddeer.core.util.TextWidgetUtil;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class WithTooltipTextMatcher
extends AbstractWidgetWithTextMatcher {
    private Matcher<String> matcher;

    public WithTooltipTextMatcher(String text) {
        this((Matcher<String>)new IsEqual((Object)text));
    }

    public WithTooltipTextMatcher(Matcher<String> matcher) {
        if (matcher == null) {
            throw new NullPointerException("matcher is null");
        }
        this.matcher = matcher;
    }

    @Override
    protected String extractWidgetText(Widget widget) {
        try {
            return TextWidgetUtil.getToolTipText(widget);
        }
        catch (CoreLayerException coreLayerException) {
            return null;
        }
    }

    public void describeTo(Description description) {
        description.appendText("with tooltip ").appendDescriptionOf(this.matcher);
    }

    @Override
    protected boolean matches(String text) {
        return this.matcher.matches((Object)text.replaceAll("&", "").split("\t")[0]);
    }

    public String toString() {
        return "Matcher matching widget which tooltip matches: " + this.matcher.toString();
    }
}

