/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.util.Arrays;

public class StateStack
implements Cloneable {
    private byte[] stack;
    private int lastIn = -1;

    public StateStack() {
        this(5);
    }

    public StateStack(int stackSize) {
        this.stack = new byte[stackSize];
        this.lastIn = -1;
    }

    public boolean isEmpty() {
        return this.lastIn == -1;
    }

    public int popStack() {
        byte result = this.stack[this.lastIn];
        --this.lastIn;
        return result;
    }

    public void pushStack(int state) {
        ++this.lastIn;
        if (this.lastIn == this.stack.length) {
            this.multiplySize();
        }
        this.stack[this.lastIn] = (byte)state;
    }

    private void multiplySize() {
        int length = this.stack.length;
        byte[] temp = new byte[length * 2];
        System.arraycopy(this.stack, 0, temp, 0, length);
        this.stack = temp;
    }

    public int clear() {
        this.lastIn = -1;
        return -1;
    }

    public int size() {
        return this.lastIn + 1;
    }

    public StateStack createClone() {
        StateStack rv = new StateStack(this.size());
        rv.copyFrom(this);
        return rv;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.createClone();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.lastIn;
        result = 31 * result + Arrays.hashCode(this.stack);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateStack other = (StateStack)obj;
        if (this.lastIn != other.lastIn) {
            return false;
        }
        return Arrays.equals(this.stack, other.stack);
    }

    public void copyFrom(StateStack s) {
        while (s.lastIn >= this.stack.length) {
            this.multiplySize();
        }
        this.lastIn = s.lastIn;
        int i = 0;
        while (i <= s.lastIn) {
            this.stack[i] = s.stack[i];
            ++i;
        }
    }

    public boolean contains(int state) {
        int i = 0;
        while (i <= this.lastIn) {
            if (this.stack[i] == state) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int get(int index) {
        return this.stack[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        int i = 0;
        while (i <= this.lastIn) {
            sb.append(" stack[" + i + "]= " + this.stack[i]);
            ++i;
        }
        return sb.toString();
    }
}

