/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.composite.registries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.AbstractRegistry;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.ICompositeEditorFactory;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.core.composite.registries.ICompositeEditorFactoriesRegistry;
import org.eclipse.papyrus.emf.facet.widgets.celleditors.internal.Activator;

public class CompositeEditorFactoriesRegistry
extends AbstractRegistry
implements ICompositeEditorFactoriesRegistry,
org.eclipse.papyrus.emf.facet.widgets.celleditors.core.composite.registry.ICompositeEditorFactoriesRegistry {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.papyrus.emf.facet.widgets.celleditors";
    private static final String EXTENSION_POINT_NAME = "compositeEditorFactories";
    private final List<ICompositeEditorFactory<?>> compositeFactories = new ArrayList();

    public CompositeEditorFactoriesRegistry() {
        this.initialize();
    }

    @Override
    public boolean hasCompositeEditorFactory(Class<?> type) {
        return this.getCompositeEditorFactory(type) != null;
    }

    @Override
    public <T> ICompositeEditorFactory<T> getCompositeEditorFactory(Class<T> type) {
        if (this.compositeFactories == null) {
            this.initialize();
        }
        Class objectType = type == Byte.TYPE ? Byte.class : (type == Short.TYPE ? Short.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Float.TYPE ? Float.class : (type == Double.TYPE ? Double.class : (type == Boolean.TYPE ? Boolean.class : (type == Character.TYPE ? Character.class : type)))))));
        Class<Byte> mostPreciseType = null;
        ICompositeEditorFactory<T> mostPreciseFactory = null;
        for (ICompositeEditorFactory<?> factory : this.compositeFactories) {
            Class<Byte> handledType = factory.getHandledType();
            if (handledType == null || !handledType.isAssignableFrom(objectType) || mostPreciseType != null && !mostPreciseType.isAssignableFrom(handledType)) continue;
            mostPreciseType = handledType;
            mostPreciseFactory = this.castMostPreciseFactory(factory);
        }
        return mostPreciseFactory;
    }

    private <T> ICompositeEditorFactory<T> castMostPreciseFactory(ICompositeEditorFactory<?> factory) {
        ICompositeEditorFactory<?> mostPreciseFactory = factory;
        return mostPreciseFactory;
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        try {
            ICompositeEditorFactory factory = (ICompositeEditorFactory)configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
            this.compositeFactories.add(factory);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (String)"A problem occured when instantiating a composite editor factory", (Plugin)Activator.getDefault());
        }
    }
}

