/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public class AnalysisUtils
extends SerializationUtils {
    public static boolean isEqual(@Nullable EClassifier thisEClassifier, @Nullable EClassifier thatEClassifier) {
        if (thisEClassifier == thatEClassifier) {
            return true;
        }
        if (thisEClassifier == null || thatEClassifier == null) {
            return false;
        }
        if (thisEClassifier.eClass() != thatEClassifier.eClass()) {
            return false;
        }
        if (!SerializationUtils.safeEquals((Object)thisEClassifier.getName(), (Object)thatEClassifier.getName())) {
            return false;
        }
        return AnalysisUtils.isEqual(thisEClassifier.getEPackage(), thatEClassifier.getEPackage());
    }

    public static boolean isEqual(@Nullable EPackage thisEPackage, @Nullable EPackage thatEPackage) {
        if (thisEPackage == thatEPackage) {
            return true;
        }
        if (thisEPackage == null || thatEPackage == null) {
            return false;
        }
        if (thisEPackage.eClass() != thatEPackage.eClass()) {
            return false;
        }
        if (!SerializationUtils.safeEquals((Object)thisEPackage.getName(), (Object)thatEPackage.getName())) {
            return false;
        }
        EPackage thisESuperPackage = thisEPackage.getESuperPackage();
        EPackage thatESuperPackage = thatEPackage.getESuperPackage();
        if (thisESuperPackage == null && thatESuperPackage == null) {
            return SerializationUtils.safeEquals((Object)thisEPackage.getNsURI(), (Object)thatEPackage.getNsURI());
        }
        return AnalysisUtils.isEqual(thisESuperPackage, thatESuperPackage);
    }

    public static boolean isEqual(@Nullable EStructuralFeature thisEStructuralFeature, @Nullable EStructuralFeature thatEStructuralFeature) {
        if (thisEStructuralFeature == thatEStructuralFeature) {
            return true;
        }
        if (thisEStructuralFeature == null || thatEStructuralFeature == null) {
            return false;
        }
        if (thisEStructuralFeature.eClass() != thatEStructuralFeature.eClass()) {
            return false;
        }
        if (!SerializationUtils.safeEquals((Object)thisEStructuralFeature.getName(), (Object)thatEStructuralFeature.getName())) {
            return false;
        }
        return AnalysisUtils.isEqual((EClassifier)thisEStructuralFeature.getEContainingClass(), (EClassifier)thatEStructuralFeature.getEContainingClass());
    }

    public static boolean isSuperTypeOf(@Nullable EClass thisEClass, @NonNull EClass thatEClass) {
        if (AnalysisUtils.isEqual((EClassifier)thisEClass, (EClassifier)thatEClass)) {
            return true;
        }
        for (EClass thatSuperEClass : thatEClass.getEAllSuperTypes()) {
            if (!AnalysisUtils.isEqual((EClassifier)thisEClass, (EClassifier)thatSuperEClass)) continue;
            return true;
        }
        return false;
    }
}

