/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot.inspections;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.inspections.Path2GCRootsQuery;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

@CommandName(value="merge_shortest_paths")
@Icon(value="/META-INF/icons/mpaths_from_gc.gif")
@Menu(value={@Menu.Entry(options="-excludes \"\""), @Menu.Entry(options="-excludes java.lang.ref.WeakReference:referent java.lang.ref.Finalizer:referent java.lang.Runtime:<Unfinalized>"), @Menu.Entry(options="-excludes java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.WeakReference:referent java.lang.ref.Finalizer:referent java.lang.Runtime:<Unfinalized> java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent java.lang.ref.WeakReference:referent java.lang.ref.Finalizer:referent java.lang.Runtime:<Unfinalized>"), @Menu.Entry(options="-excludes java.lang.ref.Reference:referent java.lang.Runtime:<Unfinalized>")})
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/merge_shortest_paths.html")
public class MultiplePath2GCRootsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public List<String> excludes = Arrays.asList("java.lang.ref.WeakReference:referent", "java.lang.ref.SoftReference:referent");
    @Argument(isMandatory=false)
    public Grouping groupBy = Grouping.FROM_GC_ROOTS;

    public IResult execute(IProgressListener listener) throws Exception {
        Map<IClass, Set<String>> excludeMap = Path2GCRootsQuery.convert(this.snapshot, this.excludes);
        IMultiplePathsFromGCRootsComputer computer = this.snapshot.getMultiplePathsFromGCRoots(this.objects.getIds(listener), excludeMap);
        Object[] paths = computer.getAllPaths(listener);
        ArrayList<int[]> result = new ArrayList<int[]>(paths.length);
        int ii = 0;
        while (ii < paths.length) {
            result.add((int[])paths[ii]);
            ++ii;
        }
        if (this.groupBy == null) {
            this.groupBy = Grouping.FROM_GC_ROOTS;
        }
        return MultiplePath2GCRootsQuery.create(this.groupBy, this.snapshot, result);
    }

    public static Tree create(ISnapshot snapshot, IMultiplePathsFromGCRootsComputer computer, int[] selection) throws SnapshotException {
        return MultiplePath2GCRootsQuery.create(snapshot, computer, selection, (IProgressListener)new VoidProgressListener());
    }

    public static Tree create(ISnapshot snapshot, IMultiplePathsFromGCRootsComputer computer, int[] selection, IProgressListener listener) throws SnapshotException {
        Object[] paths = computer.getAllPaths(listener);
        ArrayList<int[]> result = new ArrayList<int[]>(paths.length);
        int ii = 0;
        while (ii < paths.length) {
            result.add((int[])paths[ii]);
            ++ii;
        }
        return selection != null ? new TreeByObjectSelected(snapshot, result, selection) : new TreeByObject(snapshot, result, null, null);
    }

    public static Tree create(ISnapshot snapshot, IMultiplePathsFromGCRootsComputer computer, int[] selection, boolean mergeFromRoots, IProgressListener listener) throws SnapshotException {
        Object[] paths = computer.getAllPaths(listener);
        ArrayList<int[]> result = new ArrayList<int[]>(paths.length);
        int ii = 0;
        while (ii < paths.length) {
            result.add((int[])paths[ii]);
            ++ii;
        }
        return selection != null ? new TreeByClassSelected(snapshot, result, selection, mergeFromRoots) : new TreeByClass(snapshot, result, mergeFromRoots, null, null);
    }

    private static Tree create(Grouping groupBy, ISnapshot snapshot, List<int[]> paths) {
        switch (groupBy) {
            case FROM_GC_ROOTS: {
                return new TreeByObject(snapshot, paths, null, null);
            }
            case FROM_GC_ROOTS_BY_CLASS: {
                return new TreeByClass(snapshot, paths, true, null, null);
            }
            case FROM_OBJECTS_BY_CLASS: {
                return new TreeByClass(snapshot, paths, false, null, null);
            }
        }
        return null;
    }

    private static class ClassNode
    extends Node {
        private SetInt distinctObjects;

        private ClassNode(IClass clazz, int level) {
            super(clazz.getObjectId(), level);
            this.label = clazz.getName();
        }

        public SetInt getDistinctObjects(boolean mergeFromRoots) {
            if (this.distinctObjects == null) {
                this.distinctObjects = new SetInt();
                for (int[] path : this.paths) {
                    int index = mergeFromRoots ? path.length - this.level - 1 : this.level;
                    this.distinctObjects.add(path[index]);
                }
            }
            return this.distinctObjects;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    public static enum Grouping {
        FROM_GC_ROOTS(Messages.MultiplePath2GCRootsQuery_Group_FromGCRoots, Icons.getURL("mpaths_from_gc.gif")),
        FROM_GC_ROOTS_BY_CLASS(Messages.MultiplePath2GCRootsQuery_Group_FromGCRootsOnClass, Icons.getURL("mpaths_from_gc_by_class.gif")),
        FROM_OBJECTS_BY_CLASS(Messages.MultiplePath2GCRootsQuery_Group_ToGCRoots, Icons.getURL("mpaths_to_gc_by_class.gif"));

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class Node {
        int objectId;
        int level;
        List<int[]> paths = new ArrayList<int[]>();
        String attribute;
        String label;
        String gcRoots;
        Bytes shallowHeap;
        Bytes refShallowHeap;
        Bytes retainedHeap;
        private static final Bytes UNSET = new Bytes(-1L);

        protected Node(int objectId, int level) {
            this.objectId = objectId;
            this.level = level;
            this.shallowHeap = UNSET;
            this.refShallowHeap = UNSET;
            this.retainedHeap = UNSET;
        }

        int[] getReferencedObjects() {
            int[] result = new int[this.paths.size()];
            int ii = 0;
            for (int[] path : this.paths) {
                result[ii++] = path[0];
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.level;
            result = 31 * result + this.objectId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.level != other.level) {
                return false;
            }
            return this.objectId == other.objectId;
        }
    }

    public static abstract class Tree
    implements IResultTree {
        protected ISnapshot snapshot;
        protected List<int[]> paths;

        protected Tree(ISnapshot snapshot, List<int[]> paths) {
            this.snapshot = snapshot;
            this.paths = paths;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public List<?> getElements() {
            return this.prepare(0, this.paths);
        }

        protected abstract List<Node> prepare(int var1, List<int[]> var2);

        public boolean hasChildren(Object element) {
            return true;
        }

        public List<?> getChildren(Object parent) {
            Node node = (Node)parent;
            return this.prepare(node.level + 1, node.paths);
        }

        public abstract Grouping getGroupedBy();

        public Tree groupBy(Grouping groupBy) {
            if (groupBy == this.getGroupedBy()) {
                return this;
            }
            return MultiplePath2GCRootsQuery.create(groupBy, this.snapshot, this.paths);
        }
    }

    static class TreeByClass
    extends Tree
    implements IIconProvider {
        boolean mergeFromRoots = true;

        private TreeByClass(ISnapshot snapshot, List<int[]> paths, boolean mergeFromRoots) {
            super(snapshot, paths);
            this.mergeFromRoots = mergeFromRoots;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName), new Column(Messages.Column_Objects, Integer.TYPE).noTotals(), new Column(Messages.MultiplePath2GCRootsQuery_ReferencedObjects, Integer.TYPE), new Column(Messages.MultiplePath2GCRootsQuery_Column_RefShallowHeap, Bytes.class).sorting(Column.SortDirection.DESC)};
        }

        @Override
        protected List<Node> prepare(int level, List<int[]> paths) {
            try {
                HashMapIntObject id2node = new HashMapIntObject();
                int ii = 0;
                while (ii < paths.size()) {
                    int[] path = paths.get(ii);
                    if (path.length - level > 0) {
                        int objectId = path[this.mergeFromRoots ? path.length - level - 1 : level];
                        IClass clazz = this.snapshot.getClassOf(objectId);
                        ClassNode n = (ClassNode)id2node.get(clazz.getObjectId());
                        if (n == null) {
                            n = new ClassNode(clazz, level);
                            id2node.put(clazz.getObjectId(), (Object)n);
                        }
                        n.paths.add(path);
                    }
                    ++ii;
                }
                return Arrays.asList((Node[])id2node.getAllValues((Object[])new Node[0]));
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public final Object getColumnValue(Object row, int columnIndex) {
            try {
                ClassNode node = (ClassNode)row;
                switch (columnIndex) {
                    case 0: {
                        return node.label;
                    }
                    case 1: {
                        return node.getDistinctObjects(this.mergeFromRoots).size();
                    }
                    case 2: {
                        return node.paths.size();
                    }
                    case 3: {
                        if (node.refShallowHeap.getValue() == -1L) {
                            node.refShallowHeap = new Bytes(this.snapshot.getHeapSize(node.getReferencedObjects()));
                        }
                        return node.refShallowHeap;
                    }
                }
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }

                public int[] getObjectIds() {
                    return ((ClassNode)row).getDistinctObjects(mergeFromRoots).toArray();
                }

                public String getOQL() {
                    return null;
                }
            };
        }

        public URL getIcon(Object row) {
            Node n = (Node)row;
            if (this.mergeFromRoots) {
                if (!this.hasChildren(row)) {
                    return Icons.CLASS;
                }
                return Icons.CLASS_OUT;
            }
            return n.level == 0 ? Icons.CLASS : Icons.CLASS_IN;
        }

        @Override
        public boolean hasChildren(Object row) {
            Node n = (Node)row;
            for (int[] p : n.paths) {
                if (n.level == p.length - 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public Grouping getGroupedBy() {
            return this.mergeFromRoots ? Grouping.FROM_GC_ROOTS_BY_CLASS : Grouping.FROM_OBJECTS_BY_CLASS;
        }

        @Override
        public ResultMetaData getResultMetaData() {
            ResultMetaData.Builder builder = new ResultMetaData.Builder();
            builder.addContext(new ContextProvider(Messages.Column_Objects){

                public IContextObject getContext(Object row) {
                    return this.getContext(row);
                }

                public URL getIcon() {
                    return mergeFromRoots ? Icons.CLASS_OUT : Icons.CLASS_IN;
                }
            });
            builder.addContext(new ContextProvider(Messages.MultiplePath2GCRootsQuery_ReferencedObjects){

                public IContextObject getContext(final Object row) {
                    return new IContextObjectSet(){

                        public int getObjectId() {
                            return -1;
                        }

                        public int[] getObjectIds() {
                            return ((ClassNode)row).getReferencedObjects();
                        }

                        public String getOQL() {
                            return null;
                        }
                    };
                }

                public URL getIcon() {
                    return Icons.OBJECT_INSTANCE;
                }
            });
            return builder.build();
        }

        /* synthetic */ TreeByClass(ISnapshot iSnapshot, List list, boolean bl, TreeByClass treeByClass, TreeByClass treeByClass2) {
            this(iSnapshot, list, bl);
        }
    }

    static class TreeByClassSelected
    extends TreeByClass
    implements ISelectionProvider {
        int[] selection;

        private TreeByClassSelected(ISnapshot snapshot, List<int[]> paths, int[] selection, boolean mergeFromRoots) {
            super(snapshot, paths, mergeFromRoots);
            this.selection = selection;
        }

        public boolean isExpanded(Object row) {
            Node node = (Node)row;
            if (node.level >= this.selection.length) {
                return false;
            }
            return this.eval(node);
        }

        public boolean isSelected(Object row) {
            Node node = (Node)row;
            for (int[] path : node.paths) {
                if (path.length - 1 != node.level) continue;
                return true;
            }
            return false;
        }

        private boolean eval(Node node) {
            boolean selected = true;
            int[] path = node.paths.get(0);
            int ii = 0;
            while (selected && ii < this.selection.length && ii < node.level) {
                try {
                    selected = this.selection[ii] == this.snapshot.getClassOf(path[path.length - ii - 1]).getObjectId();
                }
                catch (SnapshotException e) {
                    selected = false;
                }
                ++ii;
            }
            return selected;
        }
    }

    static class TreeByObject
    extends Tree
    implements IIconProvider,
    IDecorator {
        private TreeByObject(ISnapshot snapshot, List<int[]> paths) {
            super(snapshot, paths);
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.MultiplePath2GCRootsQuery_ReferencedObjects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Bytes.class), new Column(Messages.MultiplePath2GCRootsQuery_Column_RefShallowHeap, Bytes.class).sorting(Column.SortDirection.DESC), new Column(Messages.Column_RetainedHeap, Bytes.class).noTotals()};
        }

        @Override
        protected List<Node> prepare(int level, List<int[]> paths) {
            HashMapIntObject id2node = new HashMapIntObject();
            int ii = 0;
            while (ii < paths.size()) {
                int[] path = paths.get(ii);
                if (path.length - level > 0) {
                    int objectId = path[path.length - level - 1];
                    Node n = (Node)id2node.get(objectId);
                    if (n == null) {
                        n = new Node(objectId, level);
                        id2node.put(objectId, (Object)n);
                    }
                    n.paths.add(path);
                }
                ++ii;
            }
            return Arrays.asList((Node[])id2node.getAllValues((Object[])new Node[0]));
        }

        public final Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        if (node.label == null) {
                            IObject obj = this.snapshot.getObject(node.objectId);
                            node.label = obj.getDisplayName();
                            node.shallowHeap = new Bytes(obj.getUsedHeapSize());
                        }
                        return node.label;
                    }
                    case 1: {
                        return node.paths.size();
                    }
                    case 2: {
                        if (node.shallowHeap.getValue() == -1L) {
                            node.shallowHeap = new Bytes(this.snapshot.getHeapSize(node.objectId));
                        }
                        return node.shallowHeap;
                    }
                    case 3: {
                        if (node.refShallowHeap.getValue() == -1L) {
                            node.refShallowHeap = new Bytes(this.snapshot.getHeapSize(node.getReferencedObjects()));
                        }
                        return node.refShallowHeap;
                    }
                    case 4: {
                        if (node.retainedHeap.getValue() == -1L) {
                            node.retainedHeap = new Bytes(this.snapshot.getRetainedHeapSize(node.objectId));
                        }
                        return node.retainedHeap;
                    }
                }
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }
            };
        }

        public String prefix(Object row) {
            Node n = (Node)row;
            if (n.level > 0 && n.attribute == null) {
                this.fillInAttribute(n);
            }
            return n.attribute;
        }

        private void fillInAttribute(Node node) {
            try {
                int[] aPath = node.paths.get(0);
                IObject heapObject = this.snapshot.getObject(aPath[aPath.length - node.level]);
                long parentAddress = this.snapshot.mapIdToAddress(node.objectId);
                StringBuilder s = new StringBuilder(64);
                if (heapObject instanceof IObjectArray) {
                    IObjectArray heapArray = (IObjectArray)heapObject;
                    int length = heapArray.getLength();
                    int step = 65536;
                    int maxarray = 0x1400000;
                    int maxattribute = 1024;
                    if (length <= maxarray) {
                        int i = 0;
                        while (i < length) {
                            long[] l = heapArray.getReferenceArray(i, Math.min(step, length - i));
                            int j = 0;
                            while (j < l.length) {
                                if (l[j] == parentAddress) {
                                    if (s.length() > 0) {
                                        s.append(", ");
                                    }
                                    s.append('[');
                                    s.append(i + j);
                                    s.append(']');
                                    if (s.length() > maxattribute) {
                                        s.append(",...");
                                        i = length;
                                        break;
                                    }
                                }
                                ++j;
                            }
                            i += step;
                        }
                    }
                } else {
                    List<NamedReference> refs = heapObject.getOutboundReferences();
                    for (NamedReference reference : refs) {
                        if (reference.getObjectAddress() != parentAddress) continue;
                        if (s.length() > 0) {
                            s.append(", ");
                        }
                        s.append(reference.getName());
                    }
                }
                node.attribute = s.toString();
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public String suffix(Object row) {
            Node node = (Node)row;
            if (node.gcRoots == null && this.snapshot.isGCRoot(node.objectId)) {
                try {
                    node.gcRoots = GCRootInfo.getTypeSetAsString(this.snapshot.getGCRootInfo(node.objectId));
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            return node.gcRoots;
        }

        public URL getIcon(Object row) {
            Node n = (Node)row;
            return this.hasChildren(row) ? Icons.outbound(this.snapshot, n.objectId) : Icons.forObject(this.snapshot, n.objectId);
        }

        @Override
        public boolean hasChildren(Object row) {
            Node n = (Node)row;
            for (int[] p : n.paths) {
                if (p[0] == n.objectId) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResultMetaData getResultMetaData() {
            ResultMetaData.Builder builder = new ResultMetaData.Builder();
            builder.addContext(new ContextProvider(Messages.MultiplePath2GCRootsQuery_PathNodeObject){

                public IContextObject getContext(Object row) {
                    return this.getContext(row);
                }

                public URL getIcon() {
                    return Icons.getURL("heapobjects/out/instance_obj.gif");
                }
            });
            builder.addContext(new ContextProvider(Messages.MultiplePath2GCRootsQuery_ReferencedObjects){

                public IContextObject getContext(final Object row) {
                    return new IContextObjectSet(){

                        public int getObjectId() {
                            return -1;
                        }

                        public int[] getObjectIds() {
                            return ((Node)row).getReferencedObjects();
                        }

                        public String getOQL() {
                            return null;
                        }
                    };
                }

                public URL getIcon() {
                    return Icons.OBJECT_INSTANCE;
                }
            });
            return builder.build();
        }

        @Override
        public Grouping getGroupedBy() {
            return Grouping.FROM_GC_ROOTS;
        }

        /* synthetic */ TreeByObject(ISnapshot iSnapshot, List list, TreeByObject treeByObject, TreeByObject treeByObject2) {
            this(iSnapshot, list);
        }
    }

    static class TreeByObjectSelected
    extends TreeByObject
    implements ISelectionProvider {
        int[] selection;

        private TreeByObjectSelected(ISnapshot snapshot, List<int[]> paths, int[] selection) {
            super(snapshot, paths);
            this.selection = selection;
        }

        public boolean isExpanded(Object row) {
            Node node = (Node)row;
            if (node.level >= this.selection.length) {
                return false;
            }
            return this.eval(node);
        }

        public boolean isSelected(Object row) {
            Node node = (Node)row;
            if (node.level != this.selection.length - 1) {
                return false;
            }
            return this.eval(node);
        }

        private boolean eval(Node node) {
            boolean selected = true;
            int[] path = node.paths.get(0);
            int ii = 0;
            while (selected && ii < this.selection.length && ii < node.level) {
                selected = this.selection[ii] == path[path.length - ii - 1];
                ++ii;
            }
            return selected;
        }
    }
}

