/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.internal.diffmergetool.DiffTools;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.StringUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(name="difftool", common=true, usage="usage_DiffTool")
class DiffTool
extends TextBuiltin {
    private DiffFormatter diffFmt;
    private DiffTools diffTools;
    @Argument(index=0, metaVar="metaVar_treeish")
    private AbstractTreeIterator oldTree;
    @Argument(index=1, metaVar="metaVar_treeish")
    private AbstractTreeIterator newTree;
    @Option(name="--tool", aliases={"-t"}, metaVar="metaVar_tool", usage="usage_ToolForDiff")
    private String toolName;
    @Option(name="--cached", aliases={"--staged"}, usage="usage_cached")
    private boolean cached;
    private BooleanTriState prompt = BooleanTriState.UNSET;
    @Option(name="--tool-help", usage="usage_toolHelp")
    private boolean toolHelp;
    private BooleanTriState gui = BooleanTriState.UNSET;
    private BooleanTriState trustExitCode = BooleanTriState.UNSET;
    @Option(name="--", metaVar="metaVar_paths", handler=PathTreeFilterHandler.class)
    private TreeFilter pathFilter = TreeFilter.ALL;

    DiffTool() {
    }

    @Option(name="--prompt", usage="usage_prompt")
    void setPrompt(boolean on) {
        this.prompt = BooleanTriState.TRUE;
    }

    @Option(name="--no-prompt", aliases={"-y"}, usage="usage_noPrompt")
    void noPrompt(boolean on) {
        this.prompt = BooleanTriState.FALSE;
    }

    @Option(name="--gui", aliases={"-g"}, usage="usage_DiffGuiTool")
    void setGui(boolean on) {
        this.gui = BooleanTriState.TRUE;
    }

    @Option(name="--no-gui", usage="usage_noGui")
    void noGui(boolean on) {
        this.gui = BooleanTriState.FALSE;
    }

    @Option(name="--trust-exit-code", usage="usage_trustExitCode")
    void setTrustExitCode(boolean on) {
        this.trustExitCode = BooleanTriState.TRUE;
    }

    @Option(name="--no-trust-exit-code", usage="usage_noTrustExitCode")
    void noTrustExitCode(boolean on) {
        this.trustExitCode = BooleanTriState.FALSE;
    }

    @Override
    protected void init(Repository repository, String gitDir) {
        super.init(repository, gitDir);
        this.diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(this.outs));
        this.diffTools = new DiffTools(repository);
    }

    @Override
    protected void run() {
        try {
            try {
                if (this.toolHelp) {
                    this.showToolHelp();
                } else {
                    List<DiffEntry> files;
                    boolean showPrompt = this.diffTools.isInteractive();
                    if (this.prompt != BooleanTriState.UNSET) {
                        showPrompt = this.prompt == BooleanTriState.TRUE;
                    }
                    String toolNamePrompt = this.toolName;
                    if (showPrompt && StringUtils.isEmptyOrNull((String)toolNamePrompt)) {
                        toolNamePrompt = this.diffTools.getDefaultToolName(this.gui);
                    }
                    if ((files = this.getFiles()).size() > 0) {
                        this.compare(files, showPrompt, toolNamePrompt);
                    }
                }
                this.outw.flush();
            }
            catch (IOException | RevisionSyntaxException e) {
                throw DiffTool.die(e.getMessage(), e);
            }
        }
        finally {
            this.diffFmt.close();
        }
    }

    private void compare(List<DiffEntry> files, boolean showPrompt, String toolNamePrompt) throws IOException {
        int fileIndex = 0;
        while (fileIndex < files.size()) {
            DiffEntry ent = files.get(fileIndex);
            String mergedFilePath = ent.getNewPath();
            if (mergedFilePath.equals("/dev/null")) {
                mergedFilePath = ent.getOldPath();
            }
            boolean launchCompare = true;
            if (showPrompt) {
                launchCompare = this.isLaunchCompare(fileIndex + 1, files.size(), mergedFilePath, toolNamePrompt);
            }
            if (!launchCompare) break;
            switch (ent.getChangeType()) {
                case MODIFY: {
                    this.outw.println("M\t" + ent.getNewPath() + " (" + ent.getNewId().name() + ")" + "\t" + ent.getOldPath() + " (" + ent.getOldId().name() + ")");
                    int ret = this.diffTools.compare(ent.getNewPath(), ent.getOldPath(), ent.getNewId().name(), ent.getOldId().name(), this.toolName, this.prompt, this.gui, this.trustExitCode);
                    if (ret == 0) break;
                    throw DiffTool.die(MessageFormat.format(CLIText.get().diffToolDied, mergedFilePath));
                }
            }
            ++fileIndex;
        }
    }

    private boolean isLaunchCompare(int fileIndex, int fileCount, String fileName, String toolNamePrompt) throws IOException {
        boolean launchCompare = true;
        this.outw.println(MessageFormat.format(CLIText.get().diffToolLaunch, fileIndex, fileCount, fileName, toolNamePrompt));
        this.outw.flush();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.ins, StandardCharsets.UTF_8));
        String line = null;
        line = br.readLine();
        if (line != null && !line.equalsIgnoreCase("Y")) {
            launchCompare = false;
        }
        return launchCompare;
    }

    private void showToolHelp() throws IOException {
        StringBuilder availableToolNames = new StringBuilder();
        for (String name : this.diffTools.getAvailableTools().keySet()) {
            availableToolNames.append(String.format("\t\t%s\n", name));
        }
        StringBuilder notAvailableToolNames = new StringBuilder();
        for (String name : this.diffTools.getNotAvailableTools().keySet()) {
            notAvailableToolNames.append(String.format("\t\t%s\n", name));
        }
        StringBuilder userToolNames = new StringBuilder();
        Map userTools = this.diffTools.getUserDefinedTools();
        for (String name : userTools.keySet()) {
            userToolNames.append(String.format("\t\t%s.cmd %s\n", name, ((ExternalDiffTool)userTools.get(name)).getCommand()));
        }
        this.outw.println(MessageFormat.format(CLIText.get().diffToolHelpSetToFollowing, availableToolNames, userToolNames, notAvailableToolNames));
    }

    private List<DiffEntry> getFiles() throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException {
        this.diffFmt.setRepository(this.db);
        if (this.cached) {
            if (this.oldTree == null) {
                ObjectId head = this.db.resolve("HEAD^{tree}");
                if (head == null) {
                    DiffTool.die(MessageFormat.format(CLIText.get().notATree, "HEAD"));
                }
                CanonicalTreeParser p = new CanonicalTreeParser();
                Throwable throwable = null;
                Object var4_5 = null;
                try (ObjectReader reader = this.db.newObjectReader();){
                    p.reset(reader, (AnyObjectId)head);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.oldTree = p;
            }
            this.newTree = new DirCacheIterator(this.db.readDirCache());
        } else if (this.oldTree == null) {
            this.oldTree = new DirCacheIterator(this.db.readDirCache());
            this.newTree = new FileTreeIterator(this.db);
        } else if (this.newTree == null) {
            this.newTree = new FileTreeIterator(this.db);
        }
        TextProgressMonitor pm = new TextProgressMonitor((Writer)this.errw);
        pm.setDelayStart(2L, TimeUnit.SECONDS);
        this.diffFmt.setProgressMonitor((ProgressMonitor)pm);
        this.diffFmt.setPathFilter(this.pathFilter);
        List files = this.diffFmt.scan(this.oldTree, this.newTree);
        return files;
    }
}

