/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class ResizableWizard
extends Wizard {
    private final int DEFAULT_WIDTH;
    private final int DEFAULT_HEIGHT;
    private static final String BOUNDS_HEIGHT_KEY = "width";
    private static final String BOUNDS_WIDTH_KEY = "height";
    final String fSectionName;

    public ResizableWizard(String sectionName, IDialogSettings settings) {
        this(sectionName, settings, 300, 400);
    }

    protected ResizableWizard(String sectionName, IDialogSettings settings, int defaultWidth, int defaultHeight) {
        this.DEFAULT_WIDTH = defaultWidth;
        this.DEFAULT_HEIGHT = defaultHeight;
        this.fSectionName = sectionName;
        this.setDialogSettings(settings);
    }

    protected static int open(Shell shell, ResizableWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(wizard.loadSize());
        return dialog.open();
    }

    public void saveSize() {
        Rectangle bounds = this.getContainer().getCurrentPage().getControl().getParent().getClientArea();
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return;
        }
        IDialogSettings section = settings.getSection(this.fSectionName);
        if (section == null) {
            section = settings.addNewSection(this.fSectionName);
        }
        section.put(BOUNDS_WIDTH_KEY, bounds.width);
        section.put(BOUNDS_HEIGHT_KEY, bounds.height);
    }

    public Point loadSize() {
        Point size = new Point(this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT);
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return size;
        }
        IDialogSettings section = settings.getSection(this.fSectionName);
        if (section == null) {
            return size;
        }
        try {
            size.x = section.getInt(BOUNDS_WIDTH_KEY);
            size.y = section.getInt(BOUNDS_HEIGHT_KEY);
        }
        catch (NumberFormatException numberFormatException) {}
        return size;
    }

    public boolean performFinish() {
        this.saveSize();
        return true;
    }
}

