/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class CacheTreeContentsOperation
extends SingleCommandOperation {
    private final IResourceDiffTree tree;

    public CacheTreeContentsOperation(IWorkbenchPart part, ResourceMapping[] mappings, IResourceDiffTree tree) {
        super(part, mappings, Command.NO_LOCAL_OPTIONS);
        this.tree = tree;
    }

    @Override
    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IResource[] files = this.getFilesWithUncachedContents(resources, recurse);
        if (files.length > 0) {
            super.execute(provider, files, recurse, monitor);
        }
    }

    private IResource[] getFilesWithUncachedContents(IResource[] resources, boolean recurse) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff[] nodes;
            IResource resource = iResourceArray[n2];
            IDiff[] iDiffArray = nodes = this.tree.getDiffs(resource, recurse ? 2 : 1);
            int n3 = nodes.length;
            int n4 = 0;
            while (n4 < n3) {
                IDiff node = iDiffArray[n4];
                if (this.needsContents(node)) {
                    result.add(this.tree.getResource(node));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected boolean needsContents(IDiff node) {
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            IResource local = this.getTree().getResource(node);
            IFileRevision remote = this.getRemoteFileState(twd);
            if (remote != null) {
                RemoteFile rf;
                IResourceVariant variant = (IResourceVariant)Adapters.adapt((Object)remote, IResourceVariant.class);
                if (local.getType() == 1 && this.isEnabledForDirection(twd.getDirection()) && variant instanceof RemoteFile && !(rf = (RemoteFile)variant).isContentsCached()) {
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract IFileRevision getRemoteFileState(IThreeWayDiff var1);

    protected abstract boolean isEnabledForDirection(int var1);

    @Override
    protected ICVSFolder getLocalRoot(CVSTeamProvider provider) throws CVSException {
        try {
            ICVSRemoteResource tree = this.buildTree(provider);
            return (ICVSFolder)tree;
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    protected abstract ICVSRemoteResource buildTree(CVSTeamProvider var1) throws TeamException;

    @Override
    protected ICVSResource[] getCVSArguments(Session session, IResource[] resources) {
        ArrayList<ICVSResource> result = new ArrayList<ICVSResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                ICVSResource file = session.getLocalRoot().getChild(resource.getProjectRelativePath().toString());
                result.add(file);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            ++n2;
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    @Override
    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        return Command.UPDATE.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(true), resources, (ICommandOutputListener)new UpdateListener(new IUpdateMessageListener(){

            public void fileInformation(int type, ICVSFolder parent, String filename) {
            }

            public void fileDoesNotExist(ICVSFolder parent, String filename) {
            }

            public void directoryInformation(ICVSFolder commandRoot, String path, boolean newDirectory) {
            }

            public void directoryDoesNotExist(ICVSFolder commandRoot, String path) {
            }
        }), monitor);
    }

    @Override
    protected Command.LocalOption[] getLocalOptions(boolean recurse) {
        return Update.IGNORE_LOCAL_CHANGES.addTo(super.getLocalOptions(recurse));
    }

    @Override
    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.CacheTreeContentsOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.CacheTreeContentsOperation_1;
    }

    protected IResourceDiffTree getTree() {
        return this.tree;
    }

    @Override
    public boolean consultModelsForMappings() {
        return false;
    }

    @Override
    protected boolean isReportableError(IStatus status) {
        return super.isReportableError(status) && status.getSeverity() == 4;
    }
}

