/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.CacheFileImageUpdater;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FileExtBasedImageUpdater;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.ImageUpdateAdapter;

public class LabelProviderUpdateDaemon
extends Thread {
    private static String[][] os_drives = new String[][]{{"windows xp", "xp_rootdrive.png"}, {"windows 7", "win7_rootdrive.png"}, {"windows 8", "win8_rootdrive.png"}};
    private static String root_drive = LabelProviderUpdateDaemon.createRootImage(LabelProviderUpdateDaemon.getOSEntry());
    Component dummyComponent = new JComponent(){
        private static final long serialVersionUID = 5926798769323111209L;
    };
    BlockingQueue<IFSTreeNode> queueNodes;
    ImageUpdateAdapter cacheAdapter;
    ImageUpdateAdapter extAdapter;

    private static int getOSEntry() {
        String osName = System.getProperty("os.name").toLowerCase();
        int i = 0;
        while (i < os_drives.length) {
            if (os_drives[i][0].equals(osName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static String createRootImage(int i) {
        UIPlugin plugin = UIPlugin.getDefault();
        URL url = plugin.getBundle().getEntry("icons/obj16/" + os_drives[i][1]);
        plugin.getImageRegistry().put(os_drives[i][0], ImageDescriptor.createFromURL((URL)url));
        return os_drives[i][0];
    }

    public LabelProviderUpdateDaemon() {
        super("Image Updater Daemon");
        this.setDaemon(true);
        this.queueNodes = new LinkedBlockingQueue<IFSTreeNode>();
        this.cacheAdapter = new CacheFileImageUpdater();
        this.extAdapter = new FileExtBasedImageUpdater(this);
    }

    public void enqueue(final IFSTreeNode node) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                LabelProviderUpdateDaemon.this.queueNodes.put(node);
            }
        });
    }

    private IFSTreeNode take() {
        while (true) {
            try {
                return this.queueNodes.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        while (true) {
            IFSTreeNode node;
            ImageUpdateAdapter adapter;
            String imgKey;
            ImageDescriptor image;
            if ((image = UIPlugin.getImageDescriptor(imgKey = (adapter = this.getUpdateAdapter(node = this.take())).getImageKey(node))) == null) {
                File mrrFile = adapter.getMirrorFile(node);
                File imgFile = adapter.getImageFile(node);
                image = this.createImage(imgKey, mrrFile, imgFile);
            }
            if (image == null) continue;
            this.sendNotification(node, node.getName(), null, image);
        }
    }

    private ImageUpdateAdapter getUpdateAdapter(IFSTreeNode node) {
        File cacheFile = node.getCacheFile();
        if (cacheFile.exists()) {
            return this.cacheAdapter;
        }
        return this.extAdapter;
    }

    public Image getImage(IFSTreeNode node) {
        ImageUpdateAdapter adapter = this.getUpdateAdapter(node);
        String key = adapter.getImageKey(node);
        return UIPlugin.getImage(key);
    }

    private ImageDescriptor createImage(String imgKey, File mrrFile, File imgFile) {
        ImageDescriptor image = UIPlugin.getImageDescriptor(imgKey);
        if (image == null) {
            FileSystemView view;
            Icon icon;
            if (!imgFile.exists() && (icon = (view = FileSystemView.getFileSystemView()).getSystemIcon(mrrFile)) != null) {
                this.createImageFromIcon(icon, imgFile);
            }
            if (imgFile.exists()) {
                try {
                    image = ImageDescriptor.createFromURL((URL)imgFile.toURI().toURL());
                    UIPlugin.getDefault().getImageRegistry().put(imgKey, image);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return image;
    }

    public Image getDiskImage() {
        return UIPlugin.getImage(root_drive);
    }

    public Image getFolderImage() {
        String key = "SWING_FOLDER_IMAGE";
        ImageDescriptor imgDesc = UIPlugin.getImageDescriptor(key);
        if (imgDesc == null) {
            String dir = System.getProperty("work.dir");
            if (dir == null) {
                dir = System.getProperty("java.home");
            }
            File mirror = null;
            mirror = dir != null ? new File(dir) : new File(".");
            File imgFile = this.getTempImg("_directory_");
            this.createImage(key, mirror, imgFile);
        }
        return UIPlugin.getImage(key);
    }

    protected File getTempDir() {
        File cacheRoot = ModelManager.getCacheRoot();
        File tempDir = new File(cacheRoot, ".tmp");
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            tempDir = cacheRoot;
        }
        return tempDir;
    }

    protected File getTempImg(String imgName) {
        File tempDir = this.getTempDir();
        File imgDir = new File(tempDir, ".img");
        if (!imgDir.exists() && !imgDir.mkdirs()) {
            imgDir = tempDir;
        }
        return new File(imgDir, String.valueOf(imgName) + ".png");
    }

    private void createImageFromIcon(Icon icon, File imgFile) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
        Graphics2D g = bi.createGraphics();
        icon.paintIcon(this.dummyComponent, g, 0, 0);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "png", imgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendNotification(IFSTreeNode node, String key, ImageDescriptor oldImg, ImageDescriptor newImg) {
        if (node.getPeerNode() != null) {
            IPropertyChangeProvider viewerInput = (IPropertyChangeProvider)node.getPeerNode().getAdapter(IPropertyChangeProvider.class);
            viewerInput.firePropertyChange(new PropertyChangeEvent(node, key, oldImg, newImg));
        }
    }
}

