/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsProviderRegistry;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsListener;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public enum DebuggerSettingsManager {
    INSTANCE;

    private final OwnersListener ownersListener = new OwnersListener();
    private final ListenerList<IDebuggerSettingsListener> listeners = new ListenerList();
    private final Map<String, IDebuggerSettingsProvider> settingsCache = new HashMap<String, IDebuggerSettingsProvider>();
    private final Map<IDebuggerSettings, IDebuggerSettingsWorkingCopy> settingsCopies = new HashMap<IDebuggerSettings, IDebuggerSettingsWorkingCopy>();

    private DebuggerSettingsManager() {
        for (String debuggerId : PHPDebuggersRegistry.getDebuggersIds()) {
            this.settingsCache.put(debuggerId, DebuggerSettingsProviderRegistry.getProvider(debuggerId));
        }
    }

    public synchronized void startup() {
        ServersManager.addManagerListener((IServersManagerListener)this.ownersListener);
        PHPexes.getInstance().addPHPExesListener(this.ownersListener);
    }

    public synchronized void shutdown() {
        ServersManager.removeManagerListener((IServersManagerListener)this.ownersListener);
        PHPexes.getInstance().removePHPExesListener(this.ownersListener);
        for (IDebuggerSettingsProvider provider : this.settingsCache.values()) {
            if (!(provider instanceof AbstractDebuggerSettingsProvider)) continue;
            ((AbstractDebuggerSettingsProvider)provider).cleanup();
        }
    }

    public IDebuggerSettings findSettings(String ownerId, String debuggerId) {
        IDebuggerSettingsProvider provider = this.settingsCache.get(debuggerId);
        if (provider == null) {
            return null;
        }
        IDebuggerSettings settings = provider.get(ownerId);
        IDebuggerSettingsWorkingCopy pendingCopy = this.findWorkingCopy(settings);
        if (pendingCopy != null) {
            return pendingCopy;
        }
        return settings;
    }

    public List<IDebuggerSettings> findSettings(String debuggerId) {
        IDebuggerSettingsProvider provider = this.settingsCache.get(debuggerId);
        if (provider == null) {
            return new ArrayList<IDebuggerSettings>();
        }
        return provider.getAll();
    }

    public IDebuggerSettingsWorkingCopy fetchWorkingCopy(IDebuggerSettings settings) {
        IDebuggerSettingsWorkingCopy workingCopy = this.settingsCopies.get(settings);
        if (workingCopy == null) {
            IDebuggerSettingsProvider provider = this.settingsCache.get(settings.getDebuggerId());
            workingCopy = provider.createWorkingCopy(settings);
            this.settingsCopies.put(settings, workingCopy);
        }
        return workingCopy;
    }

    public void dropWorkingCopy(IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        for (IDebuggerSettings key : this.settingsCopies.keySet()) {
            if (this.settingsCopies.get(key) != settingsWorkingCopy) continue;
            this.settingsCopies.remove(key);
            break;
        }
    }

    public void addSettingsListener(IDebuggerSettingsListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSettingsListener(IDebuggerSettingsListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void save(IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        PropertyChangeEvent event;
        IDebuggerSettings settings = settingsWorkingCopy.getOriginal();
        Map<String, String> attributes = settings.getAttributes();
        Map<String, String> attributesCopy = settingsWorkingCopy.getAttributes();
        ArrayList<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>();
        for (String key : attributesCopy.keySet()) {
            if (attributes.keySet().contains(key)) continue;
            event = new PropertyChangeEvent((Object)settings, key, null, (Object)attributesCopy.get(key));
            events.add(event);
        }
        for (String key : attributes.keySet()) {
            if (attributes.get(key).equals(attributesCopy.get(key))) continue;
            event = new PropertyChangeEvent((Object)settings, key, (Object)attributes.get(key), (Object)attributesCopy.get(key));
            events.add(event);
        }
        if (events.isEmpty()) {
            return;
        }
        ((AbstractDebuggerSettings)settings).update(settingsWorkingCopy);
        this.save(settings);
        new EventNotifier().fireChanged(events);
    }

    private void save(IDebuggerSettings settings) {
        String debuggerId = settings.getDebuggerId();
        DebuggerSettingsProviderRegistry.getProvider(debuggerId).save(settings);
        new EventNotifier().fireAdded(settings);
    }

    private void delete(IDebuggerSettings settings) {
        String debuggerId = settings.getDebuggerId();
        DebuggerSettingsProviderRegistry.getProvider(debuggerId).delete(settings);
        new EventNotifier().fireRemoved(settings);
    }

    private IDebuggerSettingsWorkingCopy findWorkingCopy(IDebuggerSettings settings) {
        for (IDebuggerSettings key : this.settingsCopies.keySet()) {
            if (key != settings) continue;
            return this.settingsCopies.get(key);
        }
        return null;
    }

    private class EventNotifier {
        private static final int ADDED = 1;
        private static final int REMOVED = 2;
        private static final int CHANGED = 4;
        private PropertyChangeEvent[] events;
        private int kind;
        private IDebuggerSettings settings;

        private EventNotifier() {
        }

        private void fireEvent() {
            switch (this.kind) {
                case 1: {
                    Object[] objectArray = DebuggerSettingsManager.this.listeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        ((IDebuggerSettingsListener)listener).settingsAdded(this.settings);
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    Object[] objectArray = DebuggerSettingsManager.this.listeners.getListeners();
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object listener = objectArray[n3];
                        ((IDebuggerSettingsListener)listener).settingsRemoved(this.settings);
                        ++n3;
                    }
                    break;
                }
                case 4: {
                    Object[] objectArray = DebuggerSettingsManager.this.listeners.getListeners();
                    int n = objectArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Object listener = objectArray[n4];
                        ((IDebuggerSettingsListener)listener).settingsChanged(this.events);
                        ++n4;
                    }
                    break;
                }
            }
        }

        void fireChanged(List<PropertyChangeEvent> events) {
            this.kind = 4;
            this.events = events.toArray(new PropertyChangeEvent[events.size()]);
            this.fireEvent();
        }

        void fireAdded(IDebuggerSettings settings) {
            this.kind = 1;
            this.settings = settings;
            this.fireEvent();
        }

        void fireRemoved(IDebuggerSettings settings) {
            this.kind = 2;
            this.settings = settings;
            this.fireEvent();
        }
    }

    private class OwnersListener
    implements IServersManagerListener,
    IPHPExesListener {
        private OwnersListener() {
        }

        @Override
        public void phpExeAdded(PHPExesEvent event) {
            for (String debuggerId : PHPDebuggersRegistry.getDebuggersIds()) {
                IDebuggerSettings settings = DebuggerSettingsManager.this.findSettings(event.getPHPExeItem().getUniqueId(), debuggerId);
                if (settings == null) continue;
                DebuggerSettingsManager.this.save(settings);
            }
        }

        @Override
        public void phpExeRemoved(PHPExesEvent event) {
            for (String debuggerId : PHPDebuggersRegistry.getDebuggersIds()) {
                IDebuggerSettings settings = DebuggerSettingsManager.this.findSettings(event.getPHPExeItem().getUniqueId(), debuggerId);
                if (settings == null) continue;
                DebuggerSettingsManager.this.delete(settings);
            }
        }

        public void serverAdded(ServerManagerEvent event) {
            for (String debuggerId : PHPDebuggersRegistry.getDebuggersIds()) {
                IDebuggerSettings settings = DebuggerSettingsManager.this.findSettings(event.getServer().getUniqueId(), debuggerId);
                if (settings == null) continue;
                DebuggerSettingsManager.this.save(settings);
            }
        }

        public void serverRemoved(ServerManagerEvent event) {
            for (String debuggerId : PHPDebuggersRegistry.getDebuggersIds()) {
                IDebuggerSettings settings = DebuggerSettingsManager.this.findSettings(event.getServer().getUniqueId(), debuggerId);
                if (settings == null) continue;
                DebuggerSettingsManager.this.delete(settings);
            }
        }

        public void serverModified(ServerManagerEvent event) {
        }
    }
}

