/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.ThrowStatement;
import org.eclipse.php.core.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.corext.ASTNodes;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class MethodExitsFinder
extends AbstractOccurrencesFinder {
    private static final String EXIT_POINT_OF = CoreMessages.getString("MethodExitsFinder.0");
    public static final String ID = "MethodExitsFinder";
    private FunctionDeclaration fFunctionDeclaration;
    private ASTNode fExitPointNode;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.fExitPointNode = node;
        if (this.isExitExecutionPath(node)) {
            this.fFunctionDeclaration = (FunctionDeclaration)ASTNodes.getParent(node, 29);
            if (this.fFunctionDeclaration == null) {
                return "MethodExitsFinder_no_return_type_selected";
            }
            return null;
        }
        this.fDescription = "MethodExitsFinder_occurrence_exit_description";
        return this.fDescription;
    }

    private final boolean isExitExecutionPath(ASTNode node) {
        return node != null && (node.getType() == 50 || node.getType() == 57);
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(EXIT_POINT_OF, this.fFunctionDeclaration.getFunctionName().getName());
        this.fFunctionDeclaration.accept(this);
        int offset = this.fFunctionDeclaration.getEnd() - 1;
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 1, this.getOccurrenceType(null), this.fDescription));
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 7;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(null), this.fDescription));
        return super.visit(node);
    }

    @Override
    public boolean visit(YieldExpression node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(null), this.fDescription));
        return super.visit(node);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(null), this.fDescription));
        return true;
    }

    @Override
    public Program getASTRoot() {
        return this.fASTRoot;
    }

    @Override
    public String getElementName() {
        return this.fFunctionDeclaration.getFunctionName().getName();
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getJobLabel() {
        return "MethodExitsFinder_job_label";
    }

    @Override
    public int getSearchKind() {
        return 7;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return "MethodExitsFinder_label_plural";
    }

    @Override
    public String getUnformattedSingularLabel() {
        return "MethodExitsFinder_label_singular";
    }
}

