/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtresourceprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderClassMap {
    private Map<String, List<Class>> idToClassListMap;
    private Logger log = PDPlugin.getLogger(ProviderClassMap.class);

    public ProviderClassMap() {
        this.idToClassListMap = new HashMap<String, List<Class>>();
    }

    public List<Class> get(String id) {
        List<Class> classList = this.idToClassListMap.get(id);
        if (classList == null) {
            classList = new ArrayList<Class>();
            this.idToClassListMap.put(id, classList);
        }
        return classList;
    }

    public boolean add(String id, Class clazz) {
        List<Class> classList = this.get(id);
        return classList.add(clazz);
    }

    public List<IDTResourceProvider> createInstances(String id) {
        ArrayList<IDTResourceProvider> providers = new ArrayList<IDTResourceProvider>();
        List<Class> classList = this.get(id);
        for (Class providerClass : classList) {
            try {
                Object objProvider = providerClass.newInstance();
                if (objProvider instanceof IDTResourceProvider) {
                    providers.add((IDTResourceProvider)objProvider);
                    continue;
                }
                this.log.error("Warning.ProviderClassMap.NotIDTResourceProvider", providerClass.getName());
            }
            catch (IllegalAccessException iae) {
                this.log.error("Warning.ProviderClassMap.IllegalAccess", providerClass.getName(), id, (Throwable)iae);
            }
            catch (InstantiationException ie) {
                this.log.error("Warning.ProviderClassMap.Instantiation", providerClass.getName(), id, (Throwable)ie);
            }
        }
        return providers;
    }

    public List<IDTResourceProvider> createInstances() {
        ArrayList<IDTResourceProvider> providers = new ArrayList<IDTResourceProvider>();
        Set<String> idSet = this.idToClassListMap.keySet();
        for (String curId : idSet) {
            List<IDTResourceProvider> providersForCurId = this.createInstances(curId);
            providers.addAll(providersForCurId);
        }
        return providers;
    }
}

