/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDUtil;

public class XSDUtils {
    private static List<XSDSimpleTypeDefinition> primitives;
    private static List<XSDTypeDefinition> advancedPrimitives;
    private static List<String> xsdShortList;
    private static List<String> supportedPrimitives;

    static {
        xsdShortList = new ArrayList<String>();
        xsdShortList.add("string");
        xsdShortList.add("int");
        xsdShortList.add("double");
        xsdShortList.add("date");
        xsdShortList.add("time");
        xsdShortList.add("dateTime");
        xsdShortList.add("boolean");
        xsdShortList.add("hexBinary");
        xsdShortList.add("float");
        supportedPrimitives = new ArrayList<String>();
        supportedPrimitives.add("anyType");
        supportedPrimitives.add("anyURI");
        supportedPrimitives.add("base64Binary");
        supportedPrimitives.add("boolean");
        supportedPrimitives.add("byte");
        supportedPrimitives.add("date");
        supportedPrimitives.add("dateTime");
        supportedPrimitives.add("decimal");
        supportedPrimitives.add("double");
        supportedPrimitives.add("duration");
        supportedPrimitives.add("ENTITIES");
        supportedPrimitives.add("ENTITY");
        supportedPrimitives.add("float");
        supportedPrimitives.add("gDay");
        supportedPrimitives.add("gMonth");
        supportedPrimitives.add("gMonthDay");
        supportedPrimitives.add("gYear");
        supportedPrimitives.add("gYearMonth");
        supportedPrimitives.add("hexBinary");
        supportedPrimitives.add("ID");
        supportedPrimitives.add("IDREF");
        supportedPrimitives.add("IDREFS");
        supportedPrimitives.add("int");
        supportedPrimitives.add("integer");
        supportedPrimitives.add("language");
        supportedPrimitives.add("long");
        supportedPrimitives.add("Name");
        supportedPrimitives.add("NCName");
        supportedPrimitives.add("negativeInteger");
        supportedPrimitives.add("NMTOKEN");
        supportedPrimitives.add("NMTOKENS");
        supportedPrimitives.add("nonNegativeInteger");
        supportedPrimitives.add("nonPositiveInteger");
        supportedPrimitives.add("normalizedString");
        supportedPrimitives.add("NOTATION");
        supportedPrimitives.add("positiveInteger");
        supportedPrimitives.add("QName");
        supportedPrimitives.add("short");
        supportedPrimitives.add("string");
        supportedPrimitives.add("time");
        supportedPrimitives.add("token");
        supportedPrimitives.add("unsignedByte");
        supportedPrimitives.add("unsignedInt");
        supportedPrimitives.add("unsignedLong");
        supportedPrimitives.add("unsignedShort");
    }

    public static List<XSDTypeDefinition> getAdvancedPrimitives() {
        advancedPrimitives = null;
        if (advancedPrimitives == null) {
            advancedPrimitives = new ArrayList<XSDTypeDefinition>();
            XSDSchema schemaForSchemas = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            for (String typeName : supportedPrimitives) {
                XSDSimpleTypeDefinition type = schemaForSchemas.resolveSimpleTypeDefinition(typeName);
                advancedPrimitives.add((XSDTypeDefinition)type);
            }
            Collections.sort(advancedPrimitives, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null || ((XSDTypeDefinition)o1).getName() == null) {
                        return 0;
                    }
                    return ((XSDTypeDefinition)o1).getName().compareToIgnoreCase(((XSDTypeDefinition)o2).getName());
                }
            });
        }
        return advancedPrimitives;
    }

    public static List<XSDAttributeDeclaration> getChildAttributes(XSDComplexTypeDefinition bo) {
        EList attrContents = bo.getAttributeContents();
        ArrayList<XSDAttributeDeclaration> attrs = new ArrayList<XSDAttributeDeclaration>();
        int i = 0;
        while (i < attrContents.size()) {
            XSDAttributeGroupDefinition attrGroup;
            Object next = attrContents.get(i);
            if (next instanceof XSDAttributeUse) {
                attrs.add(((XSDAttributeUse)next).getContent().getResolvedAttributeDeclaration());
            } else if (next instanceof XSDAttributeGroupDefinition && (attrGroup = (XSDAttributeGroupDefinition)next).getResolvedAttributeGroupDefinition() != null) {
                attrContents.addAll((Collection)attrGroup.getResolvedAttributeGroupDefinition().getAttributeUses());
            }
            ++i;
        }
        return attrs;
    }

    public static List<XSDFeature> getChildElements(XSDComplexTypeDefinition bo) {
        return XSDUtils.getChildElements(XSDUtils.getModelGroup(bo));
    }

    public static List<XSDFeature> getChildElements(XSDModelGroup group) {
        if (group == null) {
            return new ArrayList<XSDFeature>();
        }
        ArrayList<XSDFeature> children = new ArrayList<XSDFeature>();
        for (XSDParticle next : group.getContents()) {
            if (next.getContent() instanceof XSDFeature) {
                children.add((XSDFeature)next.getContent());
                continue;
            }
            if (!(next.getTerm() instanceof XSDModelGroup)) continue;
            children.addAll(XSDUtils.getChildElements((XSDModelGroup)next.getTerm()));
        }
        return children;
    }

    public static XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDComplexTypeContent content;
        XSDParticle particle = cType.getComplexType();
        if (particle == null || particle.eContainer() != cType) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        if ((group.getContents().isEmpty() || group.eResource() != cType.eResource()) && cType.getBaseType() != null && (content = cType.getContent()) instanceof XSDParticle) {
            particleContent = ((XSDParticle)content).getContent();
            if (particleContent instanceof XSDModelGroupDefinition) {
                group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
            } else if (particleContent instanceof XSDModelGroup) {
                group = (XSDModelGroup)particleContent;
            }
        }
        return group;
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type) {
        return XSDUtils.getDisplayNameFromXSDType(type, true);
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type, boolean returnPrimitiveParents) {
        if (type == null) {
            return null;
        }
        if (type.getName() == null || type.getName().length() == 0) {
            if (returnPrimitiveParents && XSDUtils.isRestrictedPrimitiveType(type)) {
                return XSDUtils.getDisplayNameFromXSDType(type.getBaseType());
            }
            EObject container = type.eContainer();
            while (container != null) {
                if (container instanceof XSDNamedComponent && ((XSDNamedComponent)container).getName() != null) {
                    return ((XSDNamedComponent)container).getName();
                }
                container = container.eContainer();
            }
            return null;
        }
        return type.getName();
    }

    public static XSDSimpleTypeDefinition getPrimitive(String xsdName) {
        for (XSDTypeDefinition xsdTypeDefinition : XSDUtils.getAdvancedPrimitives()) {
            XSDSimpleTypeDefinition next = (XSDSimpleTypeDefinition)xsdTypeDefinition;
            if (!next.getName().equals(xsdName)) continue;
            return next;
        }
        return null;
    }

    public static List<XSDSimpleTypeDefinition> getPrimitives() {
        if (primitives == null) {
            primitives = new ArrayList<XSDSimpleTypeDefinition>();
            XSDSchema schemaForSchemas = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            for (String typeName : xsdShortList) {
                XSDSimpleTypeDefinition type = schemaForSchemas.resolveSimpleTypeDefinition(typeName);
                primitives.add(type);
            }
            Collections.sort(primitives, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null || XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o1) == null) {
                        return 0;
                    }
                    return XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o1).compareTo(XSDUtils.getDisplayNameFromXSDType((XSDTypeDefinition)o2));
                }
            });
        }
        return primitives;
    }

    public static XSDTypeDefinition getRootType(XSDTypeDefinition type) {
        if (type == null) {
            return null;
        }
        XSDTypeDefinition baseType = type.getBaseType();
        while (baseType != null && !XSDConstants.isAnySimpleType((XSDTypeDefinition)baseType) && !XSDConstants.isAnyType((XSDTypeDefinition)baseType)) {
            type = baseType;
            baseType = type.getBaseType();
        }
        return type;
    }

    public static boolean isRestrictedPrimitiveType(XSDTypeDefinition type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return false;
        }
        XSDTypeDefinition baseType = XSDUtils.getRootType(type);
        return XSDUtils.getAdvancedPrimitives().contains(baseType);
    }

    public static int getMinOccurs(XSDFeature xsdElem) {
        if (xsdElem.eContainer() instanceof XSDAttributeUse) {
            return ((XSDAttributeUse)xsdElem.eContainer()).getUse() == XSDAttributeUseCategory.REQUIRED_LITERAL ? 1 : 0;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        int min = 1;
        if (particle.isSetMinOccurs()) {
            min = particle.getMinOccurs();
        }
        return min;
    }

    public static int getMaxOccurs(XSDFeature xsdElem) {
        int max = 1;
        if (!(xsdElem.eContainer() instanceof XSDParticle)) {
            return max;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        if (particle.isSetMaxOccurs()) {
            max = particle.getMaxOccurs();
        }
        return max;
    }

    public static XSDComplexTypeDefinition getEnclosingTypeDefinition(EObject component) {
        if (component == null) {
            return null;
        }
        if (component instanceof XSDComplexTypeDefinition) {
            return (XSDComplexTypeDefinition)component;
        }
        return XSDUtils.getEnclosingTypeDefinition(component.eContainer());
    }

    public static List<XSDFeature> getXSDElementsAndAttributes(XSDComplexTypeDefinition complexType) {
        List<XSDFeature> result = XSDUtils.getChildElements(complexType);
        result.addAll(XSDUtils.getChildAttributes(complexType));
        return result;
    }
}

