/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.ui.details.tree.PartTreeNode;
import org.eclipse.bpel.ui.details.tree.PropertyTreeNode;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;

public class MessageTypeTreeNode
extends TreeNode {
    boolean isPropertyTree;
    boolean displayParticles;

    public MessageTypeTreeNode(Input msg, boolean isCondensed, boolean isProperty) {
        this((EObject)msg, isCondensed, isProperty, true);
    }

    public MessageTypeTreeNode(Output msg, boolean isCondensed, boolean isProperty) {
        this((EObject)msg, isCondensed, isProperty, true);
    }

    public MessageTypeTreeNode(Message messageType, boolean isCondensed, boolean isPropertyTree) {
        this(messageType, isCondensed, isPropertyTree, true);
    }

    public MessageTypeTreeNode(Message messageType, boolean isCondensed, boolean isPropertyTree, boolean displayParticles) {
        this((EObject)messageType, isCondensed, isPropertyTree, displayParticles);
    }

    private MessageTypeTreeNode(EObject obj, boolean isCondensed, boolean isPropertyTree, boolean displayParticles) {
        super(obj, isCondensed);
        this.isPropertyTree = isPropertyTree;
        this.displayParticles = displayParticles;
    }

    @Override
    public Object[] getChildren() {
        Message msg = this.getMessage();
        if (msg == null) {
            return EMPTY_ARRAY;
        }
        if (this.isPropertyTree) {
            List<PropertyAlias> aliases = BPELUtil.getPropertyAliasesForMessageType(msg);
            List<Property> properties = this.getPropertiesFromPropertyAliases(aliases);
            ArrayList<PropertyTreeNode> list = new ArrayList<PropertyTreeNode>();
            Iterator<Property> it = properties.iterator();
            while (it.hasNext()) {
                list.add(new PropertyTreeNode(it.next(), this.isCondensed));
            }
            return list.toArray();
        }
        if (msg.getParts() == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<PartTreeNode> list = new ArrayList<PartTreeNode>();
        Iterator it = msg.getParts().values().iterator();
        while (it.hasNext()) {
            list.add(new PartTreeNode((Part)it.next(), this.isCondensed, this.displayParticles));
        }
        return list.toArray();
    }

    @Override
    public boolean hasChildren() {
        if (this.isPropertyTree) {
            return this.getChildren().length > 0;
        }
        Message msg = this.getMessage();
        if (msg == null) {
            return false;
        }
        return msg.getParts() != null && !msg.getParts().isEmpty();
    }

    protected List<Property> getPropertiesFromPropertyAliases(List<PropertyAlias> aliases) {
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet<Property> propertySet = new HashSet<Property>();
        for (PropertyAlias alias : aliases) {
            Property property = (Property)alias.getPropertyName();
            if (propertySet.contains(property)) continue;
            properties.add(property);
            propertySet.add(property);
        }
        return properties;
    }

    Message getMessage() {
        if (this.modelObject instanceof Message) {
            return (Message)this.modelObject;
        }
        if (this.modelObject instanceof Input) {
            return ((Input)this.modelObject).getEMessage();
        }
        if (this.modelObject instanceof Output) {
            return ((Output)this.modelObject).getEMessage();
        }
        return null;
    }
}

