import { TSESLint } from '@typescript-eslint/experimental-utils';
import { ParserServices, TSESTree, visitorKeys } from '@typescript-eslint/typescript-estree';
import { analyzeScope } from './analyze-scope';
declare type ParserOptions = TSESLint.ParserOptions;
interface ParseForESLintResult {
    ast: TSESTree.Program & {
        range?: [number, number];
        tokens?: TSESTree.Token[];
        comments?: TSESTree.Comment[];
    };
    services: ParserServices;
    visitorKeys: typeof visitorKeys;
    scopeManager: ReturnType<typeof analyzeScope>;
}
declare function parse(code: string, options?: ParserOptions): ParseForESLintResult['ast'];
declare function parseForESLint(code: string, options?: ParserOptions | null): ParseForESLintResult;
export { parse, parseForESLint, ParserOptions };
//# sourceMappingURL=parser.d.ts.map