/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class ConnectionQuery {
    private Connection connection;

    public ConnectionQuery(Connection connection) {
        this.connection = connection;
    }

    public boolean isOrthogonalTreeBranch(PointList points) {
        if (this.isTreeBranch(points)) {
            LineSeg branch = new LineSeg(points.getPoint(0), points.getPoint(1));
            LineSeg trunkShoulder = new LineSeg(points.getPoint(1), points.getPoint(2));
            LineSeg trunk = new LineSeg(points.getPoint(2), points.getPoint(3));
            if (this.isTopDown()) {
                return branch.isVertical() && trunkShoulder.isHorizontal() && trunk.isVertical();
            }
            return branch.isHorizontal() && trunkShoulder.isVertical() && trunk.isHorizontal();
        }
        return false;
    }

    protected boolean isTreeBranch(PointList points) {
        if (points.size() == 4 && this.connection.getSourceAnchor() != null && this.connection.getSourceAnchor().getOwner() != null && this.connection.getTargetAnchor() != null && this.connection.getTargetAnchor().getOwner() != null) {
            Rectangle targetBounds = this.getTargetAnchorRelativeBounds();
            Rectangle sourceBounds = this.getSourceAnchorRelativeBounds();
            if (this.isTopDown()) {
                return points.getPoint((int)0).x > sourceBounds.x && points.getPoint((int)0).x < sourceBounds.x + sourceBounds.width && points.getPoint((int)3).x > targetBounds.x && points.getPoint((int)3).x < targetBounds.x + targetBounds.width;
            }
            return points.getPoint((int)0).y > sourceBounds.y && points.getPoint((int)0).y < sourceBounds.y + sourceBounds.height && points.getPoint((int)3).y > targetBounds.y && points.getPoint((int)3).y < targetBounds.y + targetBounds.height;
        }
        return false;
    }

    protected boolean isTopDown() {
        boolean vertical = true;
        if (this.connection instanceof ITreeConnection) {
            vertical = ((ITreeConnection)this.connection).getOrientation().equals(ITreeConnection.Orientation.VERTICAL);
        }
        return vertical;
    }

    private Rectangle getTargetAnchorRelativeBounds() {
        Rectangle bounds = this.connection.getTargetAnchor().getOwner().getBounds().getCopy();
        this.connection.getTargetAnchor().getOwner().translateToAbsolute((Translatable)bounds);
        this.connection.translateToRelative((Translatable)bounds);
        return bounds;
    }

    private Rectangle getSourceAnchorRelativeBounds() {
        Rectangle bounds = this.connection.getSourceAnchor().getOwner().getBounds().getCopy();
        this.connection.getSourceAnchor().getOwner().translateToAbsolute((Translatable)bounds);
        this.connection.translateToRelative((Translatable)bounds);
        return bounds;
    }

    public Option<List<RelativeBendpoint>> getTreeRelativeBendpointsConstraint() {
        Object cons = this.connection.getRoutingConstraint();
        if (cons instanceof List && ((List)cons).size() == 4) {
            return this.getRelativeBendpointsConstraint();
        }
        return Options.newNone();
    }

    public Option<List<AbsoluteBendpoint>> getTreeAbsoluteBendpointsConstraint() {
        Object cons = this.connection.getRoutingConstraint();
        if (cons instanceof List && ((List)cons).size() == 4) {
            return this.getAbsoluteBendpointsConstraint();
        }
        return Options.newNone();
    }

    public Option<List<AbsoluteBendpoint>> getAbsoluteBendpointsConstraint() {
        List constraintsList;
        Object cons = this.connection.getRoutingConstraint();
        if (cons instanceof List && Iterators.all((constraintsList = (List)cons).iterator(), (Predicate)Predicates.instanceOf(AbsoluteBendpoint.class))) {
            LinkedList<AbsoluteBendpoint> result = new LinkedList<AbsoluteBendpoint>();
            for (Object object : constraintsList) {
                result.add((AbsoluteBendpoint)object);
            }
            return Options.newSome(result);
        }
        return Options.newNone();
    }

    public Option<List<RelativeBendpoint>> getRelativeBendpointsConstraint() {
        List constraintsList;
        Object cons = this.connection.getRoutingConstraint();
        if (cons instanceof List && Iterators.all((constraintsList = (List)cons).iterator(), (Predicate)Predicates.instanceOf(RelativeBendpoint.class))) {
            LinkedList<RelativeBendpoint> result = new LinkedList<RelativeBendpoint>();
            for (Object object : constraintsList) {
                result.add((RelativeBendpoint)object);
            }
            return Options.newSome(result);
        }
        return Options.newNone();
    }

    public PointList getAbsolutePointList(RelativeBendpoints bendpoints, PrecisionPoint existingSourceAnchorAbsoluteLocation, PrecisionPoint existingTargetAnchorAbsoluteLocation) {
        PointList pointList = new PointList();
        Option<PointList> option = this.getAbsolutePointListFromConnection();
        if (option.some()) {
            pointList = (PointList)option.get();
        } else {
            List relativeBendpoints = bendpoints.getPoints();
            int i = 0;
            while (i < relativeBendpoints.size()) {
                float weight = (float)i / ((float)relativeBendpoints.size() - 1.0f);
                Point absoluteLocation = this.getLocation((Point)existingSourceAnchorAbsoluteLocation, (Point)existingTargetAnchorAbsoluteLocation, (org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint)relativeBendpoints.get(i), weight);
                pointList.addPoint(absoluteLocation);
                ++i;
            }
        }
        return pointList;
    }

    private Point getLocation(Point sourceAnchor, Point targetAnchor, org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint gmfRelativeBendpoint, float weight) {
        PrecisionPoint a1 = new PrecisionPoint(sourceAnchor);
        PrecisionPoint a2 = new PrecisionPoint(targetAnchor);
        return new PrecisionPoint((a1.preciseX() + (double)gmfRelativeBendpoint.getSourceX()) * (1.0 - (double)weight) + (double)weight * (a2.preciseX() + (double)gmfRelativeBendpoint.getTargetX()), (a1.preciseY() + (double)gmfRelativeBendpoint.getSourceY()) * (1.0 - (double)weight) + (double)weight * (a2.preciseY() + (double)gmfRelativeBendpoint.getTargetY()));
    }

    private Option<PointList> getAbsolutePointListFromConnection() {
        Option pointList = Options.newNone();
        if (this.connection != null) {
            pointList = Options.newSome((Object)this.connection.getPoints().getCopy());
        }
        return pointList;
    }
}

