/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.lemminx;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenConfigurationChangeListener;
import org.eclipse.m2e.editor.lemminx.BundleResolver;
import org.eclipse.wildwebdeveloper.xml.LemminxClasspathExtensionProvider;
import org.osgi.framework.Bundle;

public class MavenRuntimeClasspathProvider
implements LemminxClasspathExtensionProvider {
    private static IMavenConfigurationChangeListener mavenConfigurationlistener;

    public MavenRuntimeClasspathProvider() {
        if (mavenConfigurationlistener == null) {
            IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
            LanguageServersRegistry.LanguageServerDefinition lemminxDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.xml");
            if (mavenConfiguration != null && lemminxDefinition != null) {
                mavenConfigurationlistener = event -> {
                    HashMap<String, String> prefs = new HashMap<String, String>(2);
                    prefs.put("maven.globalSettings", mavenConfiguration.getGlobalSettingsFile());
                    prefs.put("maven.userSettings", mavenConfiguration.getUserSettingsFile());
                    DidChangeConfigurationParams params = new DidChangeConfigurationParams(Collections.singletonMap("xml", prefs));
                    LanguageServiceAccessor.getActiveLanguageServers(null).stream().filter(server -> lemminxDefinition.equals(LanguageServiceAccessor.resolveServerDefinition((LanguageServer)server).get())).forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params));
                };
                MavenPlugin.getMavenConfiguration().addConfigurationChangeListener(mavenConfigurationlistener);
            }
        }
    }

    public List<File> get() {
        File jar;
        ArrayList<File> mavenRuntimeJars = new ArrayList<File>();
        File jarDir = BundleResolver.getBundleResource("org.eclipse.m2e.maven.runtime", "/jars/");
        File[] fileArray = jarDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            jar = fileArray[n2];
            if (!jar.isDirectory()) {
                mavenRuntimeJars.add(jar);
            }
            ++n2;
        }
        jarDir = BundleResolver.getBundleResource("org.eclipse.m2e.editor.lemminx", "/indexer-jars/");
        fileArray = jarDir.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            jar = fileArray[n2];
            if (!jar.isDirectory()) {
                mavenRuntimeJars.add(jar);
            }
            ++n2;
        }
        try {
            mavenRuntimeJars.add(FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"javax.inject")));
            mavenRuntimeJars.add(FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.slf4j.api")));
        }
        catch (IOException iOException) {}
        return mavenRuntimeJars;
    }
}

