/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ConfigureFetchAfterCloneTask;
import org.eclipse.egit.core.op.ConfigureGerritAfterCloneTask;
import org.eclipse.egit.core.op.ConfigurePushAfterCloneTask;
import org.eclipse.egit.core.op.SetRepositoryConfigPropertyTask;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.egit.ui.internal.clone.RememberHostTask;
import org.eclipse.egit.ui.internal.clone.RepositoryLocationPage;
import org.eclipse.egit.ui.internal.clone.SourceBranchPage;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

public abstract class AbstractGitCloneWizard
extends Wizard {
    protected SourceBranchPage validSource;
    protected CloneDestinationPage cloneDestination;
    protected String alreadyClonedInto;
    protected boolean callerRunsCloneOperation;
    protected IRepositorySearchResult currentSearchResult;
    private CloneOperation cloneOperation;
    private RepositoryGroup group;

    public AbstractGitCloneWizard(IRepositorySearchResult searchResult) {
        this();
        this.currentSearchResult = searchResult;
    }

    public AbstractGitCloneWizard() {
        this.setNeedsProgressMonitor(true);
        this.validSource = new SourceBranchPage(){

            public void setVisible(boolean visible) {
                RepositorySelection selection = AbstractGitCloneWizard.this.getRepositorySelection();
                if (selection != null && visible) {
                    this.setSelection(selection);
                    this.setCredentials(AbstractGitCloneWizard.this.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.cloneDestination = new CloneDestinationPage(){

            @Override
            public void setVisible(boolean visible) {
                RepositorySelection selection = AbstractGitCloneWizard.this.getRepositorySelection();
                if (selection != null && visible) {
                    this.setSelection(selection, AbstractGitCloneWizard.this.validSource.getAvailableBranches(), AbstractGitCloneWizard.this.validSource.getSelectedBranches(), AbstractGitCloneWizard.this.validSource.getHEAD());
                }
                super.setVisible(visible);
            }
        };
    }

    protected abstract void addPreClonePages();

    protected abstract void addPostClonePages();

    public final void addPages() {
        if (this.hasSearchResult()) {
            this.addRepositorySearchPage();
        } else {
            this.addRepositoryLocationPage();
        }
        this.addPreClonePages();
        this.addPage((IWizardPage)this.validSource);
        this.addPage((IWizardPage)this.cloneDestination);
        this.addPostClonePages();
    }

    protected boolean hasSearchResult() {
        return this.currentSearchResult != null;
    }

    private void addRepositorySearchPage() {
        if (this.currentSearchResult instanceof WizardPage) {
            this.addPage((IWizardPage)((WizardPage)this.currentSearchResult));
        }
    }

    private void addRepositoryLocationPage() {
        List<GitCloneSourceProviderExtension.CloneSourceProvider> cloneSourceProviders = this.getCloneSourceProviders();
        if (this.hasSingleCloneSourceProviderWithFixedLocation(cloneSourceProviders)) {
            try {
                this.addPage((IWizardPage)cloneSourceProviders.get(0).getRepositorySearchPage());
            }
            catch (CoreException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        } else {
            this.addPage((IWizardPage)new RepositoryLocationPage(cloneSourceProviders));
        }
    }

    private boolean hasSingleCloneSourceProviderWithFixedLocation(List<GitCloneSourceProviderExtension.CloneSourceProvider> cloneSourceProviders) {
        return cloneSourceProviders.size() == 1 && cloneSourceProviders.get(0).hasFixLocation();
    }

    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        return GitCloneSourceProviderExtension.getCloneSourceProvider();
    }

    protected boolean performClone(GitRepositoryInfo gitRepositoryInfo) throws URISyntaxException {
        List<Object> selectedBranches;
        boolean allSelected;
        URIish uri = new URIish(gitRepositoryInfo.getCloneUri());
        UserPasswordCredentials credentials = gitRepositoryInfo.getCredentials();
        this.setWindowTitle(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString()));
        if (this.validSource.isSourceRepoEmpty()) {
            allSelected = true;
            selectedBranches = Collections.emptyList();
        } else {
            allSelected = this.validSource.isAllSelected();
            selectedBranches = this.validSource.getSelectedBranches();
        }
        File workdir = this.cloneDestination.getDestinationFile();
        Ref ref = this.cloneDestination.getInitialBranch();
        String remoteName = this.cloneDestination.getRemote();
        boolean created = workdir.exists();
        if (!created) {
            created = workdir.mkdirs();
        }
        if (!created || !workdir.isDirectory()) {
            String errorMessage = NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)workdir.getPath());
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)UIText.GitCloneWizard_failed, (IStatus)new Status(4, Activator.getPluginId(), 0, errorMessage, null));
            return false;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        CloneOperation op = new CloneOperation(uri, allSelected, selectedBranches, workdir, ref != null ? ref.getName() : null, remoteName, timeout);
        EGitCredentialsProvider credentialsProvider = null;
        credentialsProvider = credentials != null ? new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()) : new EGitCredentialsProvider();
        op.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        op.setCloneSubmodules(this.cloneDestination.isCloneSubmodules());
        op.setTagOption(this.validSource.getTagOption());
        this.rememberHttpHost(op, uri);
        this.configureFetchSpec(op, gitRepositoryInfo, remoteName);
        this.configurePush(op, gitRepositoryInfo, remoteName);
        this.configureRepositoryConfig(op, gitRepositoryInfo);
        this.configureGerrit(op, gitRepositoryInfo, credentialsProvider, remoteName, timeout);
        if (this.cloneDestination.isImportProjects()) {
            final IWorkingSet[] sets = this.cloneDestination.getWorkingSets();
            op.addPostCloneTask(new CloneOperation.PostCloneTask(){

                public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
                    AbstractGitCloneWizard.this.importProjects(repository, sets);
                }
            });
        }
        this.alreadyClonedInto = workdir.getPath();
        if (!this.callerRunsCloneOperation) {
            this.runAsJob(uri, op, gitRepositoryInfo);
        } else {
            this.cloneOperation = op;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof IRepositorySearchResult) {
            this.currentSearchResult = (IRepositorySearchResult)page;
            return this.validSource;
        }
        return super.getNextPage(page);
    }

    @Nullable
    protected RepositorySelection getRepositorySelection() {
        try {
            return new RepositorySelection(new URIish(this.currentSearchResult.getGitRepositoryInfo().getCloneUri()), null);
        }
        catch (URISyntaxException e) {
            Activator.error(UIText.GitImportWizard_errorParsingURI, e);
            return null;
        }
        catch (NoRepositoryInfoException e) {
            Activator.error(UIText.GitImportWizard_noRepositoryInfo, e);
            return null;
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    protected UserPasswordCredentials getCredentials() {
        try {
            return this.currentSearchResult.getGitRepositoryInfo().getCredentials();
        }
        catch (NoRepositoryInfoException e) {
            Activator.error(UIText.GitImportWizard_noRepositoryInfo, e);
            return null;
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    private void rememberHttpHost(CloneOperation op, URIish uri) {
        String host;
        String scheme = uri.getScheme();
        if (scheme != null && scheme.toLowerCase().startsWith("http") && (host = uri.getHost()) != null) {
            op.addPostCloneTask((CloneOperation.PostCloneTask)new RememberHostTask(host));
        }
    }

    private void configureFetchSpec(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, String remoteName) {
        for (String fetchRefSpec : gitRepositoryInfo.getFetchRefSpecs()) {
            op.addPostCloneTask((CloneOperation.PostCloneTask)new ConfigureFetchAfterCloneTask(remoteName, fetchRefSpec));
        }
    }

    private void configurePush(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, String remoteName) {
        for (GitRepositoryInfo.PushInfo pushInfo : gitRepositoryInfo.getPushInfos()) {
            try {
                URIish uri = pushInfo.getPushUri() != null ? new URIish(pushInfo.getPushUri()) : null;
                ConfigurePushAfterCloneTask task = new ConfigurePushAfterCloneTask(remoteName, pushInfo.getPushRefSpec(), uri);
                op.addPostCloneTask((CloneOperation.PostCloneTask)task);
            }
            catch (URISyntaxException e) {
                Activator.handleError(UIText.GitCloneWizard_failed, e, true);
            }
        }
    }

    private void configureRepositoryConfig(CloneOperation op, GitRepositoryInfo gitRepositoryInfo) {
        for (GitRepositoryInfo.RepositoryConfigProperty p : gitRepositoryInfo.getRepositoryConfigProperties()) {
            SetRepositoryConfigPropertyTask task = new SetRepositoryConfigPropertyTask(p.getSection(), p.getSubsection(), p.getName(), p.getValue());
            op.addPostCloneTask((CloneOperation.PostCloneTask)task);
        }
    }

    private void configureGerrit(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, CredentialsProvider credentialsProvider, String remoteName, int timeout) {
        ConfigureGerritAfterCloneTask task = new ConfigureGerritAfterCloneTask(gitRepositoryInfo.getCloneUri(), remoteName, credentialsProvider, timeout);
        op.addPostCloneTask((CloneOperation.PostCloneTask)task);
    }

    private void importProjects(final Repository repository, final IWorkingSet[] sets) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        WorkspaceJob importJob = new WorkspaceJob(MessageFormat.format(UIText.GitCloneWizard_jobImportProjects, repoName)){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                ArrayList files = new ArrayList();
                ProjectUtil.findProjectFiles(files, (File)repository.getWorkTree(), (boolean)true, (IProgressMonitor)progress.newChild(1));
                if (files.isEmpty()) {
                    return Status.OK_STATUS;
                }
                LinkedHashSet<ProjectRecord> records = new LinkedHashSet<ProjectRecord>();
                for (File file : files) {
                    ProjectRecord record = new ProjectRecord(file);
                    if (record.getProjectDescription() == null) continue;
                    records.add(record);
                }
                if (records.isEmpty()) {
                    return Status.OK_STATUS;
                }
                try {
                    ProjectUtils.createProjects(records, sets, (IProgressMonitor)progress.newChild(1));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    Activator.logError(e.getLocalizedMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        importJob.schedule();
    }

    public void runCloneOperation(IWizardContainer container, final GitRepositoryInfo repositoryInfo) {
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AbstractGitCloneWizard.this.executeCloneOperation(AbstractGitCloneWizard.this.cloneOperation, repositoryInfo, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.GitCloneWizard_failed, e.getCause(), true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void runAsJob(URIish uri, final CloneOperation op, final GitRepositoryInfo repositoryInfo) {
        Job job = new Job(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return AbstractGitCloneWizard.this.executeCloneOperation(op, repositoryInfo, monitor);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    Throwable thr = e.getCause();
                    return new Status(4, Activator.getPluginId(), 0, thr.getMessage(), thr);
                }
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CLONE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus executeCloneOperation(CloneOperation op, GitRepositoryInfo repositoryInfo, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        op.run(monitor);
        if (this.group != null) {
            RepositoryGroups.getInstance().addRepositoriesToGroup(this.group, Collections.singletonList(op.getGitDir()));
        }
        util.addConfiguredRepository(op.getGitDir());
        try {
            if (repositoryInfo.shouldSaveCredentialsInSecureStore()) {
                SecureStoreUtils.storeCredentials(repositoryInfo.getCredentials(), new URIish(repositoryInfo.getCloneUri()));
            }
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
        return Status.OK_STATUS;
    }

    public void setCallerRunsCloneOperation(boolean newValue) {
        this.callerRunsCloneOperation = newValue;
    }

    public void setRepositoryGroup(RepositoryGroup group) {
        this.group = group;
    }
}

