/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import org.eclipse.dltk.tcl.internal.parser.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parser.raw.ICodeScanner;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.Messages;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclTextUtils;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;

public class VariableSubstitution
extends TclElement
implements ISubstitution {
    public static final int VAR_SIMPLE = 0;
    public static final int VAR_ARRAY = 1;
    public static final int VAR_NAME = 2;
    private String name;
    private TclWord index;
    private int kind;

    public TclWord getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static boolean iAm(ICodeScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return false;
        }
        if (c != 36) {
            scanner.unread();
            return false;
        }
        int c2 = scanner.read();
        scanner.unread();
        if (c2 != -1) {
            scanner.unread();
        }
        return TclTextUtils.isIdentifier(c2) || c2 == 40 || c2 == 123;
    }

    @Override
    public boolean readMe(ICodeScanner input, SimpleTclParser parser) throws TclParseException {
        if (!VariableSubstitution.iAm(input)) {
            return false;
        }
        this.setStart(input.getPosition());
        this.name = "";
        this.kind = 0;
        input.read();
        int c = input.read();
        if (c == 123) {
            this.kind = 2;
            while (true) {
                if ((c = input.read()) == -1) {
                    boolean cont = parser.handleError(new ErrorDescription(Messages.VariableSubstitution_BracesVariableName, this.getStart(), input.getPosition(), 0));
                    if (!cont) {
                        throw new TclParseException(Messages.VariableSubstitution_BracesVariableName, input.getPosition());
                    }
                } else if (c != 125) {
                    this.name = String.valueOf(this.name) + (char)c;
                    continue;
                }
                break;
            }
        } else {
            while (c != -1) {
                if (TclTextUtils.isIdentifier(c)) {
                    this.name = String.valueOf(this.name) + (char)c;
                    c = input.read();
                    continue;
                }
                if (c == 40) {
                    this.kind = 1;
                    TclWord cvb = new TclWord();
                    cvb.setStart(input.getPosition());
                    while (true) {
                        ISubstitution s;
                        if ((s = parser.getCVB(input)) != null) {
                            s.readMe(input, parser);
                            cvb.add(s);
                            if (!(s instanceof TclElement)) continue;
                            cvb.setEnd(((TclElement)((Object)s)).getEnd());
                            continue;
                        }
                        int ch = input.read();
                        if (ch == -1) {
                            boolean cont = parser.handleError(new ErrorDescription(Messages.VariableSubstitution_VariableIndex, this.getStart(), input.getPosition(), 0));
                            if (cont) break;
                            throw new TclParseException(Messages.VariableSubstitution_VariableIndex, this.getStart());
                        }
                        if (ch == 41) {
                            if (input.isEOF()) {
                                cvb.setEnd(input.getPosition() - 1);
                                break;
                            }
                            cvb.setEnd(input.getPosition() - 2);
                            break;
                        }
                        cvb.add((char)ch);
                        cvb.setEnd(input.getPosition());
                    }
                    this.index = cvb;
                    break;
                }
                input.unread();
                break;
            }
        }
        if (!input.isEOF()) {
            this.setEnd(input.getPosition() - 1);
        } else {
            this.setEnd(input.getPosition());
        }
        return true;
    }

    public int getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("$");
        if (this.kind == 2) {
            sb.append("{");
        }
        sb.append(this.name);
        if (this.kind == 2) {
            sb.append("}");
        }
        if (this.index != null) {
            sb.append("(");
            sb.append(this.index);
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

