/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final WbemcliUtil.WmiQuery<ComputerSystemProductProperty> IDENTIFYINGNUMBER_QUERY = WbemcliUtil.createQuery("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class);
    private String systemSerialNumber = "";

    WindowsComputerSystem() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery<ComputerSystemProperty> computerSystemQuery = WbemcliUtil.createQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WbemcliUtil.WmiResult<ComputerSystemProperty> win32ComputerSystem = WmiUtil.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.setManufacturer(win32ComputerSystem.getString(ComputerSystemProperty.MANUFACTURER, 0));
            this.setModel(win32ComputerSystem.getString(ComputerSystemProperty.MODEL, 0));
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new WindowsFirmware());
        this.setBaseboard(new WindowsBaseboard());
    }

    private String getSystemSerialNumber() {
        WbemcliUtil.WmiResult<ComputerSystemProductProperty> identifyingNumber;
        if (!"".equals(this.systemSerialNumber)) {
            return this.systemSerialNumber;
        }
        WbemcliUtil.WmiQuery<BiosProperty> serialNumberQuery = WbemcliUtil.createQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult<BiosProperty> serialNumber = WmiUtil.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.systemSerialNumber = serialNumber.getString(BiosProperty.SERIALNUMBER, 0);
        }
        if (!"".equals(this.systemSerialNumber) && (identifyingNumber = WmiUtil.queryWMI(IDENTIFYINGNUMBER_QUERY)).getResultCount() > 0) {
            this.systemSerialNumber = identifyingNumber.getString(ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        if (!"".equals(this.systemSerialNumber)) {
            this.systemSerialNumber = "unknown";
        }
        return this.systemSerialNumber;
    }

    static enum BiosProperty {
        SERIALNUMBER;

    }

    static enum ComputerSystemProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }
}

