/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSResourceRuleFactory;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;

public class CVSCoreFileModificationValidator
extends FileModificationValidator
implements ICVSFileModificationValidator {
    FileModificationValidator uiValidator;

    public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
        IStatus status;
        IFile[] unmanagedReadOnlyFiles = this.getUnmanagedReadOnlyFiles(files);
        if (unmanagedReadOnlyFiles.length > 0 && !(status = this.setWritable(unmanagedReadOnlyFiles)).isOK()) {
            return status;
        }
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return Status.OK_STATUS;
        }
        return this.edit(readOnlyFiles, context);
    }

    public IStatus validateSave(IFile file) {
        if (!this.needsCheckout(file)) {
            if (file.isReadOnly()) {
                this.setWritable(new IFile[]{file});
            }
            return Status.OK_STATUS;
        }
        return this.edit(new IFile[]{file}, null);
    }

    protected IStatus edit(IFile[] readOnlyFiles, FileModificationValidationContext context) {
        FileModificationValidator override = this.getUIValidator();
        if (override != null) {
            return override.validateEdit(readOnlyFiles, context);
        }
        this.performEdit(readOnlyFiles);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileModificationValidator getUIValidator() {
        CVSCoreFileModificationValidator cVSCoreFileModificationValidator = this;
        synchronized (cVSCoreFileModificationValidator) {
            if (this.uiValidator == null) {
                this.uiValidator = CVSCoreFileModificationValidator.getPluggedInValidator();
            }
        }
        return this.uiValidator;
    }

    @Override
    public IStatus validateMoveDelete(IFile[] files, IProgressMonitor monitor) {
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return Status.OK_STATUS;
        }
        this.performEdit(readOnlyFiles);
        return Status.OK_STATUS;
    }

    protected void performEdit(final IFile[] readOnlyFiles) {
        this.setWritable(readOnlyFiles);
        Job job = new Job(CVSMessages.CVSCoreFileModificationValidator_editJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CVSCoreFileModificationValidator.this.performEdit(readOnlyFiles, monitor);
                }
                catch (CVSException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.scheduleEditJob(job);
    }

    protected void scheduleEditJob(Job job) {
        job.schedule();
    }

    protected CVSTeamProvider getProvider(IFile[] files) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)files[0].getProject(), (String)CVSProviderPlugin.getTypeId());
        return provider;
    }

    protected void performEdit(IFile[] files, IProgressMonitor monitor) throws CVSException {
        this.getProvider(files).edit((IResource[])files, false, true, true, 0, monitor);
    }

    private boolean needsCheckout(IFile file) {
        try {
            if (file.isReadOnly()) {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(file);
                boolean managed = cvsFile.isManaged();
                return managed;
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    protected IStatus setWritable(IFile[] files) {
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            ResourceAttributes attributes = file.getResourceAttributes();
            if (attributes != null) {
                attributes.setReadOnly(false);
            }
            try {
                file.setResourceAttributes(attributes);
            }
            catch (CoreException e) {
                return CVSException.wrapException(e).getStatus();
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private IFile[] getManagedReadOnlyFiles(IFile[] files) {
        ArrayList<IFile> readOnlys = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            IFile iFile = files[i];
            if (this.needsCheckout(iFile)) {
                readOnlys.add(iFile);
            }
            ++i;
        }
        return readOnlys.toArray(new IFile[readOnlys.size()]);
    }

    protected IFile[] getUnmanagedReadOnlyFiles(IFile[] files) {
        ArrayList<IFile> readOnlys = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            IFile iFile = files[i];
            if (iFile.isReadOnly() && !this.needsCheckout(iFile)) {
                readOnlys.add(iFile);
            }
            ++i;
        }
        return readOnlys.toArray(new IFile[readOnlys.size()]);
    }

    private static FileModificationValidator getPluggedInValidator() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.cvs.core", "filemodificationvalidator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension extension = extensions[0];
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            CVSProviderPlugin.log(4, NLS.bind((String)"The CVS file modification validator is missing from extension {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (FileModificationValidator)config.createExecutableExtension("run");
        }
        catch (CoreException ex) {
            CVSProviderPlugin.log(4, NLS.bind((String)"The CVS file modification validator registered as ID {0} could not be instantiated", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
            return null;
        }
    }

    public ISchedulingRule validateEditRule(CVSResourceRuleFactory factory, IResource[] resources) {
        FileModificationValidator override = this.getUIValidator();
        if (override instanceof CVSCoreFileModificationValidator && override != this) {
            CVSCoreFileModificationValidator ui = (CVSCoreFileModificationValidator)override;
            return ui.validateEditRule(factory, resources);
        }
        return this.internalValidateEditRule(factory, resources);
    }

    protected final ISchedulingRule internalValidateEditRule(CVSResourceRuleFactory factory, IResource[] resources) {
        if (resources.length == 0) {
            return null;
        }
        if (resources.length == 1) {
            return this.isReadOnly(resources[0]) ? factory.getParent(resources[0]) : null;
        }
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            if (this.isReadOnly(resources[i])) {
                rules.add(factory.getParent(resources[i]));
            }
            ++i;
        }
        return this.createSchedulingRule(rules);
    }

    protected ISchedulingRule createSchedulingRule(Set rules) {
        if (rules.isEmpty()) {
            return null;
        }
        if (rules.size() == 1) {
            return (ISchedulingRule)rules.iterator().next();
        }
        ISchedulingRule[] ruleArray = rules.toArray(new ISchedulingRule[rules.size()]);
        return new MultiRule(ruleArray);
    }

    protected final boolean isReadOnly(IResource resource) {
        ResourceAttributes a = resource.getResourceAttributes();
        if (a != null) {
            return a.isReadOnly();
        }
        return false;
    }
}

