/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.modelingproject;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.internal.modelingproject.ModelingElementResourceMapping;
import org.eclipse.sirius.business.internal.modelingproject.ModelingResourceMapping;
import org.eclipse.sirius.business.internal.modelingproject.marker.InvalidModelingProjectMarkerUpdaterJob;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.Messages;

public class ModelingModelProvider
extends ModelProvider {
    public static final String MODELING_MODEL_PROVIDER_ID = "org.eclipse.sirius.ui.modelProvider";

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        Object adapted;
        Option<ModelingProject> optionalModelingProject;
        ResourceMapping[] result = null;
        if (resource instanceof IProject && (optionalModelingProject = ModelingProject.asModelingProject((IProject)resource)).some()) {
            result = new ResourceMapping[]{ModelingElementResourceMapping.create((ModelingProject)optionalModelingProject.get())};
        }
        if (result == null && (adapted = resource.getAdapter(ResourceMapping.class)) instanceof ResourceMapping) {
            result = new ResourceMapping[]{(ResourceMapping)adapted};
        }
        if (result == null) {
            result = new ResourceMapping[]{new ModelingResourceMapping(resource)};
        }
        return result;
    }

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        IStatus result = null;
        if (delta != null) {
            try {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.getProjectContainingSessionToSaveToDelete().size() == 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, Messages.ModelingModelProvider_satusUnsavedDataWillBeLost);
                } else if (visitor.getProjectContainingSessionToSaveToDelete().size() > 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, MessageFormat.format(Messages.ModelingModelProvider_satusUnsaveDataWillBeLostWithProjectNames, this.getProjectsName(visitor.getProjectContainingSessionToSaveToDelete())));
                } else if (visitor.getMainRepresentationsFilesToDelete().size() == 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, MessageFormat.format(Messages.ModelingModelProvider_mainRepresentationFileDeleted, visitor.getMainRepresentationsFilesToDelete().get(0).getProject().getName()));
                } else if (visitor.getMainRepresentationsFilesToDelete().size() > 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, MessageFormat.format(Messages.ModelingModelProvider_mainRepresentationFilesOfSomeProjectsDeleted, this.getFilesProjectName(visitor.getMainRepresentationsFilesToDelete())));
                } else if (visitor.getRepresentationsFileToAddOnValidModelingProject().size() == 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, MessageFormat.format(Messages.ModelingModelProvider_addAnotherRepresentationFile, visitor.getRepresentationsFileToAddOnValidModelingProject().get(0).getProject().getName()));
                } else if (visitor.getRepresentationsFileToAddOnValidModelingProject().size() > 1) {
                    result = new ModelStatus(4, "org.eclipse.sirius", MODELING_MODEL_PROVIDER_ID, MessageFormat.format(Messages.ModelingModelProvider_addAnotherRepresentationFileSeveralProjects, this.getFilesProjectName(visitor.getRepresentationsFileToAddOnValidModelingProject())));
                }
            }
            catch (CoreException coreException) {}
        }
        if (result == null) {
            result = super.validateChange(delta, monitor);
        }
        return result;
    }

    private String getProjectsName(List<IProject> projects) {
        StringBuffer result = new StringBuffer();
        Iterator<IProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            result.append(project.getName());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private String getFilesProjectName(List<IFile> files) {
        StringBuffer result = new StringBuffer();
        Iterator<IFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            IFile file = iterator.next();
            result.append(file.getProject().getName());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        List<IProject> projectContainingSessionToSaveToDelete = new ArrayList<IProject>();
        List<IFile> mainRepresentationsFileToDelete = new ArrayList<IFile>();
        List<IFile> representationsFileToAddOnValidModelingProject = new ArrayList<IFile>();

        private ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean visitChildren = true;
            IResource res = delta.getResource();
            if (res.getType() == 4) {
                visitChildren = this.visitProject(delta, (IProject)res);
            } else if (res.getType() == 1) {
                visitChildren = this.visitFile(delta, (IFile)res);
            }
            return visitChildren;
        }

        protected boolean visitProject(IResourceDelta delta, IProject project) throws CoreException {
            boolean visitChildren = false;
            Option<ModelingProject> optionalModelingProject = ModelingProject.asModelingProject(project);
            if (optionalModelingProject.some()) {
                if (2 == delta.getKind()) {
                    Session session = ((ModelingProject)optionalModelingProject.get()).getSession();
                    if (session != null && session.isOpen() && SessionStatus.DIRTY.equals((Object)session.getStatus())) {
                        this.projectContainingSessionToSaveToDelete.add(project);
                    }
                    return false;
                }
                visitChildren = true;
            }
            return visitChildren;
        }

        protected boolean visitFile(IResourceDelta delta, IFile currentFile) throws CoreException {
            boolean visitChildren = false;
            Option<ModelingProject> optionalModelingProject = ModelingProject.asModelingProject(currentFile.getProject());
            if (optionalModelingProject.some()) {
                if (2 == delta.getKind()) {
                    if (((ModelingProject)optionalModelingProject.get()).isValid()) {
                        if (((ModelingProject)optionalModelingProject.get()).isMainRepresentationsFile(currentFile)) {
                            this.mainRepresentationsFileToDelete.add(currentFile);
                        }
                    } else if (new FileQuery(currentFile).isSessionResourceFile()) {
                        try {
                            ((ModelingProject)optionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), true, true);
                        }
                        catch (IllegalArgumentException e) {
                            IProject project = ((ModelingProject)optionalModelingProject.get()).getProject();
                            InvalidModelingProjectMarkerUpdaterJob invalidModelingProjectMarkerUpdaterJob = new InvalidModelingProjectMarkerUpdaterJob(project, e.getMessage());
                            invalidModelingProjectMarkerUpdaterJob.schedule();
                        }
                    }
                } else if (1 == delta.getKind() && "aird".equals(currentFile.getFileExtension()) && ((ModelingProject)optionalModelingProject.get()).isValid()) {
                    this.representationsFileToAddOnValidModelingProject.add(currentFile);
                }
            }
            return visitChildren;
        }

        public List<IProject> getProjectContainingSessionToSaveToDelete() {
            return this.projectContainingSessionToSaveToDelete;
        }

        public List<IFile> getMainRepresentationsFilesToDelete() {
            return this.mainRepresentationsFileToDelete;
        }

        public List<IFile> getRepresentationsFileToAddOnValidModelingProject() {
            return this.representationsFileToAddOnValidModelingProject;
        }
    }
}

