/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.WorkspaceImagePathSelector;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.WorkspacePathValidator;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SelectDiagramElementBackgroundImageDialog
extends Dialog {
    private WorkspaceImage workspaceImageForWorkspace = DiagramFactory.eINSTANCE.createWorkspaceImage();
    private Label workspacePathLabel;
    private Text workspacePathText;
    private Button browseButton;

    public SelectDiagramElementBackgroundImageDialog(Shell shell, BasicLabelStyle basicLabelStyle) {
        super(shell);
        if (basicLabelStyle instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)basicLabelStyle;
            this.workspaceImageForWorkspace.setWorkspacePath(workspaceImage.getWorkspacePath());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        mainComposite.setLayout((Layout)gridLayout);
        mainComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.createFromWorkspaceComposite(mainComposite);
        return mainComposite;
    }

    private void createFromWorkspaceComposite(Composite mainComposite) {
        Composite fromWorkspaceComposite = new Composite(mainComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fromWorkspaceComposite.setLayout((Layout)gridLayout);
        fromWorkspaceComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.workspacePathLabel = new Label(fromWorkspaceComposite, 0);
        this.workspacePathLabel.setText(Messages.SelectDiagramElementBackgroundImageDialog_pathLabelText);
        this.workspacePathText = new Text(fromWorkspaceComposite, 0x800800);
        this.workspacePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.workspacePathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        ISWTObservableValue workspacePathTextObservable = WidgetProperties.text((int)24).observe((Widget)this.workspacePathText);
        IObservableValue workspaceImageObservable = EMFProperties.value((EStructuralFeature)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH).observe((Object)this.workspaceImageForWorkspace);
        DataBindingContext ctx = new DataBindingContext();
        WorkspacePathValidator workspacePathValidator = new WorkspacePathValidator(controlDecoration);
        ctx.bindValue((IObservableValue)workspacePathTextObservable, workspaceImageObservable, new UpdateValueStrategy().setAfterConvertValidator((IValidator)workspacePathValidator), null);
        this.browseButton = new Button(fromWorkspaceComposite, 0);
        this.browseButton.setText(Messages.SelectDiagramElementBackgroundImageDialog_browseButtonText);
        this.browseButton.addSelectionListener((SelectionListener)new WorkspaceImagePathSelector(this.workspacePathText));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SelectDiagramElementBackgroundImageDialog_title);
        shell.setMinimumSize(500, 100);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public String getImagePath() {
        return this.workspaceImageForWorkspace.getWorkspacePath();
    }
}

