/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests.initialize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.pmf.emf.EMFType;
import org.eclipse.pmf.emf.PEMFFactory;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.Command;
import org.eclipse.pmf.pim.DataConverter;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.SystemAction;
import org.eclipse.pmf.pim.Validator;
import org.eclipse.pmf.pim.ViewProfile;
import org.eclipse.pmf.pim.exception.PMFException;
import org.eclipse.pmf.pim.ui.Image;
import org.eclipse.pmf.pim.ui.UiFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApplicationLibrariesTest {
    private Application application;
    private Library library1;
    private Library library2;
    private Library library3;

    @Before
    public void setUp() throws Exception {
        this.application = PMFFactory.eINSTANCE.createApplication();
        this.application.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.application.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.application.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.application.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.application.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.application.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.application.getImages().add((Object)UiFactory.eINSTANCE.createImage());
        this.library1 = PMFFactory.eINSTANCE.createLibrary();
        this.library1.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.library1.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.library1.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.library1.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.library1.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.library1.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.library2 = PMFFactory.eINSTANCE.createLibrary();
        this.library2.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.library2.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.library2.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.library2.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.library2.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.library2.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.library2.getImages().add((Object)UiFactory.eINSTANCE.createImage());
        this.library3 = PMFFactory.eINSTANCE.createLibrary();
        this.library3.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.library3.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.library3.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.library3.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.library3.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.library3.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.library3.getImages().add((Object)UiFactory.eINSTANCE.createImage());
    }

    @Test
    public void testAddLibrary() {
        this.doValidateApplication(this.library1, false);
        this.application.getLibraries().add((Object)this.library1);
        this.doValidateApplication(this.library1, true);
        this.doValidateApplication(this.library2, false);
        this.application.getLibraries().add((Object)this.library2);
        this.doValidateApplication(this.library1, true);
        this.doValidateApplication(this.library2, true);
        this.doValidateApplication(this.library3, false);
        this.application.getLibraries().add((Object)this.library3);
        this.doValidateApplication(this.library1, true);
        this.doValidateApplication(this.library2, true);
        this.doValidateApplication(this.library3, true);
    }

    private void doValidateApplication(Library library, boolean contains) {
        Assert.assertNotNull((String)"application", (Object)this.application);
        Assert.assertNotNull((String)"library", (Object)library);
        EList commands = library.getCommands();
        EList converters = library.getConverters();
        EList systemActions = library.getSystemActions();
        EList types = library.getTypes();
        EList validators = library.getValidators();
        EList viewProfiles = library.getViewProfiles();
        EList images = library.getImages();
        if (contains) {
            Assert.assertTrue((String)"All commands of Library should be synchronized to application", (boolean)this.application.getAllCommands().containsAll((Collection)commands));
            Assert.assertTrue((String)"All converters of Library should be synchronized to application ", (boolean)this.application.getAllConverters().containsAll((Collection)converters));
            Assert.assertTrue((String)"All systemActions of Library should be synchronized to application", (boolean)this.application.getAllSystemActions().containsAll((Collection)systemActions));
            Assert.assertTrue((String)"All dataTypes of Library should be synchronized to application", (boolean)this.application.getAllTypes().containsAll((Collection)types));
            Assert.assertTrue((String)"All validators of Library should be synchronized to application", (boolean)this.application.getAllValidators().containsAll((Collection)validators));
            Assert.assertTrue((String)"All viewProfiles of Library should be synchronized to application", (boolean)this.application.getAllViewProfiles().containsAll((Collection)viewProfiles));
            Assert.assertTrue((String)"All images of Library should be synchronized to application", (boolean)this.application.getAllImages().containsAll((Collection)images));
        } else {
            for (Command cmd : commands) {
                if (!this.application.getAllCommands().contains((Object)cmd)) continue;
                Assert.fail((String)"Command of Library should be removed from application");
            }
            for (DataConverter cvt : converters) {
                if (!this.application.getAllConverters().contains((Object)cvt)) continue;
                Assert.fail((String)"DataConverter of Library should be removed from application");
            }
            for (SystemAction obj : systemActions) {
                if (!this.application.getAllSystemActions().contains((Object)obj)) continue;
                Assert.fail((String)"SystemAction of Library should be removed from application");
            }
            for (SystemAction obj : types) {
                if (!this.application.getAllTypes().contains((Object)obj)) continue;
                Assert.fail((String)"DataType of Library should be removed from application");
            }
            for (SystemAction obj : validators) {
                if (!this.application.getAllValidators().contains((Object)obj)) continue;
                Assert.fail((String)"Validator of Library should be removed from application");
            }
            for (SystemAction obj : viewProfiles) {
                if (!this.application.getAllViewProfiles().contains((Object)obj)) continue;
                Assert.fail((String)"ViewProfile of Library should be removed from application");
            }
            for (SystemAction obj : images) {
                if (!this.application.getAllImages().contains((Object)obj)) continue;
                Assert.fail((String)"Image of Library should be removed from application");
            }
        }
    }

    @Test
    public void test_eSetLibraries() {
        ArrayList<Library> libraries = new ArrayList<Library>();
        libraries.add(this.library1);
        libraries.add(this.library2);
        libraries.add(this.library3);
        this.application.eSet((EStructuralFeature)PMFPackage.eINSTANCE.getApplication_Libraries(), libraries);
        this.doValidateApplication(this.library1, true);
        this.doValidateApplication(this.library2, true);
        this.doValidateApplication(this.library3, true);
        this.application.eSet((EStructuralFeature)PMFPackage.eINSTANCE.getApplication_Libraries(), new ArrayList());
        this.doValidateApplication(this.library1, false);
        this.doValidateApplication(this.library2, false);
        this.doValidateApplication(this.library3, false);
    }

    @Test
    public void testRemoveLibrary() {
        this.application.getLibraries().add((Object)this.library1);
        this.doValidateApplication(this.library1, true);
        this.application.getLibraries().remove((Object)this.library1);
        this.doValidateApplication(this.library1, false);
        this.application.getLibraries().add((Object)this.library2);
        this.doValidateApplication(this.library2, true);
        this.application.getLibraries().remove((Object)this.library2);
        this.doValidateApplication(this.library2, false);
        this.application.getLibraries().add((Object)this.library3);
        this.doValidateApplication(this.library3, true);
        this.application.getLibraries().remove((Object)this.library3);
        this.doValidateApplication(this.library3, false);
    }

    @Test
    public void testLibraryDynamicAdd() {
        this.application.getLibraries().add((Object)this.library1);
        this.doValidateApplication(this.library1, true);
        this.library1.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.doValidateApplication(this.library1, true);
        this.library1.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.doValidateApplication(this.library1, true);
        this.library1.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.doValidateApplication(this.library1, true);
        this.library1.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.doValidateApplication(this.library1, true);
        this.library1.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.doValidateApplication(this.library1, true);
        this.library1.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.doValidateApplication(this.library1, true);
        this.library1.getImages().add((Object)UiFactory.eINSTANCE.createImage());
        this.doValidateApplication(this.library1, true);
    }

    @Test
    public void testLibraryDynamicRemove() {
        ViewProfile createViewProfile;
        this.application.getLibraries().add((Object)this.library1);
        this.doValidateApplication(this.library1, true);
        Command command = PMFFactory.eINSTANCE.createCommand();
        this.library1.getCommands().add((Object)command);
        this.doValidateApplication(this.library1, true);
        this.library1.getCommands().remove((Object)command);
        Assert.assertTrue((String)"Command removed from application", (!this.application.getAllCommands().contains((Object)command) ? 1 : 0) != 0);
        DataConverter converter = PMFFactory.eINSTANCE.createDataConverter();
        this.library1.getConverters().add((Object)converter);
        this.doValidateApplication(this.library1, true);
        this.library1.getConverters().remove((Object)converter);
        Assert.assertTrue((String)"Converter removed from application", (!this.application.getAllConverters().contains((Object)converter) ? 1 : 0) != 0);
        SystemAction systemAction = PMFFactory.eINSTANCE.createSystemAction();
        this.library1.getSystemActions().add((Object)systemAction);
        this.doValidateApplication(this.library1, true);
        this.library1.getSystemActions().remove((Object)systemAction);
        Assert.assertTrue((String)"SystemAction removed from application", (!this.application.getAllSystemActions().contains((Object)systemAction) ? 1 : 0) != 0);
        EMFType dataType = PEMFFactory.eINSTANCE.createEMFType();
        this.library1.getTypes().add((Object)dataType);
        this.doValidateApplication(this.library1, true);
        this.library1.getTypes().remove((Object)dataType);
        Assert.assertTrue((String)"DataType removed from application", (!this.application.getAllTypes().contains((Object)dataType) ? 1 : 0) != 0);
        Validator validator = PMFFactory.eINSTANCE.createValidator();
        this.library1.getValidators().add((Object)validator);
        this.doValidateApplication(this.library1, true);
        this.library1.getValidators().remove((Object)validator);
        Assert.assertTrue((String)"Validator removed from application", (!this.application.getAllValidators().contains((Object)validator) ? 1 : 0) != 0);
        ViewProfile viewProfile = createViewProfile = PMFFactory.eINSTANCE.createViewProfile();
        this.library1.getViewProfiles().add((Object)viewProfile);
        this.doValidateApplication(this.library1, true);
        this.library1.getViewProfiles().remove((Object)viewProfile);
        Assert.assertTrue((String)"ViewProfile removed from application", (!this.application.getAllViewProfiles().contains((Object)viewProfile) ? 1 : 0) != 0);
        Image image = UiFactory.eINSTANCE.createImage();
        this.library1.getImages().add((Object)image);
        this.doValidateApplication(this.library1, true);
        this.library1.getImages().remove((Object)image);
        Assert.assertTrue((String)"Image removed from application", (!this.application.getAllImages().contains((Object)image) ? 1 : 0) != 0);
    }

    @Test
    public void testLibrarySelfDynamicAdd() {
        this.application.getCommands().add((Object)PMFFactory.eINSTANCE.createCommand());
        this.doValidateApplication((Library)this.application, true);
        this.application.getConverters().add((Object)PMFFactory.eINSTANCE.createDataConverter());
        this.doValidateApplication((Library)this.application, true);
        this.application.getSystemActions().add((Object)PMFFactory.eINSTANCE.createSystemAction());
        this.doValidateApplication((Library)this.application, true);
        this.application.getTypes().add((Object)PEMFFactory.eINSTANCE.createEMFType());
        this.doValidateApplication((Library)this.application, true);
        this.application.getValidators().add((Object)PMFFactory.eINSTANCE.createValidator());
        this.doValidateApplication((Library)this.application, true);
        this.application.getViewProfiles().add((Object)PMFFactory.eINSTANCE.createViewProfile());
        this.doValidateApplication((Library)this.application, true);
        this.application.getImages().add((Object)UiFactory.eINSTANCE.createImage());
        this.doValidateApplication((Library)this.application, true);
    }

    @Test
    public void testLibrarySelfDynamicRemove() {
        ViewProfile createViewProfile;
        Command command = PMFFactory.eINSTANCE.createCommand();
        this.application.getCommands().add((Object)command);
        this.doValidateApplication((Library)this.application, true);
        this.application.getCommands().remove((Object)command);
        Assert.assertTrue((String)"Command removed from application", (!this.application.getAllCommands().contains((Object)command) ? 1 : 0) != 0);
        DataConverter converter = PMFFactory.eINSTANCE.createDataConverter();
        this.application.getConverters().add((Object)converter);
        this.doValidateApplication((Library)this.application, true);
        this.application.getConverters().remove((Object)converter);
        Assert.assertTrue((String)"Converter removed from application", (!this.application.getAllConverters().contains((Object)converter) ? 1 : 0) != 0);
        SystemAction systemAction = PMFFactory.eINSTANCE.createSystemAction();
        this.application.getSystemActions().add((Object)systemAction);
        this.doValidateApplication((Library)this.application, true);
        this.application.getSystemActions().remove((Object)systemAction);
        Assert.assertTrue((String)"SystemAction removed from application", (!this.application.getAllSystemActions().contains((Object)systemAction) ? 1 : 0) != 0);
        EMFType dataType = PEMFFactory.eINSTANCE.createEMFType();
        this.application.getTypes().add((Object)dataType);
        this.doValidateApplication((Library)this.application, true);
        this.application.getTypes().remove((Object)dataType);
        Assert.assertTrue((String)"DataType removed from application", (!this.application.getAllTypes().contains((Object)dataType) ? 1 : 0) != 0);
        Validator validator = PMFFactory.eINSTANCE.createValidator();
        this.application.getValidators().add((Object)validator);
        this.doValidateApplication((Library)this.application, true);
        this.application.getValidators().remove((Object)validator);
        Assert.assertTrue((String)"Validator removed from application", (!this.application.getAllValidators().contains((Object)validator) ? 1 : 0) != 0);
        ViewProfile viewProfile = createViewProfile = PMFFactory.eINSTANCE.createViewProfile();
        this.application.getViewProfiles().add((Object)viewProfile);
        this.doValidateApplication((Library)this.application, true);
        this.application.getViewProfiles().remove((Object)viewProfile);
        Assert.assertTrue((String)"ViewProfile removed from application", (!this.application.getAllViewProfiles().contains((Object)viewProfile) ? 1 : 0) != 0);
        Image image = UiFactory.eINSTANCE.createImage();
        this.application.getImages().add((Object)image);
        this.doValidateApplication((Library)this.application, true);
        this.application.getImages().remove((Object)image);
        Assert.assertTrue((String)"Image removed from application", (!this.application.getAllImages().contains((Object)image) ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveLibraryWithReferences() {
        block5: {
            block4: {
                this.application.getLibraries().add((Object)this.library1);
                this.doValidateApplication(this.library1, true);
                Command command = PMFFactory.eINSTANCE.createCommand();
                this.library1.getCommands().add((Object)command);
                SystemAction action = PMFFactory.eINSTANCE.createSystemAction();
                action.setCommands(command);
                this.application.getSystemActions().add((Object)action);
                try {
                    this.application.getLibraries().remove((Object)this.library1);
                }
                catch (Exception e) {
                    if (e instanceof PMFException && "The library can not be removed because there's one or more object(s) had been used by current application.".equals(((PMFException)e).getMessage())) break block4;
                    Assert.fail((String)e.getMessage());
                }
            }
            this.doValidateApplication(this.library1, true);
            try {
                this.application.getLibraries().removeAll(Collections.singleton(this.library1));
            }
            catch (Exception e) {
                if (e instanceof PMFException && "The library can not be removed because there's one or more object(s) had been used by current application.".equals(((PMFException)e).getMessage())) break block5;
                Assert.fail((String)e.getMessage());
            }
        }
        this.doValidateApplication(this.library1, true);
    }
}

