/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.lang.intrinsics.IntrinsicProcDescription;
import org.eclipse.photran.internal.core.lang.intrinsics.Intrinsics;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.preferences.FortranRGBPreference;
import org.eclipse.photran.internal.ui.editor.SalesScanKeywordRule;
import org.eclipse.swt.graphics.Color;

public class FortranKeywordRuleBasedScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"ACCESS", "ACTION", "ADVANCE", "ALLOCATABLE", "ALLOCATE", "ASSIGN", "ASSIGNMENT", "ASSOCIATE", "ASYNCHRONOUS", "BACKSPACE", "BIND", "BLANK", "BLOCK", "BLOCKDATA", "CALL", "CASE", "CLOSE", "CLASS", "COMMON", "CONTAINS", "CONTINUE", "CYCLE", "DATA", "DEALLOCATE", "DEFAULT", "DELIM", "DIMENSION", "DIRECT", "DO", "DOUBLE", "DOUBLECOMPLEX", "DOUBLEPRECISION", "ELEMENTAL", "ELSE", "ELSEIF", "ELSEWHERE", "END", "ENDBLOCK", "ENDBLOCKDATA", "ENDDO", "ENDFILE", "ENDIF", "ENDWHERE", "ENTRY", "EOR", "EQUIVALENCE", "ERR", "EXIST", "EXIT", "EXTENDS", "EXTENSIBLE", "EXTERNAL", "FILE", "FMT", "FLUSH", "FORALL", "FORM", "FORMAT", "FORMATTED", "FUNCTION", "GO", "GOTO", "IF", "IMPLICIT", "IN", "INOUT", "INCLUDE", "INQUIRE", "INTENT", "INTERFACE", "INTRINSIC", "IOLENGTH", "IOSTAT", "INSTRINSIC", "KIND", "LEN", "MODULE", "NAME", "NAMED", "NAMELIST", "NEXTREC", "NML", "NONE", "NON_OVERRIDABLE", "NOPASS", "NULLIFY", "NUMBER", "ONLY", "OPEN", "OPENED", "OPERATOR", "OPTIONAL", "OUT", "PAD", "PARAMETER", "PASS", "PAUSE", "POINTER", "POSITION", "PRECISION", "PRINT", "PRIVATE", "PROCEDURE", "PROGRAM", "PROTECTED", "PUBLIC", "PURE", "READ", "READWRITE", "REC", "RECL", "RECURSIVE", "RESULT", "RETURN", "REWIND", "SAVE", "SELECT", "SEQUENCE", "SEQUENTIAL", "SIZE", "STAT", "STATUS", "STOP", "SUBROUTINE", "TARGET", "THEN", "TO", "TYPE", "UNFORMATTED", "UNIT", "USE", "VOLATILE", "WHERE", "WHILE", "WRITE", "EXTENDS", "ABSTRACT", "BIND", "GENERIC", "PASS", "NOPASS", "NON_OVERRIDABLE", "DEFERRED", "FINAL", "ENUM", "ENUMERATOR", "CLASS", "VALUE", "ASSOCIATE", "IS", "WAIT", "NON_INTRINSIC", "IMPORT", "SUBMODULE", "ENDSUBMODULE", "ENDPROCEDURE", "IMPURE", "CODIMENSION", "CONTIGUOUS", "CRITICAL", "ENDCRITICAL", "ALL", "ALLSTOP", "SYNC", "SYNCALL", "SYNCIMAGES", "IMAGES", "SYNCMEMORY", "MEMORY", "LOCK", "UNLOCK", "CONCURRENT", "STRUCTURE", "RECORD", "FILL", "UNION", "MAP", "BYTE"};
    private static String[] fgTextualOperators = new String[]{"AND", "EQ", "EQV", "FALSE", "GE", "GT", "LE", "LT", "NE", "NEQV", "NOT", "OR", "TRUE"};
    private static String[] fgTypes = new String[]{"REAL", "INTEGER", "CHARACTER", "LOGICAL", "COMPLEX"};
    private static String[] fgPreprocessor = new String[]{"INCLUDE", "#include", "#error", "#warning", "#pragma", "#ifdef", "#ifndef", "#if", "#else", "#elif", "#endif", "#line"};
    private Token colorCommentDirectives = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_COMMENT_DIRECTIVES);
    private Token colorCpp = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_CPP);
    private Token colorStrings = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_STRINGS);
    private Token colorComments = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_COMMENTS);
    private Token colorIdentifiers = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_IDENTIFIERS);
    private Token colorIntrinsics = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_INTRINSICS);
    private Token colorKeywords = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_KEYWORDS);
    private Token colorNumbersAndPunctuation = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_NUMBERS_PUNCTUATION);

    private static Token createTokenFromRGBPreference(FortranRGBPreference p) {
        int style = p == FortranPreferences.COLOR_KEYWORDS || p == FortranPreferences.COLOR_CPP ? 1 : (p == FortranPreferences.COLOR_INTRINSICS ? 2 : 0);
        return new Token((Object)new TextAttribute(new Color(null, p.getValue()), null, style));
    }

    public FortranKeywordRuleBasedScanner(boolean isFixedForm, ISourceViewer sourceViewer) {
        FortranCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceChangeListener(sourceViewer));
        IRule[] rules = new IRule[isFixedForm ? 11 : 6];
        int i = 0;
        rules[i++] = new EndOfLineRule("#", (IToken)this.colorCpp);
        rules[i++] = new MultiLineRule("\"", "\"", (IToken)this.colorStrings);
        rules[i++] = new MultiLineRule("'", "'", (IToken)this.colorStrings);
        rules[i++] = new EndOfLineRule("!", (IToken)this.colorComments);
        if (isFixedForm) {
            char[] cArray = new char[]{'c', 'C', '!', '*'};
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                EndOfLineRule c1 = new EndOfLineRule(new String(new char[]{ch}), (IToken)this.colorComments);
                c1.setColumnConstraint(0);
                rules[i++] = c1;
                ++n2;
            }
            FixedFormColumnCommentRule c3 = new FixedFormColumnCommentRule();
            rules[i++] = c3;
        }
        Eclipse33WordRule wordRule = new Eclipse33WordRule(new FortranWordDetector(), Token.UNDEFINED, true);
        SalesScanKeywordRule salesRule = new SalesScanKeywordRule(new FortranWordDetector(), (IToken)this.colorIdentifiers, sourceViewer);
        this.createSpecialWordRules(salesRule, wordRule);
        rules[i++] = wordRule;
        rules[i++] = salesRule;
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)this.colorNumbersAndPunctuation);
    }

    private void createSpecialWordRules(SalesScanKeywordRule salesRule, Eclipse33WordRule wordRule) {
        int i = 0;
        while (i < fgTextualOperators.length) {
            wordRule.addWord(fgTextualOperators[i], (IToken)this.colorKeywords);
            ++i;
        }
        for (IntrinsicProcDescription proc : Intrinsics.getAllIntrinsicProcedures()) {
            salesRule.addIdentifier(proc.genericName, (IToken)this.colorIntrinsics);
        }
        i = 0;
        while (i < fgPreprocessor.length) {
            salesRule.addWord(fgPreprocessor[i], (IToken)this.colorKeywords);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            salesRule.addWord(fgTypes[i], (IToken)this.colorKeywords);
            ++i;
        }
        i = 0;
        while (i < fgKeywords.length) {
            salesRule.addWord(fgKeywords[i], (IToken)this.colorKeywords);
            ++i;
        }
    }

    private static class Eclipse33WordRule
    implements IRule {
        protected static final int UNDEFINED = -1;
        protected IWordDetector fDetector;
        protected IToken fDefaultToken;
        protected int fColumn = -1;
        protected Map<String, IToken> fWords = new HashMap<String, IToken>();
        private StringBuffer fBuffer = new StringBuffer();
        private boolean fIgnoreCase = false;

        public Eclipse33WordRule(IWordDetector detector) {
            this(detector, Token.UNDEFINED, false);
        }

        public Eclipse33WordRule(IWordDetector detector, IToken defaultToken) {
            this(detector, defaultToken, false);
        }

        public Eclipse33WordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            Assert.isNotNull((Object)detector);
            Assert.isNotNull((Object)defaultToken);
            this.fDetector = detector;
            this.fDefaultToken = defaultToken;
            this.fIgnoreCase = ignoreCase;
        }

        public void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            this.fWords.put(word, token);
        }

        public void setColumnConstraint(int column) {
            if (column < 0) {
                column = -1;
            }
            this.fColumn = column;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
                scanner.unread();
                String buffer = this.fBuffer.toString();
                IToken token = this.fWords.get(buffer);
                if (this.fIgnoreCase) {
                    for (String key : this.fWords.keySet()) {
                        if (!buffer.equalsIgnoreCase(key)) continue;
                        token = this.fWords.get(key);
                        break;
                    }
                } else {
                    token = this.fWords.get(buffer);
                }
                if (token != null) {
                    return token;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unreadBuffer(scanner);
                }
                return this.fDefaultToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        protected void unreadBuffer(ICharacterScanner scanner) {
            int i = this.fBuffer.length() - 1;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
        }
    }

    private final class FixedFormColumnCommentRule
    implements IRule {
        private FixedFormColumnCommentRule() {
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int commentColumn = FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue();
            IToken result = Token.UNDEFINED;
            scanner.read();
            if (scanner.getColumn() > commentColumn) {
                result = FortranKeywordRuleBasedScanner.this.colorComments;
                do {
                    scanner.read();
                } while (scanner.getColumn() > commentColumn);
            }
            scanner.unread();
            return result;
        }
    }

    private static final class FortranWordDetector
    implements IWordDetector {
        private FortranWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private final class PreferenceChangeListener
    implements Preferences.IPropertyChangeListener {
        private ISourceViewer sourceViewer;

        PreferenceChangeListener(ISourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String newVal;
            String property = event.getProperty();
            String string = newVal = event.getNewValue() instanceof String ? (String)event.getNewValue() : null;
            if (property.equals(FortranPreferences.COLOR_COMMENTS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorComments, newVal);
            } else if (property.equals(FortranPreferences.COLOR_COMMENT_DIRECTIVES.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorCommentDirectives, newVal);
            } else if (property.equals(FortranPreferences.COLOR_CPP.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorCpp, newVal);
            } else if (property.equals(FortranPreferences.COLOR_STRINGS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorStrings, newVal);
            } else if (property.equals(FortranPreferences.COLOR_IDENTIFIERS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorIdentifiers, newVal);
            } else if (property.equals(FortranPreferences.COLOR_INTRINSICS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorIntrinsics, newVal);
            } else if (property.equals(FortranPreferences.COLOR_KEYWORDS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorKeywords, newVal);
            } else if (property.equals(FortranPreferences.COLOR_NUMBERS_PUNCTUATION.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorNumbersAndPunctuation, newVal);
            }
        }

        private void updateToken(Token token, String newColor) {
            Object data = token.getData();
            if (data instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(new Color(null, StringConverter.asRGB((String)newColor)), oldAttr.getBackground(), oldAttr.getStyle()));
            }
            this.sourceViewer.invalidateTextPresentation();
        }
    }
}

