/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.queries.FieldResult;

public class FieldResultMetadata
extends ORMetadata {
    private String m_name;
    private String m_column;

    public FieldResultMetadata() {
        super("<field-result>");
    }

    public FieldResultMetadata(MetadataAnnotation fieldResult, MetadataAccessor accessor) {
        super(fieldResult, accessor);
        this.m_name = fieldResult.getAttributeString("name");
        this.m_column = fieldResult.getAttributeString("column");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof FieldResultMetadata) {
            FieldResultMetadata fieldResult = (FieldResultMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, fieldResult.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_column, fieldResult.getColumn());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_name != null ? this.m_name.hashCode() : 0;
        result = 31 * result + (this.m_column != null ? this.m_column.hashCode() : 0);
        return result;
    }

    public String getColumn() {
        return this.m_column;
    }

    public String getName() {
        return this.m_name;
    }

    public FieldResult process() {
        DatabaseField field = new DatabaseField();
        this.setFieldName(field, this.getColumn());
        return new FieldResult(this.getName(), field);
    }

    public void setColumn(String column) {
        this.m_column = column;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

