/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.documentation.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.views.documentation.messages.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DocumentationResourceEditor
implements SelectionListener {
    private static final String DELETE_ICON = "/icons/Delete_12x12.gif";
    public static final String REMOTE_ICON = "icons/Remote.gif";
    public static final String BROWSE_WORKSPACE_ICON = "icons/browse-workspace_12x12.png";
    public static final String BROWSE_FILE_SYSTEM_ICON = "icons/browse-filesystem_12x12.png";
    private static final String HTTP = "http://";
    TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
    private Composite toolbar;
    private Button browseFileSystemButton;
    private Button browseWorkspaceButton;
    private Button removeButton;
    private Button addRemoteButton;
    private List<String> resources = new ArrayList<String>();
    private TableViewer tableViewer;
    private ILabelProvider labelProvider;

    public DocumentationResourceEditor(Composite parent) {
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.labelProvider = labelProviderService.getLabelProvider();
        Composite composite = this.widgetFactory.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.toolbar = this.widgetFactory.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.toolbar);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(5).applyTo(this.toolbar);
        CLabel fillerComposite = this.widgetFactory.createCLabel(this.toolbar, Messages.DocumentationResourceEditor_Message);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fillerComposite);
        this.createListControls();
        Table table = new Table(composite, 68354);
        table.addSelectionListener((SelectionListener)this);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput(this.resources);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        composite.layout(true);
        this.toolbar.setBackground(Display.getCurrent().getSystemColor(13));
    }

    protected void createListControls() {
        this.addRemoteButton = this.createButton(Activator.getDefault().getImageFromPlugin(REMOTE_ICON), Messages.DocumentationResourceEditor_AddButtonTooltip);
        this.browseFileSystemButton = this.createButton(Activator.getDefault().getImageFromPlugin(BROWSE_FILE_SYSTEM_ICON), Messages.DocumentationResourceEditor_BrowseSystemButtonTooltip);
        this.browseWorkspaceButton = this.createButton(Activator.getDefault().getImageFromPlugin(BROWSE_WORKSPACE_ICON), Messages.DocumentationResourceEditor_BrowseWSButtonTooltip);
        this.removeButton = this.createButton(Activator.getDefault().getImage(DELETE_ICON), Messages.DocumentationResourceEditor_RemoveButtonTootip);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.toolbar, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)button);
        return button;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.browseFileSystemButton) {
            this.browseFileSystem();
        } else if (e.widget == this.browseWorkspaceButton) {
            this.browseWorkspace();
        } else if (e.widget == this.addRemoteButton) {
            this.addRemote();
        } else if (e.widget == this.removeButton) {
            this.remove();
        }
        this.refresh();
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() > 0) {
            TableItem[] selectedResources = this.tableViewer.getTable().getSelection();
            int i = 0;
            while (i < selectedResources.length) {
                TableItem selectedItem = selectedResources[i];
                Table parentTable = selectedItem.getParent();
                int index = parentTable.indexOf(selectedItem);
                parentTable.remove(index);
                this.resources.remove(index);
                ++i;
            }
        }
    }

    protected void browseFileSystem() {
        FileDialog dialog = new FileDialog(this.toolbar.getShell(), 4098);
        dialog.setText(Messages.DocumentationResourceEditor_AddFileSystemDialogTitle);
        if (dialog.open() != null) {
            String filterPath = dialog.getFilterPath();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                this.resources.add(String.valueOf(filterPath) + File.separator + fileName);
                ++n2;
            }
        }
    }

    protected void browseWorkspace() {
        Object[] result;
        ReferenceSelector selector = new ReferenceSelector();
        selector.setLabelProvider(this.labelProvider);
        WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
        contentProvider.setExtensionFilters(new LinkedHashMap());
        selector.setContentProvider((IStaticContentProvider)contentProvider);
        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(this.toolbar.getShell(), (IElementSelector)selector);
        dialog.setTitle(Messages.DocumentationResourceEditor_AddWSDialogTitle);
        dialog.setLabelProvider(this.labelProvider);
        dialog.setOrdered(true);
        dialog.setUnique(true);
        selector.setUnique(true);
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length > 0) {
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (file instanceof IFile) {
                    this.resources.add(FileUtil.getPath((IFile)((IFile)file), (boolean)false));
                }
                ++n2;
            }
        }
    }

    protected void addRemote() {
        InputDialog dialog = new InputDialog(this.toolbar.getShell(), Messages.DocumentationResourceEditor_AddRemoteDialogTitle, Messages.DocumentationResourceEditor_AddRemoteDialogMessage, HTTP, null);
        if (0 == dialog.open() && dialog.getResult().length > 0) {
            this.resources.add((String)dialog.getResult()[0]);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.edit();
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (1 == selection.size()) {
            String newValue;
            TableItem selectedItem = this.tableViewer.getTable().getSelection()[0];
            Table parentTable = selectedItem.getParent();
            int index = parentTable.indexOf(selectedItem);
            Object currentValue = selection.getFirstElement();
            InputDialog dialog = new InputDialog(this.toolbar.getShell(), Messages.DocumentationResourceEditor_EditResourceDialogTitle, Messages.DocumentationResourceEditor_EditResourceDialogMessage, (String)currentValue, null);
            if (0 == dialog.open() && dialog.getResult().length > 0 && (newValue = (String)dialog.getResult()[0]) != currentValue && newValue != null) {
                this.resources.remove(index);
                this.resources.add(index, newValue);
            }
        }
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
        this.refresh();
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void refresh() {
        this.tableViewer.setInput(this.resources);
        this.tableViewer.refresh();
    }
}

