/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.emf.CustomizationComparator;
import org.eclipse.papyrus.infra.emf.readonly.spi.IReadOnlyManagerProcessor;
import org.eclipse.papyrus.infra.emf.spi.resolver.IEObjectResolver;
import org.eclipse.papyrus.infra.ui.internal.emf.readonly.EditorReloadProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    private static final String DEFAULT_LOADED_FACET = "defaultLoadedFacet";
    private static final String SEPARATOR_DEFAULT_LOADED_FACET = ",";
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.ui.emf";
    public static final String CUSTOMIZATION_MANAGER_SECTION = "org.eclipse.papyrus.infra.ui.emf.customizationManager";
    private static final String LOADED_FACET_ORDER = "org.eclipse.papyrus.infra.ui.emf.facet.order";
    private static Activator plugin;
    public static LogHelper log;
    private ServiceRegistration<IEObjectResolver> eobjectResolverReg;
    private ServiceRegistration<IReadOnlyManagerProcessor> roManagerProcessorReg;
    private ICustomizationManager customizationManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.eobjectResolverReg = context.registerService(IEObjectResolver.class, CustomizedContentProviderUtils::resolve, null);
        this.roManagerProcessorReg = context.registerService(IReadOnlyManagerProcessor.class, (Object)new EditorReloadProcessor(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.roManagerProcessorReg != null) {
            this.roManagerProcessorReg.unregister();
            this.roManagerProcessorReg = null;
        }
        if (this.eobjectResolverReg != null) {
            this.eobjectResolverReg.unregister();
            this.eobjectResolverReg = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void saveCustomizationManagerState() {
        IDialogSettings dialogSettings = this.getBrowserCustomizationDialogSettings();
        List appliedCustomizations = this.getCustomizationManager().getManagedCustomizations();
        List registeredCustomizations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.getCustomizationManager().getResourceSet()).getRegisteredCustomizations();
        for (Customization customization2 : registeredCustomizations) {
            boolean isApplied = appliedCustomizations.contains(customization2);
            String settingKey = this.getSettingKey(customization2);
            dialogSettings.put(settingKey, isApplied);
        }
        ArrayList customizationList = new ArrayList();
        customizationList.addAll(appliedCustomizations);
        String[] loadedCustomizationArray = (String[])customizationList.stream().map(customization -> customization.eResource().getURI().toString()).toArray(String[]::new);
        dialogSettings.put(LOADED_FACET_ORDER, loadedCustomizationArray);
    }

    private String getSettingKey(Customization customization) {
        return customization.eResource().getURI().toString();
    }

    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(CUSTOMIZATION_MANAGER_SECTION);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(CUSTOMIZATION_MANAGER_SECTION);
            String loadedFacetPreferences = Activator.getDefault().getPreferenceStore().getString(DEFAULT_LOADED_FACET);
            if (loadedFacetPreferences != null && !"".equals(loadedFacetPreferences)) {
                settings.put(LOADED_FACET_ORDER, loadedFacetPreferences.split(SEPARATOR_DEFAULT_LOADED_FACET));
            }
        }
        return settings;
    }

    private void init(ICustomizationManager customizationManager) {
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        try {
            ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(customizationManager.getResourceSet());
            List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
            List<Object> orderedCustomizationList = new ArrayList<Customization>();
            for (Customization customization : registryAllCustomizations) {
                String settingKey = this.getSettingKey(customization);
                boolean isActive = settings.get(settingKey) == null ? customization.isMustBeLoadedByDefault() : settings.getBoolean(settingKey);
                if (!isActive) continue;
                orderedCustomizationList.add(customization);
            }
            String[] loadedFacetOrder = settings.getArray(LOADED_FACET_ORDER);
            if (loadedFacetOrder != null && loadedFacetOrder.length > 0) {
                Map<String, Customization> mapProp = registryAllCustomizations.stream().collect(Collectors.toMap(e -> this.getSettingKey((Customization)e), e -> e));
                Stream<String> stream = Arrays.stream(loadedFacetOrder);
                Stream<Customization> map = stream.map(id -> (Customization)mapProp.get(id.trim()));
                orderedCustomizationList = map.collect(Collectors.toList());
            } else {
                Collections.sort(orderedCustomizationList, new CustomizationComparator());
            }
            customizationManager.getManagedCustomizations().addAll(orderedCustomizationList);
        }
        catch (Throwable e2) {
            log.log((IStatus)new Status(4, PLUGIN_ID, "Error initializing customizations", e2));
        }
    }

    public void restoreDefaultCustomizationManager() {
        DialogSettings settings = (DialogSettings)this.getDialogSettings();
        settings.removeSection(CUSTOMIZATION_MANAGER_SECTION);
    }

    public ICustomizationManager getCustomizationManager() {
        if (this.customizationManager == null) {
            this.customizationManager = org.eclipse.papyrus.infra.emf.Activator.getDefault().getCustomizationManager();
            this.init(this.getCustomizationManager());
        }
        return this.customizationManager;
    }

    public static Image getPluginIconImage(String pluginId, String iconPath) {
        String key = String.valueOf(pluginId) + iconPath;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }
}

