/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;
import java.util.RandomAccess;
import org.eclipse.net4j.util.collection.BidirectionalIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowingRandomAccessList<E>
extends AbstractList<E>
implements Queue<E>,
RandomAccess {
    private final Class<E> componentType;
    private final int pageCapacity;
    private List<E[]> pages = new ArrayList<E[]>();
    private int firstFree;
    private int lastFree;

    public GrowingRandomAccessList(Class<E> componentType, int pageCapacity) {
        this.componentType = componentType;
        this.pageCapacity = pageCapacity;
    }

    @Override
    public E get(int index) {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        E[] page = this.getPage(index += this.firstFree);
        return page[index % this.pageCapacity];
    }

    @Override
    public int size() {
        return this.pages.size() * this.pageCapacity - this.firstFree - this.lastFree;
    }

    @Override
    public void addFirst(E e) {
        E[] page;
        if (this.firstFree == 0) {
            if (this.pages.isEmpty()) {
                this.initFirstPage();
            } else {
                this.firstFree = this.pageCapacity;
            }
            page = this.createPage();
            this.pages.add(0, page);
        } else {
            page = this.pages.get(0);
        }
        page[--this.firstFree] = e;
    }

    @Override
    public void addLast(E e) {
        E[] page;
        if (this.lastFree == 0) {
            if (this.pages.isEmpty()) {
                this.initFirstPage();
            } else {
                this.lastFree = this.pageCapacity;
            }
            page = this.createPage();
            this.pages.add(page);
        } else {
            int size = this.pages.size();
            page = this.pages.get(size - 1);
        }
        page[this.pageCapacity - this.lastFree--] = e;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        int size = this.size();
        if (index > size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        if (index == 0) {
            this.addFirst(element);
        } else if (index == size) {
            this.addLast(element);
        } else {
            GrowingRandomAccessList<E> result = new GrowingRandomAccessList<E>(this.componentType, this.pageCapacity);
            int i = 0;
            while (i < size) {
                E e = this.get(i);
                if (i == index) {
                    result.add(element);
                }
                result.add(e);
                ++i;
            }
            this.pages = result.pages;
            this.firstFree = result.firstFree;
            this.lastFree = result.lastFree;
        }
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeLast() {
        throw new UnsupportedOperationException();
    }

    public E pollFirst() {
        throw new UnsupportedOperationException();
    }

    public E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getFirst() {
        return this.get(0);
    }

    @Override
    public E getLast() {
        return this.get(this.size() - 1);
    }

    public E peekFirst() {
        if (this.pages.isEmpty()) {
            return null;
        }
        return this.getFirst();
    }

    public E peekLast() {
        if (this.pages.isEmpty()) {
            return null;
        }
        return this.getLast();
    }

    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        throw new UnsupportedOperationException();
    }

    public Iterator<E> descendingIterator() {
        ListIterator delegate = this.listIterator(this.size() - 1);
        return new BidirectionalIterator(delegate, true);
    }

    protected E[] createPage() {
        Object[] page = (Object[])Array.newInstance(this.componentType, this.pageCapacity);
        return page;
    }

    protected E[] getPage(int index) {
        return this.pages.get(this.getPageIndex(index));
    }

    protected int getPageIndex(int index) {
        return index / this.pageCapacity;
    }

    private void initFirstPage() {
        int centerIndex = (this.pageCapacity - 1) / 2;
        this.firstFree = centerIndex + 1;
        this.lastFree = this.pageCapacity - centerIndex - 1;
    }
}

