/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.HprofPlugin;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.io.PositionInputStream;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.MultipleSnapshotsException;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class Pass1Parser
extends AbstractParser {
    private static final Pattern PATTERN_OBJ_ARRAY = Pattern.compile("^(\\[+)L(.*);$");
    private static final Pattern PATTERN_PRIMITIVE_ARRAY = Pattern.compile("^(\\[+)(.)$");
    private HashMapLongObject<String> class2name = new HashMapLongObject();
    private HashMapLongObject<Long> thread2id = new HashMapLongObject();
    private HashMapLongObject<StackFrame> id2frame = new HashMapLongObject();
    private HashMapLongObject<StackTrace> serNum2stackTrace = new HashMapLongObject();
    private HashMapLongObject<Long> classSerNum2id = new HashMapLongObject();
    private HashMapLongObject<List<JavaLocal>> thread2locals = new HashMapLongObject();
    private IHprofParserHandler handler;
    private SimpleMonitor.Listener monitor;
    private long previousArrayStart;
    private long previousArrayUncompressedEnd;
    private boolean foundCompressed;
    private final boolean verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/parser"));

    public Pass1Parser(IHprofParserHandler handler, SimpleMonitor.Listener monitor, HprofPreferences.HprofStrictness strictnessPreference) {
        super(strictnessPreference);
        this.handler = handler;
        this.monitor = monitor;
    }

    public void read(File file, String dumpNrToRead) throws SnapshotException, IOException {
        this.in = new PositionInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
        int currentDumpNr = 0;
        ArrayList<MultipleSnapshotsException.Context> ctxs = new ArrayList<MultipleSnapshotsException.Context>();
        boolean foundDump = false;
        try {
            this.version = Pass1Parser.readVersion((InputStream)this.in);
            this.handler.addProperty("VERSION", this.version.toString());
            this.idSize = this.in.readInt();
            if (this.idSize != 4 && this.idSize != 8) {
                throw new SnapshotException(Messages.Pass1Parser_Error_SupportedDumps);
            }
            this.handler.addProperty("ID_SIZE", String.valueOf(this.idSize));
            long date = this.in.readLong();
            long prevTimeOffset = 0L;
            long timeWrap = 0L;
            long fileSize = file.length();
            long curPos = this.in.position();
            while (curPos < fileSize) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(curPos / 1000L);
                int record = this.in.readUnsignedByte();
                long timeOffset = this.readUnsignedInt();
                if (timeOffset < prevTimeOffset) {
                    timeWrap += 0x100000000L;
                }
                prevTimeOffset = timeOffset;
                long length = this.readUnsignedInt();
                if (this.verbose) {
                    System.out.println("Read record type " + record + ", length " + length + " at position 0x" + Long.toHexString(curPos));
                }
                if ((length = this.updateLengthIfNecessary(fileSize, curPos, record, length, this.monitor)) < 0L) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, this.in.position(), record}));
                }
                if (curPos + length - 9L > fileSize) {
                    switch (this.strictnessPreference) {
                        case STRICTNESS_STOP: {
                            throw new SnapshotException(Messages.HPROFStrictness_Stopped, (Throwable)new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_invalidHPROFFile, (Object[])new Object[]{length, fileSize - curPos - 9L})));
                        }
                        case STRICTNESS_WARNING: 
                        case STRICTNESS_PERMISSIVE: {
                            this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_Error_invalidHPROFFile, (Object[])new Object[]{length, fileSize - curPos - 9L}), null);
                            break;
                        }
                        default: {
                            throw new SnapshotException(Messages.HPROFStrictness_Unhandled_Preference);
                        }
                    }
                }
                block7 : switch (record) {
                    case 1: {
                        if ((int)(length - (long)this.idSize) < 0) {
                            throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, this.in.position(), record}));
                        }
                        this.readString(length);
                        break;
                    }
                    case 2: {
                        this.readLoadClass();
                        break;
                    }
                    case 4: {
                        this.readStackFrame(length);
                        break;
                    }
                    case 5: {
                        this.readStackTrace(length);
                        break;
                    }
                    case 12: 
                    case 28: {
                        long dumpTime = date + (timeWrap + timeOffset) / 1000L;
                        if (this.dumpMatches(currentDumpNr, dumpNrToRead)) {
                            if (!foundDump) {
                                this.handler.addProperty("CREATION_DATE", String.valueOf(dumpTime));
                                foundDump = true;
                            }
                            this.readDumpSegments(length);
                        } else {
                            this.in.skipBytes(length);
                        }
                        if (ctxs.size() < currentDumpNr + 1) {
                            MultipleSnapshotsException.Context ctx = new MultipleSnapshotsException.Context(this.dumpIdentifier(currentDumpNr));
                            ctx.setDescription(MessageUtil.format((String)Messages.Pass1Parser_HeapDumpCreated, (Object[])new Object[]{new Date(dumpTime)}));
                            ctxs.add(ctx);
                        }
                        if (record != 12) break;
                        ++currentDumpNr;
                        break;
                    }
                    case 44: {
                        ++currentDumpNr;
                        this.in.skipBytes(length);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: {
                        this.in.skipBytes(length);
                        break;
                    }
                    default: {
                        switch (this.strictnessPreference) {
                            case STRICTNESS_STOP: {
                                throw new SnapshotException(Messages.HPROFStrictness_Stopped, (Throwable)new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_UnexpectedRecord, (Object[])new Object[]{Integer.toHexString(record), length})));
                            }
                            case STRICTNESS_WARNING: 
                            case STRICTNESS_PERMISSIVE: {
                                this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_UnexpectedRecord, (Object[])new Object[]{Integer.toHexString(record), length}), null);
                                this.in.skipBytes(length);
                                break block7;
                            }
                        }
                        throw new SnapshotException(Messages.HPROFStrictness_Unhandled_Preference);
                    }
                }
                curPos = this.in.position();
            }
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
        if (!foundDump) {
            throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_NoHeapDumpIndexFound, (Object[])new Object[]{currentDumpNr, file.getName(), dumpNrToRead}));
        }
        if (currentDumpNr > 1) {
            if (dumpNrToRead == null) {
                MultipleSnapshotsException mse = new MultipleSnapshotsException(MessageUtil.format((String)Messages.Pass1Parser_HeapDumpsFound, (Object[])new Object[]{currentDumpNr}));
                for (MultipleSnapshotsException.Context runtime : ctxs) {
                    mse.addContext(runtime);
                }
                throw mse;
            }
            this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_Info_UsingDumpIndex, (Object[])new Object[]{currentDumpNr, file.getName(), dumpNrToRead}), null);
        }
        if (this.serNum2stackTrace.size() > 0) {
            this.dumpThreads();
        }
    }

    private void readString(long length) throws IOException {
        long id = this.readID();
        byte[] chars = new byte[(int)(length - (long)this.idSize)];
        this.in.readFully(chars);
        this.handler.getConstantPool().put(id, (Object)new String(chars, "UTF-8"));
    }

    private void readLoadClass() throws IOException {
        long classSerNum = this.readUnsignedInt();
        long classID = this.readID();
        this.in.skipBytes(4);
        long nameID = this.readID();
        String className = this.getStringConstant(nameID).replace('/', '.');
        this.class2name.put(classID, (Object)className);
        this.classSerNum2id.put(classSerNum, (Object)classID);
    }

    private void readStackFrame(long length) throws IOException {
        long frameId = this.readID();
        long methodName = this.readID();
        long methodSig = this.readID();
        long srcFile = this.readID();
        long classSerNum = this.readUnsignedInt();
        int lineNr = this.in.readInt();
        StackFrame frame = new StackFrame(frameId, lineNr, this.getStringConstant(methodName), this.getStringConstant(methodSig), this.getStringConstant(srcFile), classSerNum);
        this.id2frame.put(frameId, (Object)frame);
    }

    private void readStackTrace(long length) throws IOException {
        long stackTraceNr = this.readUnsignedInt();
        long threadNr = this.readUnsignedInt();
        long frameCount = this.readUnsignedInt();
        long[] frameIds = new long[(int)frameCount];
        int i = 0;
        while ((long)i < frameCount) {
            frameIds[i] = this.readID();
            ++i;
        }
        StackTrace stackTrace = new StackTrace(stackTraceNr, threadNr, frameIds);
        this.serNum2stackTrace.put(stackTraceNr, (Object)stackTrace);
    }

    private void readDumpSegments(long length) throws IOException, SnapshotException {
        long segmentStartPos = this.in.position();
        long segmentsEndPos = segmentStartPos + length;
        while (segmentStartPos < segmentsEndPos) {
            long workDone = segmentStartPos / 1000L;
            if (this.monitor.getWorkDone() < workDone) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(workDone);
            }
            int segmentType = this.in.readUnsignedByte();
            if (this.verbose) {
                System.out.println("    Read heap sub-record type " + segmentType + " at position 0x" + Long.toHexString(segmentStartPos));
            }
            switch (segmentType) {
                case 255: {
                    this.readGC(1, 0);
                    break;
                }
                case 8: {
                    this.readGCThreadObject(256);
                    break;
                }
                case 1: {
                    this.readGC(128, this.idSize);
                    break;
                }
                case 2: {
                    this.readGCWithThreadContext(4, true);
                    break;
                }
                case 3: {
                    this.readGCWithThreadContext(64, true);
                    break;
                }
                case 4: {
                    this.readGCWithThreadContext(128, false);
                    break;
                }
                case 5: {
                    this.readGC(2, 0);
                    break;
                }
                case 6: {
                    this.readGC(16, 4);
                    break;
                }
                case 7: {
                    this.readGC(32, 0);
                    break;
                }
                case 32: {
                    this.readClassDump(segmentStartPos);
                    break;
                }
                case 33: {
                    this.readInstanceDump(segmentStartPos);
                    break;
                }
                case 34: {
                    this.readObjectArrayDump(segmentStartPos);
                    break;
                }
                case 35: {
                    this.readPrimitiveArrayDump(segmentStartPos);
                    break;
                }
                default: {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_InvalidHeapDumpFile, (Object[])new Object[]{segmentType, segmentStartPos}));
                }
            }
            segmentStartPos = this.in.position();
        }
        if (this.verbose) {
            System.out.println("    Finished heap sub-records.");
        }
        if (segmentStartPos != segmentsEndPos) {
            switch (this.strictnessPreference) {
                case STRICTNESS_STOP: {
                    throw new SnapshotException(Messages.HPROFStrictness_Stopped, (Throwable)new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_UnexpectedEndPosition, (Object[])new Object[]{Long.toHexString(segmentsEndPos - length), length, Long.toHexString(segmentStartPos), Long.toHexString(segmentsEndPos)})));
                }
                case STRICTNESS_WARNING: 
                case STRICTNESS_PERMISSIVE: {
                    this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_UnexpectedEndPosition, (Object[])new Object[]{Long.toHexString(segmentsEndPos - length), length, Long.toHexString(segmentStartPos), Long.toHexString(segmentsEndPos)}), null);
                    break;
                }
                default: {
                    throw new SnapshotException(Messages.HPROFStrictness_Unhandled_Preference);
                }
            }
        }
    }

    private void readGCThreadObject(int gcType) throws IOException {
        long id = this.readID();
        int threadSerialNo = this.in.readInt();
        this.thread2id.put((long)threadSerialNo, (Object)id);
        this.handler.addGCRoot(id, 0L, gcType);
        this.in.skipBytes(4);
    }

    private void readGC(int gcType, int skip) throws IOException {
        long id = this.readID();
        this.handler.addGCRoot(id, 0L, gcType);
        if (skip > 0) {
            this.in.skipBytes(skip);
        }
    }

    private void readGCWithThreadContext(int gcType, boolean hasLineInfo) throws IOException {
        long id = this.readID();
        int threadSerialNo = this.in.readInt();
        Long tid = (Long)this.thread2id.get((long)threadSerialNo);
        if (tid != null) {
            this.handler.addGCRoot(id, tid, gcType);
        } else {
            this.handler.addGCRoot(id, 0L, gcType);
        }
        if (hasLineInfo) {
            int lineNumber = this.in.readInt();
            ArrayList<JavaLocal> locals = (ArrayList<JavaLocal>)this.thread2locals.get((long)threadSerialNo);
            if (locals == null) {
                locals = new ArrayList<JavaLocal>();
                this.thread2locals.put((long)threadSerialNo, locals);
            }
            locals.add(new JavaLocal(id, lineNumber, gcType));
        }
    }

    private void readClassDump(long segmentStartPos) throws IOException {
        long address = this.readID();
        this.in.skipBytes(4);
        long superClassObjectId = this.readID();
        long classLoaderObjectId = this.readID();
        this.in.skipBytes(this.idSize * 4 + 4);
        int constantPoolSize = this.in.readUnsignedShort();
        int ii = 0;
        while (ii < constantPoolSize) {
            this.in.skipBytes(2);
            this.skipValue();
            ++ii;
        }
        int numStaticFields = this.in.readUnsignedShort();
        Field[] statics = new Field[numStaticFields];
        int ii2 = 0;
        while (ii2 < numStaticFields) {
            long nameId = this.readID();
            String name = this.getStringConstant(nameId);
            byte type = this.in.readByte();
            Object value = this.readValue(null, type);
            statics[ii2] = new Field(name, (int)type, value);
            ++ii2;
        }
        int numInstanceFields = this.in.readUnsignedShort();
        FieldDescriptor[] fields = new FieldDescriptor[numInstanceFields];
        int ii3 = 0;
        while (ii3 < numInstanceFields) {
            long nameId = this.readID();
            String name = this.getStringConstant(nameId);
            byte type = this.in.readByte();
            fields[ii3] = new FieldDescriptor(name, (int)type);
            ++ii3;
        }
        String className = (String)this.class2name.get(address);
        if (className == null) {
            className = "unknown-name@0x" + Long.toHexString(address);
        }
        if (className.charAt(0) == '[') {
            Matcher matcher = PATTERN_OBJ_ARRAY.matcher(className);
            if (matcher.matches()) {
                int l = matcher.group(1).length();
                className = matcher.group(2);
                int ii4 = 0;
                while (ii4 < l) {
                    className = String.valueOf(className) + "[]";
                    ++ii4;
                }
            }
            if ((matcher = PATTERN_PRIMITIVE_ARRAY.matcher(className)).matches()) {
                int count = matcher.group(1).length() - 1;
                className = "unknown[]";
                char signature = matcher.group(2).charAt(0);
                int ii5 = 0;
                while (ii5 < IPrimitiveArray.SIGNATURES.length) {
                    if (IPrimitiveArray.SIGNATURES[ii5] == (byte)signature) {
                        className = IPrimitiveArray.TYPE[ii5];
                        break;
                    }
                    ++ii5;
                }
                ii5 = 0;
                while (ii5 < count) {
                    className = String.valueOf(className) + "[]";
                    ++ii5;
                }
            }
        }
        ClassImpl clazz = new ClassImpl(address, className, superClassObjectId, classLoaderObjectId, statics, fields);
        this.handler.addClass(clazz, segmentStartPos);
        if (superClassObjectId != 0L && this.handler.lookupClass(superClassObjectId) == null) {
            this.handler.reportRequiredClass(superClassObjectId, Integer.MAX_VALUE);
        }
    }

    private void readInstanceDump(long segmentStartPos) throws IOException {
        long address = this.readID();
        this.handler.reportInstance(address, segmentStartPos);
        this.in.skipBytes(4);
        long classID = this.readID();
        int payload = this.in.readInt();
        IClass instanceType = this.handler.lookupClass(classID);
        if (instanceType == null) {
            this.handler.reportRequiredClass(classID, payload);
        }
        this.in.skipBytes(payload);
    }

    private void readObjectArrayDump(long segmentStartPos) throws IOException {
        long address = this.readID();
        if (!this.foundCompressed && this.idSize == 8 && address > this.previousArrayStart && address < this.previousArrayUncompressedEnd) {
            this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_DetectedCompressedReferences, (Object[])new Object[]{Long.toHexString(address), Long.toHexString(this.previousArrayStart)}), null);
            this.handler.addProperty("REF_SIZE", "4");
            this.foundCompressed = true;
        }
        this.handler.reportInstance(address, segmentStartPos);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.readID();
        IClass arrayType = this.handler.lookupClass(arrayClassObjectID);
        if (arrayType == null) {
            this.handler.reportRequiredObjectArray(arrayClassObjectID);
        }
        this.in.skipBytes((long)size * (long)this.idSize);
        this.previousArrayStart = address;
        this.previousArrayUncompressedEnd = address + 16L + (long)size * 8L;
    }

    private void readPrimitiveArrayDump(long segmentStartPos) throws SnapshotException, IOException {
        long address = this.readID();
        this.handler.reportInstance(address, segmentStartPos);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        byte elementType = this.in.readByte();
        if (elementType < 4 || elementType > 11) {
            throw new SnapshotException(Messages.Pass1Parser_Error_IllegalType);
        }
        String name = IPrimitiveArray.TYPE[elementType];
        IClass clazz = this.handler.lookupClassByName(name, true);
        if (clazz == null) {
            this.handler.reportRequiredPrimitiveArray(elementType);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[elementType];
        this.in.skipBytes((long)elementSize * (long)size);
    }

    private String getStringConstant(long address) {
        if (address == 0L) {
            return "";
        }
        String result = (String)this.handler.getConstantPool().get(address);
        return result == null ? String.valueOf(Messages.Pass1Parser_Error_UnresolvedName) + Long.toHexString(address) : result;
    }

    private void dumpThreads() {
        block16: {
            if (this.serNum2stackTrace == null || this.serNum2stackTrace.size() <= 1) {
                return;
            }
            PrintWriter out = null;
            String outputName = String.valueOf(this.handler.getSnapshotInfo().getPrefix()) + "threads";
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputName), "UTF-8"));
                    Iterator it = this.serNum2stackTrace.values();
                    while (it.hasNext()) {
                        StackTrace stack = (StackTrace)it.next();
                        Long tid = (Long)this.thread2id.get(stack.threadSerialNr);
                        if (tid == null) continue;
                        String threadId = tid == null ? "<unknown>" : "0x" + Long.toHexString(tid);
                        out.println("Thread " + threadId);
                        out.println(stack);
                        out.println("  locals:");
                        List locals = (List)this.thread2locals.get(stack.threadSerialNr);
                        if (locals != null) {
                            for (JavaLocal javaLocal : locals) {
                                out.println("    objectId=0x" + Long.toHexString(javaLocal.objectId) + ", line=" + javaLocal.lineNumber);
                            }
                        }
                        out.println();
                    }
                    out.flush();
                    this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_Info_WroteThreadsTo, (Object[])new Object[]{outputName}), null);
                }
                catch (IOException e) {
                    this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_Error_WritingThreadsInformation, (Object[])new Object[0]), (Throwable)e);
                    if (out == null) break block16;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private class JavaLocal {
        private long objectId;
        private int lineNumber;
        private int type;

        public JavaLocal(long objectId, int lineNumber, int type) {
            this.lineNumber = lineNumber;
            this.objectId = objectId;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    private class StackFrame {
        long frameId;
        String method;
        String methodSignature;
        String sourceFile;
        long classSerNum;
        int lineNr;

        public StackFrame(long frameId, int lineNr, String method, String methodSignature, String sourceFile, long classSerNum) {
            this.frameId = frameId;
            this.lineNr = lineNr;
            this.method = method;
            this.methodSignature = methodSignature;
            this.sourceFile = sourceFile;
            this.classSerNum = classSerNum;
        }

        public String toString() {
            String className = null;
            Long classId = (Long)Pass1Parser.this.classSerNum2id.get(this.classSerNum);
            className = classId == null ? "<UNKNOWN CLASS>" : (String)Pass1Parser.this.class2name.get(classId.longValue());
            String sourceLocation = "";
            if (this.lineNr > 0) {
                sourceLocation = "(" + this.sourceFile + ":" + String.valueOf(this.lineNr) + ")";
            } else if (this.lineNr == 0 || this.lineNr == -1) {
                sourceLocation = "(Unknown Source)";
            } else if (this.lineNr == -2) {
                sourceLocation = "(Compiled method)";
            } else if (this.lineNr == -3) {
                sourceLocation = "(Native Method)";
            }
            return "  at " + className + "." + this.method + this.methodSignature + " " + sourceLocation;
        }
    }

    private class StackTrace {
        private long threadSerialNr;
        private long[] frameIds;

        public StackTrace(long serialNr, long threadSerialNr, long[] frameIds) {
            this.frameIds = frameIds;
            this.threadSerialNr = threadSerialNr;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            long[] lArray = this.frameIds;
            int n = this.frameIds.length;
            int n2 = 0;
            while (n2 < n) {
                long frameId = lArray[n2];
                StackFrame frame = (StackFrame)Pass1Parser.this.id2frame.get(frameId);
                if (frame != null) {
                    b.append(frame.toString());
                    b.append("\r\n");
                }
                ++n2;
            }
            return b.toString();
        }
    }
}

