/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.refactoring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

public class CreateFileChange
extends ResourceChange {
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;
    private List<IFolder> foldersToCreate;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    private CreateFileChange(IPath path, String source, String encoding, long stampToRestore, boolean explicit) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fStampToRestore = stampToRestore;
        this.fExplicitEncoding = explicit;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        return NLS.bind((String)Messages.edit_CreateFile, (Object)this.fPath);
    }

    protected String getSource() {
        return this.fSource;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError("Unknown location for file " + file.getFullPath());
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError("File " + location + " already exists");
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        InputStream is = null;
        try {
            IFile file;
            block27: {
                pm.beginTask(NLS.bind((String)Messages.edit_CreateFile, (Object)this.fPath), 3);
                this.initializeEncoding();
                file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
                try {
                    this.foldersToCreate = new ArrayList<IFolder>();
                    IContainer parent = file.getParent();
                    while (!parent.exists() && parent.getType() == 2) {
                        this.foldersToCreate.add((IFolder)parent);
                        parent = parent.getParent();
                    }
                    Collections.reverse(this.foldersToCreate);
                    for (IFolder folder : this.foldersToCreate) {
                        folder.create(true, false, pm);
                    }
                    is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                    file.create(is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (this.fStampToRestore != -1L) {
                        file.revertModificationStamp(this.fStampToRestore);
                    }
                    if (this.fExplicitEncoding) {
                        file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        pm.worked(1);
                    }
                    if (!this.foldersToCreate.isEmpty()) break block27;
                    DeleteResourceChange deleteResourceChange = new DeleteResourceChange(file.getFullPath(), true);
                    return deleteResourceChange;
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", e.getMessage(), (Throwable)e));
                }
            }
            CompositeChange undoChange = new CompositeChange("Undo " + this.getName());
            undoChange.add((Change)new DeleteResourceChange(file.getFullPath(), true));
            Collections.reverse(this.foldersToCreate);
            for (IFolder folder : this.foldersToCreate) {
                new DeleteResourceChange(folder.getFullPath(), true);
            }
            CompositeChange compositeChange = undoChange;
            return compositeChange;
        }
        finally {
            try {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", ioe.getMessage(), (Throwable)ioe));
                }
            }
            finally {
                pm.done();
            }
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) throws OperationCanceledException {
        pm.beginTask("", 1);
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            return iFile;
        }
        finally {
            pm.done();
        }
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            if (file != null) {
                try {
                    if (file.exists()) {
                        this.fEncoding = file.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                        if (contentType != null) {
                            this.fEncoding = contentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        }
                    }
                }
                catch (CoreException e) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

